<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package    alinks
 * @license    GPL
 * @version    $Id: aLinksStruct.php 44 2008-03-24 18:00:53Z sean $
 */
/**
 * aLinks struct class
 *
 * Used as a data carrier so that class constructors don't have long
 * parameter lists.
 */
class aLinksStruct {

	var $data;
	
	function aLinksStruct() {
		$this->data = array();
	}
	
	function add($key, $value) {
		$this->data[$key] = $value;
	}
	
	function get($key) {
		if (!array_key_exists($key, $this->data)) {
			return false;
		}
		return $this->data[$key];
	}
	
	function getAll() {
		return $this->data;
	}
}