<?php
    $message = false;
    if (false == empty($_POST['onebutton']) && true == is_array($_POST['onebutton'])) {
        $options = array_map('intval', $_POST['onebutton']);
        $one_button->saveOptions($options);
        $message = true;
    }

    $options = $one_button->loadOptions();
?>

<div class="wrap">
    <h2><?php _e("OneButton Configuration", "onebutton"); ?></h2>

<?php if (true === $message) : ?>
    <div class="updated fade">
        <p><?php _e("The settings have been successfully updated", 'onebutton'); ?></p>
    </div>
<?php endif; ?>

    <form method="post" action="<?php echo wp_specialchars(stripslashes($_SERVER['REQUEST_URI'])); ?>">
        <table class="widefat">
            <tbody>
                <tr>
                    <th scope="row"><?php _e("Enable OneButton", "onebutton"); ?></th>
                    <td width="75%">
                        <label><input value="1" type="radio" name="onebutton[enable]"<?php checked(true, $options['enable']); ?>/> <?php _e('Yes', 'onebutton'); ?></label>
                        <label><input value="0" type="radio" name="onebutton[enable]"<?php checked(false, $options['enable']); ?>/> <?php _e('No', 'onebutton'); ?></label>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php _e("Add <code>nofollow</code> to the links", "onebutton"); ?></th>
                    <td>
                        <label><input value="1" type="radio" name="onebutton[<?php _e('No', 'onebutton'); ?>follow]"<?php checked(true, $options['nofollow']); ?>/> <?php _e('Yes', 'onebutton'); ?></label>
                        <label><input value="0" type="radio" name="onebutton[<?php _e('No', 'onebutton'); ?>follow]"<?php checked(false, $options['nofollow']); ?>/> <?php _e('No', 'onebutton'); ?></label>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php _e("Add <code>target=_blank</code> to the links", "onebutton"); ?></th>
                    <td>
                        <label><input value="1" type="radio" name="onebutton[newwindow]"<?php checked(true, $options['newwindow']); ?>/> <?php _e('Yes', 'onebutton'); ?></label>
                        <label><input value="0" type="radio" name="onebutton[newwindow]"<?php checked(false, $options['newwindow']); ?>/> <?php _e('No', 'onebutton'); ?></label>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php _e("Show OneButton only for full posts and pages", "onebutton"); ?></th>
                    <td>
                        <label><input value="1" type="radio" name="onebutton[only_single]"<?php checked(true, $options['only_single']); ?>/> <?php _e('Yes', 'onebutton'); ?></label>
                        <label><input value="0" type="radio" name="onebutton[only_single]"<?php checked(false, $options['only_single']); ?>/> <?php _e('No', 'onebutton'); ?></label>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php _e("Show bookmark services' icons", "onebutton"); ?></th>
                    <td>
                        <label><input value="1" type="radio" name="onebutton[show_icons]"<?php checked(true, $options['show_icons']); ?>/> <?php _e('Yes', 'onebutton'); ?></label>
                        <label><input value="0" type="radio" name="onebutton[show_icons]"<?php checked(false, $options['show_icons']); ?>/> <?php _e('No', 'onebutton'); ?></label>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php _e("Use JavaScript to create OneButton", "onebutton"); ?></th>
                    <td>
                        <label><input value="1" type="radio" name="onebutton[use_js]"<?php checked(true, $options['use_js']); ?>/> <?php _e('Yes', 'onebutton'); ?></label>
                        <label><input value="0" type="radio" name="onebutton[use_js]"<?php checked(false, $options['use_js']); ?>/> <?php _e('No', 'onebutton'); ?></label>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php _e("OneButton activation method", "onebutton"); ?></th>
                    <td>
                        <label><input value="1" type="radio" name="onebutton[activation]"<?php checked(1, $options['activation']); ?>/> <?php _e('Hover', 'onebutton'); ?></label>
                        <label><input value="0" type="radio" name="onebutton[activation]"<?php checked(0, $options['activation']); ?>/> <?php _e('Click', 'onebutton'); ?></label>
                    </td>
                </tr>
            </tbody>
        </table>

        <p class="submit">
            <input type="submit" name="update_options" value="<?php _e('Update Options', "onebutton"); ?>" class="button button-primary"/>
        </p>
    </form>
</div>
