<?php
    $message = false;
    if (false == empty($_POST['services']) && true == is_array($_POST['services'])) {
        if (true == isset($_POST['reset_options'])) {
            $one_button->revertServices();
            $message = 2;
        }
        else {
            $services = array_values(stripslashes_deep($_POST['services']));
            $one_button->saveServices($services);
            $message = 1;
        }
    }

    $services = $one_button->getServices();
?>

<div class="wrap">
    <h2><?php _e("Bookmark Services", "onebutton"); ?></h2>

<?php if (true == isset($_SESSION['onebutton'])) : ?>
    <div class="updated fade">
        <p>
        <?php if (1 === $message) : ?>
            <?php _e("The settings have been successfully updated", 'onebutton'); ?>
        <?php elseif (2 === $message) : ?>
            <?php _e("Default service settings have been restored", 'onebutton'); ?>
        <?php endif; ?>
        </p>
    </div>
<?php endif; ?>

    <form method="post" action="<?php echo wp_specialchars(stripslashes($_SERVER['REQUEST_URI'])); ?>">
        <table class="widefat">
            <thead>
                <tr>
                    <th scope="col"><?php _e('Service', 'onebutton'); ?></th>
                    <th scope="col"><?php _e('CSS ID', 'onebutton'); ?></th>
                    <th scope="col"><?php _e('Enabled', 'onebutton'); ?></th>
                    <th scope="col"><?php _e('Sort Order', 'onebutton'); ?></th>
                    <th scope="col" width="100%"><?php _e('URL', 'onebutton'); ?></th>
                </tr>
            </thead>
            <tbody>
<?php foreach ($services as $x) : ?>
                <tr>
                    <td><input type="text" name="services[<?php echo $x[0]; ?>][1]" value="<?php echo attribute_escape($x[1]); ?>"/></td>
                    <td><input type="text" value="<?php echo wp_specialchars($x[0]); ?>" name="services[<?php echo $x[0]; ?>][0]"/></td>
                    <td>
                        <label><input type="radio" value="1" name="services[<?php echo $x[0]; ?>][3]"<?php checked(true, $x[3]); ?>/> <?php _e('Yes', 'onebutton'); ?></label>
                        <label><input type="radio" value="0" name="services[<?php echo $x[0]; ?>][3]"<?php checked(false, $x[3]); ?>/> <?php _e('No', 'onebutton'); ?></label>
                    </td>
                    <td><input type="text" value="<?php echo intval($x[2]); ?>" name="services[<?php echo $x[0]; ?>][2]"/></td>
                    <td><input type="text" value="<?php echo attribute_escape($x[4]); ?>" name="services[<?php echo $x[0]; ?>][4]" style="width: 100%"/></td>
                </tr>
<?php endforeach; ?>
            </tbody>
        </table>
        <p class="submit">
            <input type="submit" name="update_options" value="<?php _e('Update Options', "onebutton"); ?>" class="button button-primary"/>
            <input type="submit" name="reset_options" value="<?php _e('Reset to Defaults', "onebutton"); ?>" class="button" onclick="return confirm('<?php _e('Are you sure?', "onebutton"); ?>')"/>
        </p>
    </form>
</div>
