/**
 * Class Quick Nick and Quote
 * @author mad@Max
 */
function QNNQ(){
    this.text = null;
    this.nickname = null;
    this.post_id = null;
    this.usergroup_id = null;
    this.user_id = null;    
    this.vbe = vB_Editor[QR_EditorID]
    this.wwm = this.vbe.wysiwyg_mode;
}

QNNQ.prototype.Quote = function(nickname, post_id){
    this.nickname = nickname;
    this.post_id = post_id;
    this.sel = this.catchSel();
    if (this.sel != "") {
        if (this.wwm) {
            //text = text.replace(/\r?\n/g, '\r\n');
            var regex = new RegExp('([\r\n]|^[\r\n]*)([/\r?\n/g])', 'gi');
            text = PHP.trim(this.sel).replace(regex, '$1<br />');
        }
        else {
            // do nothing
        }
        this.text = '[QUOTE=' + nickname + ';' + post_id + ']' + this.sel + '[/QUOTE]';
        this.Insert();
    }
}

QNNQ.prototype.Nick = function(nickname, post_id, usergroup_id, user_id){
    this.nickname = nickname;
    this.post_id = post_id;
    this.gid = usergroup_id;
    this.uid = user_id;
    var i, bbl, bbr, linkedl = linkedr = '';
    if (this.uid != null) {
        linkedl = this.wwm ? '<a href="member.php?u=' + this.uid + '">' : '[url="' + qnnqurl + '/member.php?u=' + this.uid + '"]';
        linkedr = this.wwm ? '</a>, ' : '[/url], ';
    }
    if (nickname != selfname) {
        if (PHP.in_array(this.gid, qng.split(',')) != -1) {
            var grp = clrgrp[this.gid];
            bbl = this.wwm ? grp[0] : grp[2];
            bbr = this.wwm ? grp[1] : grp[3];
            this.text = linkedl + bbl + this.nickname + bbr + linkedr;
        }
        else {
            this.text = linkedl + (this.wwm ? '<b>' : '[b]') + this.nickname + (this.wwm ? '</b>' : '[/b]') + linkedr;
        }
        this.Insert();
    }
}

QNNQ.prototype.NotEmpty = function(text){
    var arrayCheck = ['', '<br />', '<br>', '<P>&nbsp;</P>', '&nbsp;', '<b></b>', '<b></b><br>', '<P></P>'];
    if (PHP.in_array(text, arrayCheck) == -1) {
        return true;
    }
    else {
        return false;
    }
}

QNNQ.prototype.Insert = function(){
    var quick_reply = fetch_object('qr_quickreply');
    if (quick_reply.disabled) {
        qr_activate(this.post_id);
    }
    var exist = this.vbe.get_editor_contents();
    var delimiter = '';
    var delimiter_length = 0;
    if (this.NotEmpty(exist)) {
        delimiter = this.wwm ? '<br />' : '\n';
        delimiter_length = this.wwm ? 4 : 2;
    }
    else {
        exist = '';
    }
    this.wwm ? this.vbe.check_focus() : document.vbform.message.focus();
    if (exist == '') {
        this.vbe.write_editor_contents('', false);
    }
    this.wwm ? this.vbe.write_editor_contents(exist + delimiter + this.text, delimiter_length + this.text.length, false) : this.vbe.insert_text(delimiter + this.text, delimiter_length + this.text.length, 0);
}

QNNQ.prototype.catchSel = function(){
    var selection = '';
    //var qpost = fetch_object('post_message_' + pid);
    if (window.getSelection && !window.opera) {
        selection = window.getSelection().toString();
    }
    else 
        if (document.getSelection) {
            selection = document.getSelection();
        }
        else 
            if (document.selection && document.selection.createRange) {
                selection = document.selection.createRange().text;
            }
    return selection;
}
var QNNQ = new QNNQ();
