<?php
function showForumOptions($forumchoice=array())
{
	require_once(DIR . '/includes/functions_search.php');
	global $vbulletin, $vbphrase, $show;
	
	//this will fill out $searchforumids as well as set the depth param in $vbulletin->forumcache
	global $searchforumids;
	fetch_search_forumids_array();
	
	$options = array();
	$non_searchable_forums = array();
	foreach ($searchforumids AS $forumid)
	{
		$forum = & $vbulletin->forumcache["$forumid"];
		if (trim($forum['link']))
		{
			continue;
		}
	
		//note that this code relies on the fact that searchforumids is ordered so that
		//parents appear before their childern (actually the what the display works depends
		//heavily on that fact so its not much of an assumption here).
	
		//if the forum isn't searchable, then don't show it.
		if(!($forum['options'] & $vbulletin->bf_misc_forumoptions['indexposts']))
		{
			$non_searchable_forums[$forumid] = $forumid;
		}
	
		//unless it has children that are searchable.
		else
		{
			unset($non_searchable_forums[$forum['parentid']]);
		}
	
		$optionvalue = $forumid;
		$optiontitle = "$forum[depthmark] $forum[title_clean]";
	
		if ( 
			!($vbulletin->userinfo['forumpermissions'][$forumid] & $vbulletin->bf_ugp_forumpermissions['canviewthreads'])
		)
		{
			$optiontitle .= '*';
			$show['cantsearchposts'] = true;
		}
	
		$optionselected = '';
	
		if ($forumchoice AND in_array($forumid, $forumchoice))
		{
			$optionselected = 'selected="selected"';
			$haveforum = true;
		}
	
		$options[$forumid] = render_option_template($optiontitle, $forumid, $optionselected,
			'd' . min(4, $forum['depth']));
	}
	
	foreach ($non_searchable_forums AS $forumid)
	{
		unset($options[$forumid]);
	}
	
	$options = implode("", $options);
	$options = render_option_template($vbphrase['lsa_search_all'], 'allforum', 'selected="selected"') . $options;
	return $options;
}

function check_ps($list)
{
	global $vbulletin;
	$chararr =array(
		# RU -> EN
		'' => 'f',
		'' => ',',
		'' => 'd',
		'' => 'u',
		'' => 'l',
		'' => 't',
		'' => '`',
		'' => ';',
		'' => 'p',
		'' => 'b',
		'' => 'q',
		'' => 'r',
		'' => 'k',
		'' => 'v',
		'' => 'y',
		'' => 'j',
		'' => 'g',
		'' => 'h',
		'' => 'c',
		'' => 'n',
		'' => 'e',
		'' => 'a',
		'' => '[',
		'' => 'w',
		'' => 'x',
		'' => 'i',
		'' => 'o',
		'' => ']',
		'' => 's',
		'' => 'm',
		'' => "'",
		'' => '.',
		'' => 'z',
		# EN -> RU
		'f' => '',
		',' => '',
		'd' => '',
		'u' => '',
		'l' => '',
		't' => '',
		'`' => '',
		';' => '',
		'p' => '',
		'b' => '',
		'q' => '',
		'r' => '',
		'k' => '',
		'v' => '',
		'y' => '',
		'j' => '',
		'g' => '',
		'h' => '',
		'c' => '',
		'n' => '',
		'e' => '',
		'a' => '',
		'[' => '',
		'w' => '',
		'x' => '',
		'i' => '',
		'o' => '',
		']' => '',
		's' => '',
		'm' => '',
		"'" => '',
		'.' => '',
		'z' => '' 
	); 

	foreach ($list AS $psword)
	{
		$flipword = strtr($psword, $chararr);

		$qcheck = $vbulletin->db->query_read("
			SELECT title
			FROM " . TABLE_PREFIX . "thread
			WHERE " . iif($vbulletin->options['lsa_fulltext'], "MATCH(title) AGAINST ('" . $vbulletin->db->escape_string($flipword) . "' IN BOOLEAN MODE)", "title LIKE('%" . $vbulletin->db->escape_string_like($flipword) . "%')") . "
			LIMIT 1
		");

		if ($vbulletin->db->num_rows($qcheck))
		{
			$strback .= " $flipword";
		}
		else
		{
			$strback .= " $psword";
		}
	}
	if (implode(" ", $list) == trim($strback))
	{
		return false;
	}
	return trim($strback);
}
?>