/**
 * [YUI] Live Search
 * Main Script
 * Version 4.0.6
 * @author mad@Max
 */
(function(){
	var Y = YAHOO.util, D = Y.Dom, E = Y.Event, L = YAHOO.lang,
	req = null, cont = null, resobj = null, timeout = null, past = '';
	L.augmentObject(YAHOO.vBulletin.lsa, {
		init: function(){
			E.removeListener(this.textobj, "focus", this.start);
			E.on(this.textobj, "blur", this.win, this, true);
			E.on(this.textobj, "focus", this.win, this, true);
			E.on(this.textobj, "keyup", function(e){
				e = e || window.event;
				var code = e.keyCode || e.which;
				// don't send if typing left and right arrow, whitespase, home and end
				if (PHP.in_array(code, [37, 39, 32, 36, 35]) > -1) 
				{
					return;
				}
				this.get(e);
			}, this, true);
			E.on("lsarld", "click", this.get, this, true);
			E.on("lsacls", "click", this.win, this, true);
			this.win();
		},
		load: function(){
			YAHOO.util.Connect.asyncRequest("POST", this.bb + "/ajaxlivesearch.php?do=lsawin", {
				success: function(o){
					if (o.responseXML) 
					{
						cont = document.createElement("div");
						cont.id = "lsa_cont";
						cont.style.position = "absolute";
						cont.style.zIndex = 1000;
						cont.style.display = "none";
						cont.innerHTML = fetch_tags(o.responseXML, "lsagetwin")[0].firstChild.nodeValue;
						document.body.appendChild(cont);
						this.textobj.value = '';
						resobj = D.get("lsa_results");
						new Y.DD(cont.id).setHandleElId("lsadd");
						init_collapsers();
						this.init();
					}
				},
				failure: vBulletin_AJAX_Error_Handler,
				timeout: vB_Default_Timeout,
				scope: this
			}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&do=lsawin");
		},
		win: function(e){
			if (cont.style.display == "none") 
			{
				this.textobj.value = '';
				resobj.innerHTML = vbphrase['lsa_wait'];
				cont.style.display = "block";
				center_element(cont);
			}
			else 
			{
				if (E.getTarget(do_an_e(e)).id == "lsacls") 
				{
					cont.style.display = "none";
				};
				this.textobj.value = this.textobj.value || vbphrase['live_search'];
			}
		},
		get: function(e){
			// create word or couple words
			var str = PHP.trim(this.textobj.value), ww = D.get('lsawithword').value > 0,
			send = ww ? str : str.replace(new RegExp("(^|\\s)(.{1," + (this.min - 1) + "}(?=(\\s|$)))", "g"), "");
			
			if (send)
			{
				if (E.getTarget(e).id == "lsarld" || send != past)
				{
					if (timeout){timeout.cancel();}
					timeout = L.later(500, this, this.send, (past = send));
				}
			}
			else 
			{
				resobj.innerHTML = vbphrase['lsa_wait'];
			}
		},
		send: function(send){
			var pf = new vB_Hidden_Form(null), load = D.get("lsaloading");
			pf.add_variables_from_object(D.get("lsform"));
			D.removeClass(load, "hidden");
			
			if (Y.Connect.isCallInProgress(req)) 
			{
				Y.Connect.abort(req);
			}

			var xml = new vB_AJAX_Handler(true);
			xml.callback = function(o){
				D.addClass(load, "hidden");
				resobj.innerHTML = fetch_tags(o.responseXML, "ajaxlivesearch")[0].firstChild.nodeValue;
			};
			xml.send(this.bb + "/ajaxlivesearch.php?do=search", "&do=search&" + pf.build_query_string().replace(/&lsazone=(\w+)/g, ",$1").replace(/,/, "&lsazone=") + "&keyword=" + PHP.urlencode(send));
			req = xml.conn;
		}
	});
}());