<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board v3.1.4
 * Session API
 * Created by Matt Mecham
 * Last Updated: $Date: 2010-10-05 02:50:24 +0100 (Tue, 05 Oct 2010) $
 * </pre>
 *
 * @author 		Matt Meckum
 * @copyright	(c) 2001 - 2010 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		IP.Board
 * @link		http://www.invisionpower.com
 * @version		$Rev: 6942 $
 *
 */

class session_api
{
	/**#@+
	* Registry Object Shortcuts
	*
	* @access	protected
	* @var		object
	*/
	protected $DB;
	protected $settings;
	protected $lang;
	protected $member;
	protected $memberData;
	protected $cache;
	protected $caches;
	/**#@-*/
	
	/**
	 * Construct.
	 * @param	object		Registry object
	 * @access	public
	 * @return	void
	 */
	public function __construct( ipsRegistry $registry )
	{
		/* Make object */
		$this->registry   =  $registry;
		$this->DB         =  $this->registry->DB();
		$this->settings   =& $this->registry->fetchSettings();
		$this->request    =& $this->registry->fetchRequest();
		$this->lang       =  $this->registry->getClass('class_localization');
		$this->member     =  $this->registry->member();
		$this->memberData =& $this->registry->member()->fetchMemberData();
		$this->cache      =  $this->registry->cache();
		$this->caches     =& $this->registry->cache()->fetchCaches();
	}
	
	/**
	 * Returns a list (with buildProfilePhoto set) of users in an application
	 * @param string $app
	 * @param array  'fetch' (all, members, guests)
	 * @return array ('stats' => array( 'members', 'guests', 'anon' ), 'rows' => array( ... ) )
	 */
	public function getUsersIn( $app, $options=array() )
	{
		$return  = array( 'stats' => array( 'total'   => 0,
											'members' => 0,
										    'guests'  => 0,
											'bots'	  => 0,
											'anon'	  => 0 ),
						  'rows'  => array( 'members' => array(),
											'bots'    => array(),
											'guests'  => array(),
											'anon' 	  => array() ) );
		
		$limit	 = time() - ( $this->settings['au_cutoff'] * 60 );
		$rows	 = array();
		$NOWJIM  = time();
		$cached  = array();
		$where   = array( "s.current_appcomponent='" . $app . "'", "s.running_time > " . $limit );
		
		if ( $this->memberData['member_id'] )
		{
			$rows[ $NOWJIM . '.' . $this->memberData['member_id'] ] = array_merge( array( 'id'			 => $this->member->session_id,
																						  'login_type'	 => substr($this->memberData['login_anonymous'],0, 1),
																						  'running_time' => $NOWJIM,
																						  'member_id'	 => $this->memberData['member_id'],
																						  'member_name'	 => $this->memberData['members_display_name'],
																						  'member_group' => $this->memberData['member_group_id'],
																						  'seo_name'	 => $this->memberData['members_seo_name'] ), $this->memberData );
		}
		
		/* Dee bee */
		$this->DB->build( array( 'select'    => 's.*',
								 'from'	     => array( 'sessions' => 's' ),
								 'where'     => implode( ' AND ', $where ),
								 'add_join'  =>  array( array( 'select' => 'm.*',
															   'from'   => array( 'members' => 'm' ),
															   'where'  => 'm.member_id=s.member_id',
															   'type'   => 'left' ) ) ) );

		$this->DB->execute();

		while( $session = $this->DB->fetch() )
		{
			if ( ! empty( $session['member_id'] ) AND $session['member_id'] == $this->memberData['member_id'] ) 
			{
				continue;
			}

			$rows[ $session['running_time'] . '.' . $session['id'] ] = $session;
		}

		krsort( $rows );
		
		/* Process them */
		$filename = IPSLib::getAppDir( $app ) . '/extensions/coreExtensions.php';
					
		if ( file_exists( $filename ) )
		{
			$classToLoad = IPSLib::loadLibrary( $filename, 'publicSessions__' . $app, $app );
			$loader      = new $classToLoad();

			if ( method_exists( $loader, 'parseOnlineEntries' ) )
			{
				$rows = $loader->parseOnlineEntries( $rows );
			}
		}
		
		if ( ! count( $rows ) )
		{
			return $return;
		}
		
		/* Sort through */
		foreach( $rows as $id => $result )
		{
			$last_date = $this->registry->getClass('class_localization')->getTime( $result['running_time'] );

			/* ROBOT - or DODOT! */
			if ( strstr( $result['id'], '_session' ) )
			{
				$botname = preg_replace( '/^(.+?)=/', "\\1", $result['id'] );

				if ( ! $cached[ $result['member_name'] ] )
				{
					$result 					= IPSMember::buildProfilePhoto( 0 );
					$result['parsedMemberName'] = $result['member_name'];
					$return['rows']['bots'][]   = $result;

					$cached[ $result['member_name'] ] = 1;
				}
				
				$return['stats']['bots']++;
			}
			/* Guest */
			else if ( ! $result['member_id'] )
			{
				$result						= IPSMember::buildProfilePhoto( 0 );
				$result['parsedMemberName'] = $this->lang->words['global_guestname'];
				$return['rows']['guests'][] = $result;
				$return['stats']['guests']++;
			}
			/* Member */
			else
			{
				if ( empty( $cached[ $result['member_id'] ] ) )
				{
					$cached[ $result['member_id'] ] = 1;
					
					$result						= IPSMember::buildProfilePhoto( $result );
					$result['parsedMemberName'] = IPSLib::makeNameFormatted( $result['member_name'], $result['member_group'] );

					if ( $result['login_type'] )
					{
						if ( $this->memberData['g_access_cp'] and ( $this->settings['disable_admin_anon'] != 1 ) )
						{
							$result['parsedMemberName'] = IPSLib::makeProfileLink( $result['parsedMemberName'], $result['member_id'], $result['seo_name'] );
							$return['rows']['anon'][]   = $result;
						}
						
						$return['stats']['anon']++;
					}
					else
					{
						$result['parsedMemberName']  = IPSLib::makeProfileLink( $result['parsedMemberName'], $result['member_id'], $result['seo_name'] );
						$return['rows']['members'][] = $result;
						$return['stats']['members']++;
					}
				}
			}
		}

		$return['stats']['total'] = intval( $return['stats']['bots'] ) + intval( $return['stats']['guests'] ) + intval( $return['stats']['anon'] ) + intval( $return['stats']['members'] );
	
		return $return;
	}
	
	
}