<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board v3.1.4
 * Like Ajax
 * Last Updated: $LastChangedDate: 2010-08-18 16:55:30 +0100 (Wed, 18 Aug 2010) $
 * </pre>
 *
 * @author 		$Author: matt $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		IP.Gallery
 * @link		http://www.invisionpower.com
 * @version		$Rev: 6767 $
 *
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class public_core_ajax_like extends ipsAjaxCommand
{
	/**
	 * Main class entry point
	 *
	 * @param	object		ipsRegistry reference
	 * @return	void		[Outputs to screen]
	 */	
	public function doExecute( ipsRegistry $registry )
	{
		/* From App */
		$app   = trim( $this->request['f_app'] );
		$area  = trim( $this->request['f_area'] );
		$relid = intval( $this->request['f_relid'] );
		
		if ( ! $app OR ! $area OR empty( $relid ) )
		{
			trigger_error( "Missing data in " . __FILE__ . ' ' . __LINE__ );
		}
		
		/* Init some data */
		require_once( IPS_ROOT_PATH . 'sources/classes/like/composite.php' );
		$this->_like = classes_like::bootstrap( $app, $area );
		
		$this->registry->getClass('class_localization')->loadLanguageFile( array( 'public_like' ), 'core' );
		
		/* What to do? */
		switch( $this->request['do'] )
		{
			case 'setDialogue':
				$this->_setDialogue( $app, $area, $relid );
			break;
			case 'save':
				$this->_save( $app, $area, $relid );
			break;
			case 'unset':
				$this->_unset( $app, $area, $relid );
			break;
			case 'more':
				$this->_more( $app, $area, $relid );
			break;	
        }
    }
    
	/**
     * Show more dialogue
     *
     * @param	string		App
     * @param 	string		Area
     * @param	int			Relationship ID
     * @return	void
     */
    protected function _more( $app, $area, $relid )
    {   			
 		/* Fetch data */
 		return $this->returnHtml( $this->_like->render( 'more', $relid ) );
    }
    
	/**
     * Do unset
     *
     * @param	string		App
     * @param 	string		Area
     * @param	int			Relationship ID
     * @return	void
     */
    protected function _unset( $app, $area, $relid )
    {
		if( !$this->memberData['member_id'] )
		{
			return $this->returnNull();
		}

    	/* Set data */
 		$this->_like->remove( $relid, $this->memberData['member_id'] );
 		
 		/* Fetch data */
 		return $this->returnHtml( $this->_like->render( 'summary', $relid ) );
    }
    
	/**
     * Save form
     *
     * @param	string		App
     * @param 	string		Area
     * @param	int			Relationship ID
     * @return	void
     */
    protected function _save( $app, $area, $relid )
    {
		if( !$this->memberData['member_id'] )
		{
			return $this->returnNull();
		}

    	$like_notify	= intval( $this->request['like_notify'] );
    	$like_freq		= trim( $this->request['like_freq'] );
    	$like_anon		= intval( $this->request['like_anon'] );

    	/* Set data */
 		$this->_like->add( $relid, $this->memberData['member_id'], array( 'like_notify_do' => $like_notify, 'like_notify_freq' => $like_freq ), $like_anon );
 		
 		/* Fetch data */
 		return $this->returnHtml( $this->_like->render( 'summary', $relid ) );
    }
    
    /**
     * Show set form
     *
     * @param	string		App
     * @param 	string		Area
     * @param	int			Relationship ID
     * @return	void
     */
    protected function _setDialogue( $app, $area, $relid )
    {
		if( !$this->memberData['member_id'] )
		{
			return $this->returnNull();
		}

 		$data = $this->_like->getDataForSetDialogue( $relid );
 		
 		return $this->returnHtml( $this->registry->getClass('output')->getTemplate('global_other')->likeSetDialogue( $app, $area, $relid, $data ) );
    }
    
}
