/************************************************/
/* IPB3 Javascript								*/
/* -------------------------------------------- */
/* ips.facebook.js - Facebook Connect code		*/
/* (c) IPS, Inc 2008							*/
/* -------------------------------------------- */
/* Author: Matt Mecham, Rikki Tissier			*/
/************************************************/

var _vk = window.IPBoard;

_vk.prototype.vkontakte = {

	linkedMember: {},
    vkMemberInfo: {},
	
	/*------------------------------*/
	/* Constructor 					*/
	init: function()
	{
		Debug.write("Initializing ips.vkontakte.js");
    
	},
	
    show_loginButton: function()
    {
        var content = $('vk-template-button').innerHTML;
        $('vkUserBox').update( content );
        
        $('vk_login').observe( 'click', function() {
            $('vk_frame').contentWindow.doLogin();
        });
        
    },

	
	/**
	* Updates the log in box
	*
	*/
	login_updateBox: function()
	{
        
		/* INIT */
		var content       = $('vk-template-main').innerHTML;
        
        content = content + $('vk-template-linked').innerHTML;        
        $('vkUserBox').update( content );

        $('openapi_user').innerHTML = ipb.vkontakte.vkMemberInfo.name;
        $('vk_linkForm').action = $('vk_linkForm').action + '?key=' + ipb.vkontakte.linkedMember['key'];
        $('openapi_userlink').href = 'http://vkontakte.ru/id' + ipb.vkontakte.vkMemberInfo.id;
        $('openapi_userphoto').src = ipb.vkontakte.vkMemberInfo.photo;

		/* Set up handlers */
        if ( $('vk_link') ) 
        {  
           $('vk_link').observe('click', ipb.vkontakte.login_linkAcc );
        }
        
        if ( $('vk_complete') )
        {
            $('vk_complete').observe('click', ipb.vkontakte.login_complete );
        }
        
        if ( $('vk_logout') )
        {
            $('vk_logout').observe( 'click', function() {
                $('vk_frame').contentWindow.doLogout();
            });
        }
	},
	
	initUserCP: function()
	{
		$('tc_remove').observe( 'click', ipb.vkontakte.usercp_remove );
	},    
    
	/**
	* Loads the URL to remove the app
	*
	*/
	usercp_remove: function()
	{
		window.location = ipb.vars['base_url'] + 'app=core&module=usercp&tab=members&area=vkRemove&do=custom&secure_key=' + ipb.vars['secure_hash'];
	},
		
	/**
	* Simply submits our form so PHP can do the final checks
	*
	*/
	login_complete: function()
	{
		$('vk_linkForm').submit();
	},
	
	/**
	* Check, via AJAX for an existing account
	*
	*/
	login_linkAcc: function()
	{
        window.location = ipb.vars['base_url'] + 'app=core&module=usercp&tab=members&area=vkLink&do=custom&secure_key=' + ipb.vars['secure_hash'];
	},
    
	/**
	 * Check to see if the facebook user is linked to an IPB account
	 */
	loadUser: function(data)
	{
		/* Already been here? */
		if ( typeof( ipb.vkontakte.linkedMember['member_id'] ) != 'undefined' )
		{
			return;
		}
		
		/* Fetch FB ID */
		vkUserId = data.id;
        ipb.vkontakte.vkMemberInfo = data;
		
		/* Got a linked member? */
		new Ajax.Request( 	ipb.vars['base_url'] + '&app=core&module=ajax&secure_key=' + ipb.vars['secure_hash'] + '&section=vkontakte&do=getUserByVkId',
							{
								method: 'post',
                                parameters: data,
								evalJSON: 'force',
								onSuccess: function(t)
								{
                                    ipb.vkontakte.linkedMember = t.responseJSON;
									ipb.vkontakte.login_updateBox();
								}
							}
						);
	}
}

ipb.vkontakte.init();