<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board v3.1.0 Beta 2
 * Main public executable wrapper.
 * Set-up and load module to run
 * Last Updated: $Date: 2010-01-22 03:41:36 -0500 (Fri, 22 Jan 2010) $
 * </pre>
 *
 * @author 		$Author: matt $
 * @copyright	(c) 2001 - 2008 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		IP.Board
 * @link		http://www.invisionpower.com
 * @version		$Rev: 5738 $
 *
 */

define( 'IPS_ENFORCE_ACCESS', TRUE );
define( 'IPB_THIS_SCRIPT', 'public' );
require_once( '../../initdata.php' );

require_once( IPS_ROOT_PATH . 'sources/base/ipsRegistry.php' );
require_once( IPS_ROOT_PATH . 'sources/base/ipsController.php' );

$registry = ipsRegistry::instance();
$registry->init();

require_once( IPS_ROOT_PATH . 'sources/classes/vkontakte/connect.php' );
$vk = new vkontakte_connect( $registry );

if ( $_REQUEST['key'] )
{
	try
	{
		$vk->finishLogin();
	}
	catch( Exception $error )
	{
		$msg = $error->getMessage();
	
		switch( $msg )
		{
			default:
				$registry->getClass('output')->showError( 'twit_ohnoes', 99999, null, null, 403 );
			break;
			case 'TWITTER_NOT_SET_UP':
				$registry->getClass('output')->showError( 'twit_not_on', 99999, null, null, 403 );
			case 'NOT_REMOTE_MEMBER':
				$registry->getClass('output')->showError( 'twit_not_remote', 99999, null, null, 403 );
			break;
		}
	}
}
else
{
	$vk->redirectToConnectPage();
}

exit();