<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v3.1.4
 * Task: Update the profile views counter
 * Last Updated: $LastChangedDate: 2010-11-17 08:50:12 -0500 (Wed, 17 Nov 2010) $
 * </pre>
 *
 * @author 		$Author: ips_terabyte $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		IP.Board
 * @subpackage	Members
 * @link		http://www.invisionpower.com
 * @since		27th January 2004
 * @version		$Rev: 7206 $
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class task_item
{
	/**
	 * Parent task manager class
	 *
	 * @access	protected
	 * @var		object
	 */
	protected $class;

	/**
	 * This task data
	 *
	 * @access	protected
	 * @var		array
	 */
	protected $task			= array();

	/**
	 * Prevent logging
	 *
	 * @access	protected
	 * @var		boolean
	 */
	protected $restrict_log	= false;
	
	/**#@+
	 * Registry Object Shortcuts
	 *
	 * @access	protected
	 * @var		object
	 */
	protected $registry;
	protected $DB;
	protected $settings;
	protected $request;
	protected $lang;
	protected $member;
	protected $cache;
	/**#@-*/
	
	/**
	 * Constructor
	 *
	 * @access	public
	 * @param 	object		ipsRegistry reference
	 * @param 	object		Parent task class
	 * @param	array 		This task data
	 * @return	void
	 */
	public function __construct( ipsRegistry $registry, $class, $task )
	{
		/* Make registry objects */
		$this->registry	= $registry;
		$this->DB		= $this->registry->DB();
		$this->settings =& $this->registry->fetchSettings();
		$this->request  =& $this->registry->fetchRequest();
		$this->lang		= $this->registry->getClass('class_localization');
		$this->member	= $this->registry->member();
		$this->memberData =& $this->registry->member()->fetchMemberData();
		$this->cache	= $this->registry->cache();
		$this->caches   =& $this->registry->cache()->fetchCaches();

		$this->class	= $class;
		$this->task		= $task;
	}
	
	/**
	 * Run this task
	 *
	 * @access	public
	 * @return	void
	 */
	public function runTask()
	{
		$counter = 0;
		$_sync   = time() - 10800;
		$_active = time() - ( 86400 * 14 );
		$members = array();
		
		if ( IPSLib::fbc_enabled() !== TRUE && IPSLib::twitter_enabled() !== TRUE )
		{
			$this->class->appendTaskLog( $this->task, "Nothing to update" );
			$this->class->unlockTask( $this->task );
			return;
		}
		
		//-----------------------------------------
		// Fetch members
		//-----------------------------------------
		
		$this->DB->build( array( 'select' => 'member_id',
								 'from'   => 'members',
								 'where'  => '( (twitter_id != \'\' AND tc_lastsync < ' . $_sync .') OR (fb_uid > 0 AND fb_lastsync < ' . $_sync . ') ) AND last_visit > ' . $_active,
								 'order'  => 'last_visit DESC',
								 'limit'  => array( 0, 100 ) ) );
		$this->DB->execute();
		
		while( $row = $this->DB->fetch() )
		{
			$members[] = $row['member_id'];
		}
		
		$members = IPSMember::load( $members );
		
		foreach( $members as $member )
		{
			//-----------------------------------------
			// Facebook Sync
			//-----------------------------------------
		
			if ( IPSLib::fbc_enabled() === TRUE )
			{ 
				if ( ! empty( $member['fb_uid'] ) )
				{
					/* We have a linked member and options, so check if they haven't sync'd in 24 hours and have been active in the past 90 days... */
					try
					{
						require_once( IPS_ROOT_PATH . 'sources/classes/facebook/connect.php' );
						$facebook = new facebook_connect( ipsRegistry::instance(), null, null, true );
					
						$_member = $facebook->syncMember( $member, $member['fb_token'], $member['fb_uid'] );
						
						$counter++;
						
						if ( $_member AND is_array( $_member ) )
						{
							$member = $_member;
							unset( $_member );
						}
					}
					catch( Exception $error )
					{
						$msg = $error->getMessage();

						switch( $msg )
						{
							case 'NOT_LINKED':
							case 'NO_MEMBER':
							case 'FACEBOOK_NO_APP_ID':
							break;
						}
					}
				}
			}
			
			//-----------------------------------------
			// Twitter Sync
			//-----------------------------------------
		
			if ( IPSLib::twitter_enabled() === TRUE )
			{ 
				if ( ! empty( $member['twitter_id'] ) and ! empty( $member['tc_bwoptions'] ) )
				{
					/* We have a linked member and options, so check if they haven't sync'd in 3 hours and have been active in the past 90 days... */
					require_once( IPS_ROOT_PATH . 'sources/classes/twitter/connect.php' );
					$twitter = new twitter_connect( ipsRegistry::instance() );
					
					try
					{
						$_member = $twitter->syncMember( $member );
						
						$counter++;
						
						if ( $_member AND is_array( $_member ) )
						{
							$member = $_member;
							unset( $_member );
						}
					}
					catch( Exception $error )
					{
						$msg = $error->getMessage();

						switch( $msg )
						{
							case 'NOT_LINKED':
							case 'NO_MEMBER':
							break;
						}
					}
				}
			}
		}
		
		//-----------------------------------------
		// Log to log table - modify but dont delete
		//-----------------------------------------
		
		$this->class->appendTaskLog( $this->task, "Updated " . $counter );
		
		//-----------------------------------------
		// Unlock Task: DO NOT MODIFY!
		//-----------------------------------------
		
		$this->class->unlockTask( $this->task );
	}
}