<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board v3.1.4
 * Member property updater (AJAX)
 * Last Updated: $Date: 2010-10-21 07:08:38 -0400 (Thu, 21 Oct 2010) $
 * </pre>
 *
 * @author 		$Author: ips_terabyte $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		IP.Board
 * @subpackage	Members
 * @link		http://www.invisionpower.com
 * @version		$Revision: 7007 $
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class admin_members_ajax_editform extends ipsAjaxCommand 
{
	/**
	 * Main class entry point
	 *
	 * @param	object		ipsRegistry reference
	 * @return	void		[Outputs to screen]
	 */
	public function doExecute( ipsRegistry $registry )
	{
		$this->registry->class_localization->loadLanguageFile( array( 'admin_member' ), 'members' );
		
    	switch( $this->request['do'] )
    	{
			default:
			case 'show':
				$this->show();
			break;
			case 'save_display_name':
				$this->save_member_name( 'members_display_name' );
			break;
			case 'save_name':
				$this->save_member_name( 'name' );
			break;
			case 'save_password':
				$this->save_password();
			break;
			case 'save_email':
				$this->save_email();
			break;
			case 'remove_photo':
				$this->remove_photo();
			break;
    	}
	}

	/**
	 * Remove user's photo
	 *
	 * @return	void		[Outputs to screen]
	 */
	protected function remove_photo()
	{
		//-----------------------------------------
		// INIT
		//-----------------------------------------
		
		$member_id		= intval( $this->request['member_id'] );
		
		//-----------------------------------------
		// Get member
		//-----------------------------------------
		
		$member = IPSMember::load( $member_id );
																	
		if ( ! $member['member_id'] )
		{
			$this->returnJsonError( $this->lang->words['m_noid'] );
			exit();
		}
		
		//-----------------------------------------
		// Allowed to upload pics for administrators?
		//-----------------------------------------
		
		if( $member['g_access_cp'] AND !$this->registry->getClass('class_permissions')->checkPermission( 'member_photo_admin', 'members', 'members' ) )
		{
			$this->returnJsonError( $this->lang->words['m_editadmin'] );
			exit();
		}

		//-----------------------------------------
		// Sort out upload dir
		//-----------------------------------------

		/* Fix for bug 5075 */
		$this->settings[ 'upload_dir'] =  str_replace( '&#46;', '.', $this->settings['upload_dir']  );		

		$upload_path  = $this->settings['upload_dir'];

		//-----------------------------------------
		// Already a dir?
		//-----------------------------------------
		
		if ( file_exists( $upload_path . "/profile" ) )
		{
			# Set path and dir correct
			$upload_path .= "/profile";
			$upload_dir   = "profile/";
		}
		
		IPSMember::getFunction()->removeUploadedPhotos( $member_id, $upload_path );
		
		IPSMember::save( $member_id, array( 'extendedProfile' => array( 'pp_main_photo'   => '',
												  				   	 	'pp_main_width'   => 0,
																	   	'pp_main_height'  => 0,
																		'pp_thumb_photo'  => '',
																		'pp_thumb_width'  => 0,
																		'pp_thumb_height' => 0,
																	 ) ) );

		ipsRegistry::getClass('adminFunctions')->saveAdminLog( sprintf($this->lang->words['m_imgremlog'], $member_id ) );

		$member = IPSMember::load( $member_id );
		$member	= IPSMember::buildDisplayData( $member, 0 );

		//-----------------------------------------
		// Return
		//-----------------------------------------

		$this->returnJsonArray( array( 
										'success'			=> 1, 
										'pp_main_photo'		=> $member['pp_main_photo'], 
										'pp_main_width'		=> $member['pp_main_width'], 
										'pp_main_height'	=> $member['pp_main_height']
							)	);
	}
	
	/**
	 * Change a member's email address
	 *
	 * @return	void		[Outputs to screen]
	 */
	protected function save_email()
	{
		//-----------------------------------------
		// INIT
		//-----------------------------------------
		
		$member_id	= intval( $this->request['member_id'] );
		$email		= trim( $this->request['email'] );
		
		//-----------------------------------------
		// Get member
		//-----------------------------------------
		
		$member = IPSMember::load( $member_id );
																	
		if ( ! $member['member_id'] )
		{
			$this->returnJsonError( $this->lang->words['m_noid'] );
			exit();
		}
		
		//-----------------------------------------
		// Allowed to edit administrators?
		//-----------------------------------------
		
		if( $member['g_access_cp'] AND !$this->registry->getClass('class_permissions')->checkPermission( 'member_edit_admin', 'members', 'members' ) )
		{
			$this->returnJsonError( $this->lang->words['m_editadmin'] );
			exit();
		}
		
		//-----------------------------------------
		// Is this email addy taken? CONVERGE THIS??
		//-----------------------------------------
		
		$email_check = IPSMember::load( mb_strtolower($email) );
		
		if ( $email_check['member_id'] AND $email_check['member_id'] != $member_id )
		{
			$this->returnJsonError( $this->lang->words['m_emailalready'] );
			exit();
		}
		
        //-----------------------------------------
    	// Load handler...
    	//-----------------------------------------
    	
		$classToLoad = IPSLib::loadLibrary( IPS_ROOT_PATH . 'sources/handlers/han_login.php', 'han_login' );
		$han_login   = new $classToLoad( $this->registry );
    	$han_login->init();
    	$han_login->changeEmail( trim( mb_strtolower( $member['email'] ) ), trim( mb_strtolower( $email ) ), $member );
    	
    	//-----------------------------------------
    	// We don't want to die just from a Converge error
    	//-----------------------------------------
    	
    	/*if ( $han_login->return_code AND ( $han_login->return_code != 'METHOD_NOT_DEFINED' AND $han_login->return_code != 'SUCCESS' ) )
	    {
			$this->returnJsonError( $this->lang->words['m_emailalready'] );
			exit();
    	}*/
    	
		//-----------------------------------------
		// Update member
		//-----------------------------------------
		
		IPSLib::runMemberSync( 'onEmailChange', $member_id, mb_strtolower( $email ), $member['email'] );
		
		IPSMember::save( $member_id, array( 'core' => array( 'email' => mb_strtolower( $email ) ) ) );
		
		ipsRegistry::getClass('adminFunctions')->saveAdminLog( sprintf( $this->lang->words['m_emailchangelog'], $member['email'], $email, $member_id ) );
		
		$this->returnJsonArray( array( 
										'success'	=> 1, 
										'email'		=> $email
							)	);
	}
	
	/**
	 * Change a member's password
	 *
	 * @return	void		[Outputs to screen]
	 * @todo 	This method is no longer working via AJAX (on purpose).  It should be moved out of the AJAX controller as such.
	 */
	protected function save_password()
	{
		//-----------------------------------------
		// INIT
		//-----------------------------------------
		
		$member_id		= intval( $this->request['member_id'] );
		$password		= IPSText::parseCleanValue( urldecode( $_POST['password'] ) );
		$password2		= IPSText::parseCleanValue( urldecode( $_POST['password2'] ) );
		$new_key		= intval( $this->request['new_key'] );
		$new_salt		= intval( $this->request['new_salt'] );
		$salt			= str_replace( '\\', "\\\\", IPSMember::generatePasswordSalt(5) );
		$key			= IPSMember::generateAutoLoginKey();
		$md5_once		= md5( trim($password) );
		
		//-----------------------------------------
		// AJAX debug
		//-----------------------------------------
		
		IPSDebug::fireBug( 'info', array( 'Password: ' . $password ) );
		
		//-----------------------------------------
		// Check
		//-----------------------------------------

		if ( ! $password OR ! $password2 )
		{
			$this->registry->output->showError( $this->lang->words['password_nogood'] );
		}
		
		if ( $password != $password2 )
		{
			$this->registry->output->showError( $this->lang->words['m_passmatch'] );
		}

		//-----------------------------------------
		// Get member
		//-----------------------------------------
		
		$member = IPSMember::load( $member_id );
		
		//-----------------------------------------
		// Allowed to edit administrators?
		//-----------------------------------------
		
		if( $member['g_access_cp'] AND !$this->registry->getClass('class_permissions')->checkPermission( 'member_edit_admin', 'members', 'members' ) )
		{
			$this->registry->output->showError( $this->lang->words['m_editadmin'] );
		}
		
		//-----------------------------------------
		// Check Converge: Password
		//-----------------------------------------
    	
		$classToLoad = IPSLib::loadLibrary( IPS_ROOT_PATH . 'sources/handlers/han_login.php', 'han_login' );
		$han_login   = new $classToLoad( $this->registry );
    	$han_login->init();
    	$han_login->changePass( $member['email'], $md5_once, $password, $member );
    	
    	/*if ( $han_login->return_code != 'METHOD_NOT_DEFINED' AND $han_login->return_code != 'SUCCESS' )
    	{
			$this->returnJsonError( $this->lang->words['m_passchange']);
			exit();
    	}*/
		
		//-----------------------------------------
		// Local DB
		//-----------------------------------------
		
		$update = array();
		
		if( $new_salt )
		{
			$update['members_pass_salt']	= $salt;
		}
		
		if( $new_key )
		{
			$update['member_login_key']		= $key;
		}
		
		if( count($update) )
		{
			IPSMember::save( $member_id, array( 'core' => $update ) );
		}
		
		IPSMember::updatePassword( $member_id, $md5_once );
		IPSLib::runMemberSync( 'onPassChange', $member_id, $password );

		ipsRegistry::getClass('adminFunctions')->saveAdminLog( sprintf( $this->lang->words['m_passlog'], $member_id ) );
		
		//$this->returnJsonArray( array( 
		//								'success'	=> 1, 
		//								'password'	=> "*************"
		//					)	);

		$this->registry->output->global_message	= $this->lang->words['pw_updated_success'];
		$this->registry->output->silentRedirectWithMessage( $this->settings['base_url'] . 'module=members&do=viewmember&member_id=' . $member_id );
	}
	
	/**
	 * Update a user's login or display name
	 *
	 * @param	string		Field to update
	 * @return	void		[Outputs to screen]
	 */
	protected function save_member_name( $field='members_display_name' )
	{
		$member_id	= intval( $this->request['member_id'] );
		
		$member = IPSMember::load( $member_id );
		
		//-----------------------------------------
		// Allowed to edit administrators?
		//-----------------------------------------
		
		if( $member['g_access_cp'] AND !$this->registry->getClass('class_permissions')->checkPermission( 'member_edit_admin', 'members', 'members' ) )
		{
			$this->registry->output->showError( $this->lang->words['m_editadmin'] );
		}
		
		if ( $field == 'members_display_name' )
		{
			$display_name	= $this->convertAndMakeSafe( $_POST['display_name'], 1 );
    		$display_name	= str_replace("&#43;", "+", $display_name );
    	}
		else
		{
			$display_name	= $this->convertAndMakeSafe( $_POST['name'], 1 );
    		$display_name	= str_replace("&#43;", "+", $display_name );
    		
			$display_name = str_replace( '|', '&#124;' , $display_name );
			$display_name = trim( preg_replace( "/\s{2,}/", " ", $display_name ) );    		
		}
		
		if ( $this->settings['strip_space_chr'] )
    	{
    		// use hexdec to convert between '0xAD' and chr
			$display_name          = IPSText::removeControlCharacters( $display_name );
		}
		
		if ( $field == 'members_display_name' AND preg_match( "#[\[\];,\|]#", str_replace('&#39;', "'", str_replace('&amp;', '&', $display_name) ) ) )
		{
			$this->registry->output->showError( $this->lang->words['m_displaynames'] );
		}
		
		try
		{
			if ( IPSMember::getFunction()->updateName( $member_id, $display_name, $field ) === TRUE )
			{
				if ( $field == 'members_display_name' )
				{
					ipsRegistry::getClass('adminFunctions')->saveAdminLog(sprintf( $this->lang->words['m_dnamelog'], $member['members_display_name'], $display_name ));
				}
				else
				{
					ipsRegistry::getClass('adminFunctions')->saveAdminLog(sprintf( $this->lang->words['m_namelog'], $member['name'], $display_name ) );
					
					//-----------------------------------------
					// If updating a name, and display names 
					//	disabled, update display name too
					//-----------------------------------------
					
					if( !ipsRegistry::$settings['auth_allow_dnames'] )
					{
						IPSMember::getFunction()->updateName( $member_id, $display_name, 'members_display_name' );
					}

					//-----------------------------------------
					// I say, did we choose to email 'dis member?
					//-----------------------------------------

					if ( $this->request['send_email'] == 1 )
					{
						//-----------------------------------------
						// By golly, we did!
						//-----------------------------------------

						$msg = trim( IPSText::stripslashes( nl2br( $_POST['email_contents'] ) ) );

						$msg = str_replace( "{old_name}", $member['name'], $msg );
						$msg = str_replace( "{new_name}", $display_name  , $msg );
						$msg = str_replace( "<#BOARD_NAME#>", $this->settings['board_name'], $msg );
						$msg = str_replace( "<#BOARD_ADDRESS#>", $this->settings['board_url'] . '/index.' . $this->settings['php_ext'], $msg );

						IPSText::getTextClass('email')->message	= stripslashes( IPSText::getTextClass('email')->cleanMessage($msg) );
						IPSText::getTextClass('email')->subject	= $this->lang->words['m_changesubj'];
						IPSText::getTextClass('email')->to		= $member['email'];
						IPSText::getTextClass('email')->sendMail();
					}
				}
				
				$this->cache->rebuildCache( 'stats', 'global' );
			}
			else
			{
				# We should absolutely never get here. So this is a fail-safe, really to
				# prevent a "false" positive outcome for the end-user
				$this->registry->output->showError( $this->lang->words['m_namealready'] );
			}
		}
		catch( Exception $error )
		{
		//	$this->returnJsonError( $error->getMessage() );
			
			switch( $error->getMessage() )
			{
				case 'NO_USER':
					$this->registry->output->showError( $this->lang->words['m_noid'] );
				break;
				case 'NO_PERMISSION':
				case 'NO_NAME':
					$this->registry->output->showError( sprintf($this->lang->words['m_morethan3'], $this->settings['max_user_name_length'] ) );
				break;
				case 'ILLEGAL_CHARS':
					$this->registry->output->showError( $this->lang->words['m_illegal'] );
				break;
				case 'USER_NAME_EXISTS':
					$this->registry->output->showError( $this->lang->words['m_namealready'] );
				break;
				default:
					$this->registry->output->showError( $error->getMessage() );
				break;
			}
		}
		
        //-----------------------------------------
    	// Load handler...
    	//-----------------------------------------
    	
    	if( $field == 'name' )
    	{
			$classToLoad = IPSLib::loadLibrary( IPS_ROOT_PATH . 'sources/handlers/han_login.php', 'han_login' );
			$han_login   = new $classToLoad( $this->registry );
	    	$han_login->init();
	    	$han_login->changeName( $member['name'], $display_name, $member['email'], $member );
    	}
    	else
    	{
    		IPSLib::runMemberSync( 'onNameChange', $member_id, $display_name );
    	}
		
		$__display_name = addslashes( $display_name );
		
		//$this->returnJsonArray( array( 
		//								'success'		=> 1, 
		//								'display_name'	=> "$__display_name"
		//					)	);

		$this->registry->output->global_message	= $this->lang->words[ $field . '_updated_success'];
		$this->registry->output->silentRedirectWithMessage( $this->settings['base_url'] . 'module=members&do=viewmember&member_id=' . $member_id );
	}
	
	/**
	 * Show the form
	 *
	 * @return	void		[Outputs to screen]
	 */
	protected function show()
	{
		//-----------------------------------------
		// INIT
		//-----------------------------------------
		
		$name		= trim( IPSText::alphanumericalClean( $this->request['name'] ) );
		$member_id	= intval( $this->request['member_id'] );
		$output		= '';
		
		//-----------------------------------------
		// Load language and skin
		//-----------------------------------------
		
		$html = $this->registry->output->loadTemplate('cp_skin_member_form');
		
		$this->lang->loadLanguageFile( array( 'admin_member' ) );
		
		//-----------------------------------------
		// Get member data
		//-----------------------------------------
		
		$member = IPSMember::load( $member_id, 'extendedProfile,customFields' );
		
		//-----------------------------------------
		// Got a member?
		//-----------------------------------------
		
		if ( ! $member['member_id'] )
		{
			$this->returnJsonError( $this->lang->words['m_noid'] );
		}
		
		//-----------------------------------------
		// Return the form
		//-----------------------------------------
		
		if ( method_exists( $html, $name ) )
		{
			$output = $html->$name( $member );
		}
		else
		{
			$save_to		= '';
			$div_id			= '';
			$form_field		= '';
			$text			= '';
			$description	= '';
			$method			= '';

			switch( $name )
			{
				case 'inline_ban_member':

					if( !$this->registry->getClass('class_permissions')->checkPermission( 'member_ban', 'members', 'members' ) )
					{
						$this->returnJsonError($this->lang->words['m_noban']);
					}
					
					if( $member['g_access_cp'] AND !$this->registry->getClass('class_permissions')->checkPermission( 'member_ban_admin', 'members', 'members' ) )
					{
						$this->returnJsonError($this->lang->words['m_noban']);
					}

					//-----------------------------------------
					// INIT
					//-----------------------------------------
					
					$ban_filters 	= array( 'email' => array(), 'name' => array(), 'ip' => array() );
					$email_banned	= false;
					$ip_banned		= array();
					$name_banned	= false;
					
					//-----------------------------------------
					// Grab existing ban filters
					//-----------------------------------------
					
					$this->DB->build( array( 'select' => '*', 'from' => 'banfilters' ) );
					$this->DB->execute();
					
					while( $r = $this->DB->fetch() )
					{
						$ban_filters[ $r['ban_type'] ][] = $r['ban_content'];
					}
					
					//-----------------------------------------
					// Check name and email address
					//-----------------------------------------
					
					if( in_array( $member['email'], $ban_filters['email'] ) )
					{
						$email_banned	= true;
					}
					
					if( in_array( $member['name'], $ban_filters['name'] ) )
					{
						$name_banned	= true;
					}

					//-----------------------------------------
					// Retrieve IP addresses
					//-----------------------------------------
					
					$ip_addresses	= IPSMember::findIPAddresses( $member['member_id'] );
					
					//-----------------------------------------
					// Start form fields
					//-----------------------------------------
					
					$form['member']			= ipsRegistry::getClass('output')->formCheckbox( "ban__member", $member['member_banned'] );
					$form['email']			= ipsRegistry::getClass('output')->formCheckbox( "ban__email", $email_banned );
					$form['name']			= ipsRegistry::getClass('output')->formCheckbox( "ban__name", $name_banned );
					
					$form['note']			= ipsRegistry::getClass('output')->formCheckbox( "ban__note", 0 );
					$form['note_field']		= ipsRegistry::getClass('output')->formTextarea( "ban__note_field" );
					$form['ips']			= array();
					
					//-----------------------------------------
					// What about IPs?
					//-----------------------------------------
					
					if( is_array($ip_addresses) AND count($ip_addresses) )
					{
						foreach( $ip_addresses as $ip_address => $count )
						{
							if( in_array( $ip_address, $ban_filters['ip'] ) )
							{
								$form['ips'][ $ip_address ] = ipsRegistry::getClass('output')->formCheckbox( "ban__ip_" . str_replace( '.', '_', $ip_address ), true );
							}
							else
							{
								$form['ips'][ $ip_address ] = ipsRegistry::getClass('output')->formCheckbox( "ban__ip_" . str_replace( '.', '_', $ip_address ), false );
							}
						}
					}
					
					$member_groups = array();
					
					foreach( ipsRegistry::cache()->getCache('group_cache') as $group )
					{
						if( $group['g_id'] == $member['member_group_id'] )
						{
							$member['_group_title'] = $group['g_title'];
						}

						$member_groups[] = array( $group['g_id'], $group['g_title'] );
					}
					
					$form['groups_confirm']	= ipsRegistry::getClass('output')->formCheckbox( "ban__group_change", 0 );
					$form['groups'] 		= ipsRegistry::getClass('output')->formDropdown( "ban__group", $member_groups, $member['member_group_id'] );
					
					$output = $html->inline_ban_member_form( $member, $form );
				break;
			}
			
			if( !$output AND $method AND method_exists( $html, $method ) )
			{
				$output = $html->$method( $member, $save_to, $div_id, $form_field, $text, $description );
			}
		}

		//-----------------------------------------
		// Print...
		//-----------------------------------------
		
		$this->returnHtml( $output );
	}
}