<?php

/**
 * Invision Power Services
 * IP.Board v3.1.0
 * Vkontakte auth : AJAX
 *
 * @author      $Author: giv $
 * @copyright   (c) 2010 IBResource, LTD.
 * @license     http://www.ibresource.ru/products/ipboard/
 * @package     IP.Board
 * @subpackage  Core
 * @since       1st June 2010 
 * @link        http://www.ibresource.ru
 * @version     $Rev: 6242 $
 */

if ( ! defined( 'IN_IPB' ) )
{
    print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
    exit();
}

class public_core_ajax_vkontakte extends ipsAjaxCommand 
{
    /**
     * Login handler object
     *
     * @access  protected
     * @var     object
     */
    protected $han_login;
    
    /**
     * Flag : Logged in
     *
     * @access  protected
     * @var     boolean
     */
    protected $logged_in        = false;
    
    /**
     * Class entry point
     *
     * @access  public
     * @param   object      Registry reference
     * @return  void        [Outputs to screen]
     */
    public function doExecute( ipsRegistry $registry ) 
    {

        /* What to do */
        switch( $this->request['do'] )
        {
            case 'getUserByVkId':
                $return = $this->_getUserByVkId();
            break;
        }
        
        /* Output */
        $this->returnHtml( $return );
    }
        
    /**
     * Main AJAX log in routine
     *
     * @access  private
     * @return  void        [Outputs JSON to browser AJAX call]
     */
    private function _getUserByVkId()
    {
        require_once( IPS_ROOT_PATH . 'sources/classes/vkontakte/connect.php' );
        $vk = new Vkontakte_Request_Validator( $this->settings['vk_api_id'], $this->settings['vk_secret'] );
        
        //-----------------------------------------
        // INIT
        //-----------------------------------------
        
        $vkUid = is_numeric( $vk->mid ) ? $vk->mid : -1;
        $member = array( 'member_id' => 0 );
        
        if ( $vkUid )
        {
            $_mid = $this->DB->buildAndFetch( array( 'select' => 'member_id',
                                                     'from'   => 'members',
                                                     'where'  => 'vk_uid=' . $vkUid ) );
                                                    
            if ( $_mid['member_id'] )
            {
                $member = IPSMember::load( $_mid['member_id'], 'all' );
            }
        }

        /* Create validating account for the member */
        $key = md5( uniqid( microtime() ) );
        $member['key'] = $key;

        if ( $vkUid == $this->request['id'] )
        {
            
            $this->DB->delete( 'vkontakte_connect', 'v_id = ' . $vkUid );
            
            $name = IPSMember::getFunction()->cleanAndCheckName( $this->request['name'], array(), 'name' );
            
            $photo = '';
            
            if ( IPSText::xssCheckUrl( $this->request['photo'] ) && preg_match('~^http://.+?\.vkontakte\.ru/u' . $vkUid. '~is', $this->request['photo']))
            {
                $photo = $this->request['photo'];
            }
            
            $this->DB->insert( 'vkontakte_connect', array( 'v_key'   => $key,
                                                           'v_user'  => $name['username'],
                                                           'v_data' => $photo,
                                                           'v_id'   => $vkUid ) );
                                                         
        }
        
        $this->returnJsonArray( $member );
    }
}