#!/usr/local/bin/php
<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v3.1.0
 * Main public executable wrapper.
 * Set-up and load module to run
 * Last Updated: $Date: 2010-01-15 10:18:44 -0500 (Fri, 15 Jan 2010) $
 * </pre>
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		IP.Board
 * @link		http://www.invisionpower.com
 * @version		$Rev: 5713 $
 *
 */

define( 'IPS_IS_SHELL', TRUE );
define( 'IPB_THIS_SCRIPT', 'public' );

if ( file_exists( './initdata.php' ) )
{
	require_once( './initdata.php' );
}
else
{
	require_once( '../initdata.php' );
}

require_once( IPS_ROOT_PATH . 'sources/base/ipsRegistry.php' );
require_once( IPS_ROOT_PATH . 'sources/base/ipsController.php' );

$reg = ipsRegistry::instance();
$reg->init();

$moo = new moo( $reg );

class moo
{
	function __construct( ipsRegistry $registry )
	{
		$this->registry   =  $registry;
		$this->DB         =  $this->registry->DB();
		$this->settings   =& $this->registry->fetchSettings();
		$this->request    =& $this->registry->fetchRequest();
		$this->cache      =  $this->registry->cache();
		$this->caches     =& $this->registry->cache()->fetchCaches();
		$this->stdin      =  fopen('php://stdin', 'r');
		
		$this->_print( "--------------------------------------------\nWelcome to the IP.Board IP.Downloads Topics Fixer\n--------------------------------------------\n" );
		$this->_print( "Start from row?\nEnter: " );

		$start = intval( $this->_fetchOption() );
		
		$this->_print( "Do X rows\nEnter: " );
		
		$end = intval( $this->_fetchOption() );
		
		$this->_doFiles( $start, $end );
	}
		
	/**
	 * Rebuild langs
	 */
	private function _doFiles( $_start, $end )
	{
		/* INIT */
		$start = time();
		$done  = 0;
		
		$this->DB->build( array( 'select' => '*',
								 'from'   => 'downloads_files',
								 'where'  => 'file_topicid <> 0',
								 'order'  => 'file_id ASC',
								 'add_join'	=> array(
													array(
														'select'	=> 'm.*',
														'from'		=> array( 'members' => 'm' ),
														'where'		=> 'm.member_id=f.file_submitter',
														'type'		=> 'left',
														),
								 'limit'  => array( $_start, $end ) ) );
								
		$t = $this->DB->execute();
		
		while( $file = $this->DB->fetch( $t ) )
		{
			$category = $this->registry->getClass('categories')->cat_lookup[ $file['file_cat'] ];
			
			if( !$file['file_id'] OR $file['file_open'] )
			{
				continue;
			}

			if( !$this->registry->getClass('idmFunctions')->checkPerms( $file ) )
			{
				continue;
			}
			
			//-----------------------------------------
			// Need to post a topic?
			//-----------------------------------------

			require_once( IPSLib::getAppDir('downloads') . '/sources/classes/topics.php' );
			$lib_topics = new topicsLibrary( $this->registry );

			$file['file_submitter_name']	= $file['members_display_name'];
			$file['file_open']				= 1;
	
			$lib_topics->sortTopic( $file, $category, $file['file_topicid'] ? 'edit' : 'new', true );


			if ( $done % 250 == 0 )
			{
				$this->_print( "Completed... " . $done . " (File ID=" . $row['file_id'] . " total=" . ( $_start + $done ) . ")" );
			}
			
			/* Clear cached queries */
			$this->DB->obj['cached_queries'] = array();
		}
		
		$end = time();
		$tkn = ( $end - $start) / 60;
		
		$this->_print( "FINISHED FILES. Took " . $tkn . "m\n" );
	}
	
	
	/**
	 * Out to stdout
	 */
	private function _print( $message, $newline="\n" )
	{
		$stdout = fopen('php://stdout', 'w');
		fwrite( $stdout, $message . $newline );
		fclose( $stdout );
	}
	
	/* Fetch option
	 *
	 */
	private function _fetchOption()
	{
		return trim( fgets( $this->stdin ) );
	}
}

exit();                 



?>