<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v3.1.3
 * AddonChat remote authentication file
 * Last Updated: $Date: 2010-01-15 10:18:44 -0500 (Fri, 15 Jan 2010) $
 * </pre>
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		IP.Board
 * @subpackage	Chat
 * @link		http://www.invisionpower.com
 * @version		$Rev: 5713 $
 * @see			http://support.addoninteractive.com/index.php?action=kb&article=31
 *
 */

/**
* Script type
*
*/
define( 'IPB_THIS_SCRIPT', 'public' );

if ( file_exists( './initdata.php' ) )
{
	require_once( './initdata.php' );
}
else
{
	require_once( '../initdata.php' );
}

/* Enforce access to bypass force member log in, etc */
define( 'IPS_ENFORCE_ACCESS', TRUE );

/**
 * IPB registry
 */
require_once( IPS_ROOT_PATH . 'sources/base/ipsRegistry.php' );
$ipbRegistry	= ipsRegistry::instance();
$ipbRegistry->init();

//===========================================================================
// AUTHORIZE...
//===========================================================================

define( 'GUEST', 0 );
define( 'MEMBER', 1 );
define( 'MOD' , 2 );
define( 'ADMIN' , 3 );

$allowed_groups			= ipsRegistry::$settings['chat_admin_groups'];
$moderator_groups		= ipsRegistry::$settings['chat_mod_groups'];
$access_groups			= ipsRegistry::$settings['chat_access_groups'];
$autologin				= 0;
$allow_guest_access		= ipsRegistry::$settings['chat_allow_guest'] == 1 ? MEMBER : GUEST;

// Stupid PHP changing it's mind on HTTP args

$username  = IPSText::parseCleanValue(urldecode(trim($_GET['username'])));
$password  = IPSText::parseCleanValue(urldecode(trim($_GET['password'])));
$ip        = IPSText::parseCleanValue(urldecode(trim($_GET['ip'])));

//----------------------------------------------
// Test for autologin.
//----------------------------------------------

if ( preg_match( "/^(?:[0-9a-z]){32}$/", $password ) )
{
	$autologin = 1;
}

//----------------------------------------------
// Main code
//----------------------------------------------

// Start off with the lowest accessibility

$output_int		= $allow_guest_access;
$output_name	= "";

//------------------------------
// Attempt to find the user
//------------------------------

ipsRegistry::DB()->build( array(	'select' 	=> 'm.*',
									'from'		=> array( 'members' => 'm' ),
									'where'		=> "m.members_l_display_name='".ipsRegistry::DB()->addSlashes(strtolower($username))."'",
									'limit'		=> array( 0, 1 ),
									'add_join'	=> array( array( 'select' => 'g.g_access_cp',
																 'from'   => array( 'groups' => 'g' ),
																 'where'  => 'g.g_id=m.member_group_id' ) )
							)		);
ipsRegistry::DB()->execute();

						
if ( ! $member = ipsRegistry::DB()->fetch() )
{
	die_nice($output_int);
	
	//-- script exits --//
}


if ( ! $member['member_id'] )
{
	// No member found - allow guest access?
	
	die_nice($output_int);
	
	//-- script exits --//
}

//------------------------------
// Update passy
//------------------------------

if ( ! $autologin )
{
	$md5_password = md5( md5( $member['members_pass_salt'] ) . md5($password) );
}
else
{
	$md5_password = $password;
}

//------------------------------
// Check password - member exists
//------------------------------

if ( $password != "" )
{
	// Password was entered..
	
	if ( $md5_password != $member['members_pass_hash'] )
	{
		// Password incorrect..
		
		die_nice($output_int);
		
		//-- script exits --//
	}
	else
	{
		$output_int = MEMBER;
	}
}
else
{
	// No password entered - die!
	// Do not allow guest access on reg. name
	
	die_nice($output_int);
		
	//-- script exits --//
}


//------------------------------
// Do we have any access?
//------------------------------


if ( ! preg_match( "/(^|,)".$member['member_group_id']."(,|$)/", $access_groups ) )
{
	die_nice();
}

//------------------------------
// Do we have admin access?
//------------------------------

if ( $member['g_access_cp'] )
{
	$output_int = ADMIN;
}

if ( preg_match( "/(^|,)".$member['member_group_id']."(,|$)/", $allowed_groups ) )
{
	$output_int = ADMIN;
}

if ( preg_match( "/(^|,)".$member['member_group_id']."(,|$)/", $moderator_groups ) )
{
	$output_int = MOD;
}


//------------------------------
// Spill the beans
//------------------------------

header( "Content-Type: text/plain" );

print "scras.version = 2.0\n";
print "user.usergroup.id = {$member['member_group_id']}\n";
print "user.uid = {$member['member_id']}\n";
print "user.usergroup.can_login = 1\n";

switch( $output_int )
{
	case ADMIN:
		print "user.usergroup.is_admin = 1\n";
		print "user.usergroup.can_kick = 1\n";
		print "user.usergroup.can_kick_admin = 1\n";
		print "user.usergroup.can_grant = 1\n";
		print "user.usergroup.can_cloak = 1\n";
		print "user.usergroup.can_see_cloak = 1\n";
		print "user.usergroup.can_ban = 1\n";
		print "user.usergroup.can_ban_subnet = 1\n";
		print "user.usergroup.can_system_speak = 1\n";
		print "user.usergroup.can_enable_moderation = 1\n";
		print "user.usergroup.can_silence = 1\n";
		print "user.usergroup.allow_html = 1\n";
		print "user.usergroup.can_launch_website = 1\n";
	break;
	
	case MOD:
		print "user.usergroup.is_super_moderator = 1\n";
		print "user.usergroup.can_kick = 1\n";
		print "user.usergroup.can_ban = 1\n";
		
	break;
}

if( ipsRegistry::$settings['chat_allow_bbcode'] )
{
	print "user.usergroup.allow_bbcode = 1\n";
	print "user.usergroup.allow_color = 1";
}
else
{
	print "user.usergroup.allow_bbcode = 0\n";
	print "user.usergroup.allow_color = 0";
}

//print "SCRAS^1.1\nAUTH^".$output_int."\nUID^".intval($member['member_id'])."\n";

exit();
	 
	 
function die_nice( $access=0 )
{
	// Dont disconnect here 'cos it shuts down sql before destructor is run
	//ipsRegistry::DB()->disconnect();
	header( "Content-Type: text/plain" );
	
	print "scras.version = 2.0\n";
	print "user.usergroup.id = " . ipsRegistry::$settings['guest_group'] . "\n";
	print "user.uid = 0\n";
	print "user.usergroup.can_login = 0";
	exit();
}

?>