<?php
if (!class_exists('vBShop_Item_Core'))
{
	die('No direct access allowed.');
}

class vBShop_Item_custom extends vBShop_Item_Core
{
	/**
	* The constructor
	*
	* @param	vBulletin	vBulletin registry
	* @param	array		Item info
	*/	
	public function __construct(&$registry, &$item)
	{
		parent::__construct($registry, $item);
		
		// Set purchase template
		$this->config['purchasetemplate'] = 'dbtech_vbshop_configure_custom';
	}
	
	/**
	* Function to call before every action
	*/	
	public function action()
	{
		if (!parent::action())
		{
			// This type is inactive
			return false;
		}
		
		// We made it!
		return true;
	}
	
	/**
	* Prints out an AdminCP form
	*/	
	public function print_admin_form($code)
	{
		global $vbphrase;
		
		if (VBSHOP::$isPro) 
		{
			// Finally print the select
			for ($i = 1; $i <= 5; $i++)
			{
				print_description_row($vbphrase['dbtech_vbshop_custom_field'], false, 2, 'optiontitle');
				print_input_row($vbphrase['dbtech_vbshop_field_title'], 	'item[code][' . $i . '][title]', 		$code[$i]['title']);
				print_yes_no_row($vbphrase['dbtech_vbshop_field_required'], 'item[code][' . $i . '][required]', 	(isset($code[$i]['required']) ? $code[$i]['required'] : 0));
			}
		}
	}
	
	/**
	* Configure an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Recipient
	*/	
	public function configure($purchaseid, $recipient = null)
	{
		global $vbphrase;
		
		if (!$this->can_configure($purchaseid))
		{
			// Can't configure this item
			return false;
		}
		
		// Ensure this is set
		$recipient = (!$recipient ? $this->registry->userinfo : $recipient);
		
		// Get the form code
		$code 			= $this->registry->input->clean_gpc('p', 'code', 			TYPE_ARRAY);
		$noConfigure 	= $this->registry->input->clean_gpc('p', '_noConfigure', 	TYPE_BOOL);
		
		if ($noConfigure)
		{
			// We're done, we wanted to let the recipient configure it themselves
			return true;
		}
		
		$values = array();
		foreach ($code as $key => $value)
		{
			if ($this->config['code'][$key]['required'] AND !$value)
			{
				// Ignore this
				eval(standard_error(fetch_error('dbtech_vbshop_invalid_data', $this->config['code'][$key]['title'])));						
			}
			
			if (!$value)
			{
				// Skip this
				continue;
			}
			
			// Add the values
			$values[] = $this->config['code'][$key]['title'] . ': ' . $value;
		}
		if ($this->config['notifications_config'])
		{
			$userids = explode(',', $this->config['notifications_config']);
			foreach ((array)$userids as $userid)
			{
				$pmrecipient = array('userid' => $userid);
				$this->send_pm(
					$recipient,
					$pmrecipient,
					construct_phrase($vbphrase['dbtech_vbshop_new_configuration_x'],
						$this->config['title']
					),
					construct_phrase($vbphrase['dbtech_vbshop_x_just_configured_y'],
						$recipient['username'],
						$this->config['title'],
						implode("\n", $values)
					)
				);
			}
		}
		
		// Update flag
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . "dbtech_vbshop_purchase
			SET configuration = " . $this->registry->db->sql_prepare(trim(serialize($code))) . "
			WHERE purchaseid = " . intval($purchaseid) . "
		");
		
		// Build purchase cache
		VBSHOP::build_purchases($recipient);				
	}	
}
?>