<?php
class vBShop_Item_Core
{
	/**
	* The vBulletin registry
	*
	* @protected	vBulletin
	*/	
	protected $registry = NULL;
	
	/**
	* The configuration array
	*
	* @public		array
	*/	
	public $config = array();
	
	/**
	* The purchase info array
	*
	* @protected	array
	*/	
	protected $purchaseinfo = array();
	
	
	/**
	* The constructor
	*
	* @param	vBulletin	vBulletin registry
	* @param	array		Item info
	*/	
	public function __construct(&$registry, &$item)
	{
		$this->registry =& $registry;
		$this->config =& $item;
		
		if (!is_array($this->config['code']))
		{
			// Ensure this is an array
			$this->config['code'] = array();
		}
		
		if (!is_array($this->config['permissions']))
		{
			// Ensure this is an array
			$this->config['permissions'] = array();
		}
		
		if (!is_array($this->config['configuration']))
		{
			// Ensure this is an array
			$this->config['configuration'] = @unserialize($this->config['configuration']);
			
			if (!is_array($this->config['configuration']))
			{
				// Ensure this is an array
				$this->config['configuration'] = array();
			}
		}
		
		// Set shop type
		$this->config['quantity'] = ($this->config['quantity'] ? $this->config['quantity'] : 1);
	}
	
	/**
	* Function to call before every action
	*/	
	public function action()
	{
		if (!$this->config['active'])
		{
			// This type is inactive
			//return false;
		}
		
		// We made it!
		return true;
	}
	
	/**
	* Form to purchase an item
	*/	
	public function render()
	{
		global $vbphrase;
		
		if (!$this->config['purchasetemplate'])
		{
			// Didn't have configuration
			return '';
		}
		
		// Begin the purchase template
		$templater = vB_Template::create($this->config['purchasetemplate']);
			$templater->register('item', $this->config);
		return $templater->render();
	}
	
	/**
	* Purchasing an item
	*
	* @param	array		User info
	*/	
	public function purchase(&$buyer)
	{
		global $vbphrase;
		
		if (!$buyer['userid'])
		{
			// We not doin dis
			return false;
		}
		
		if (!$currency = VBSHOP::$cache['currency'][$this->config['currencyid']])
		{
			// This currency doesn't exist anymore
			return false;
		}
				
		if (!$this->check_permissions($buyer))
		{
			// Check permissions failed
			return false;
		}
		
		if ($this->config['stock'] > -1 AND $this->config['stock'] < $this->config['quantity'])
		{
			// Not enough of these items
			return false;
		}				
		
		// Run pre-purchase checks that other actions may need to override
		$this->pre_purchase($buyer);
		
		for ($i = 0; $i < $this->config['quantity']; $i++)
		{
			if ($this->config['price'] > 0)
			{
				$remaining = $this->registry->db->query_first("
					SELECT " . $currency['pointscolumn'] . " AS points 
					FROM " . TABLE_PREFIX . $currency['pointstable'] . "
					WHERE userid = " . intval($buyer['userid'])
				);
				
				if ($remaining['points'] < $this->config['price'])
				{
					// Can't afford this
					return false;
				}

				// We're done with the error checking
				$this->registry->db->query_write("
					UPDATE " . TABLE_PREFIX . $currency['pointstable'] . "
					SET " . $currency['pointscolumn'] . " = " . $currency['pointscolumn'] . " - " . doubleval($this->config['price']) . "
					WHERE userid = " . intval($buyer['userid'])
				);
				
				if (VBSHOP::$cache['shop'][$this->config['shopid']]['ownerid'])
				{
					// Shop owner gains a sale
					$this->registry->db->query_write("
						UPDATE " . TABLE_PREFIX . $currency['pointstable'] . "
						SET " . $currency['pointscolumn'] . " = " . $currency['pointscolumn'] . " + " . doubleval($this->config['price']) . "
						WHERE userid = " . intval(VBSHOP::$cache['shop'][$this->config['shopid']]['ownerid'])
					);
					
					$info = array(
						'feature' 		=> 'item',
						'featureid' 	=> $this->config['itemid'],
						'shopid' 		=> $this->config['shopid'],
						'currencyid' 	=> $this->config['currencyid'],
						'price' 		=> $this->config['price']
					);
					
					// init data manager
					$dm =& VBSHOP::datamanager_init('Transactionlog', $this->registry, ERRTYPE_ARRAY);
						$dm->set('userid', 		$buyer['userid']);
						$dm->set('recipient', 	VBSHOP::$cache['shop'][$this->config['shopid']]['ownerid']);
						$dm->set('ipaddress', 	IPADDRESS);
						$dm->set('action', 		'sale');
						$dm->set('info', 		$info);
					$dm->save();
					unset($dm);	
				}
			}
			
			// Grant the purchase to the user
			$this->registry->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "dbtech_vbshop_purchase
					(userid, buyer, feature, featureid, shopid, dateline, active)
				VALUES (
					" . $buyer['userid'] . ",
					" . $buyer['userid'] . ",
					'item',
					" . $this->config['itemid'] . ",
					" . $this->config['shopid'] . ",
					" . TIMENOW . ",
					'0'
				)
			");
			$purchaseid = $this->registry->db->insert_id();			
			
			$info = array(
				'feature' 		=> 'item',
				'featureid' 	=> $this->config['itemid'],
				'shopid' 		=> $this->config['shopid'],
				'currencyid' 	=> $this->config['currencyid'],
				'price' 		=> $this->config['price']
			);
			
			// init data manager
			$dm =& VBSHOP::datamanager_init('Transactionlog', $this->registry, ERRTYPE_ARRAY);
				$dm->set('userid', 		$buyer['userid']);
				$dm->set('recipient', 	$buyer['userid']);
				$dm->set('ipaddress', 	IPADDRESS);
				$dm->set('action', 		'purchase');
				$dm->set('info', 		$info);
			$dm->save();
			unset($dm);	
			
			// Grab this
			$salesamounts = VBSHOP::$cache['shop'][$this->config['shopid']]['salesamounts'];
			$salesamounts[$this->config['currencyid']] += $this->config['price'];
			
			// init data manager
			$dm =& VBSHOP::datamanager_init('Item', $this->registry, ERRTYPE_ARRAY);
				$dm->set_existing(VBSHOP::$cache['item'][$this->config['itemid']]);
				$dm->set('purchases', 'purchases + 1', false);
			$dm->save();
			unset($dm);	
			
			// init data manager
			$dm =& VBSHOP::datamanager_init('Shop', $this->registry, ERRTYPE_ARRAY);
				$dm->set_existing(VBSHOP::$cache['shop'][$this->config['shopid']]);
				$dm->set('sales', 'sales + 1', false);
				$dm->set('latestsale', $this->config['itemid']);
				$dm->set('latestcustomer', $buyer['userid']);
				$dm->set('salesamounts', $salesamounts);
			$dm->save();
			unset($dm);	
			
			if ($existing = $this->registry->db->query_first("
				SELECT * 
				FROM " . TABLE_PREFIX . "dbtech_vbshop_shopinventory
				WHERE itemid = " . $this->config['itemid'] . "
					AND shopid = " . $this->config['shopid'] . "
					AND stock > 0
			"))
			{
				// init data manager
				$dm =& VBSHOP::datamanager_init('Shopinventory', $this->registry, ERRTYPE_ARRAY);
					$dm->set_existing($existing);
					$dm->set('stock', 'stock - 1', false);
				$dm->save();
				unset($dm);	
			}
		}
		
		// Rebuild the cache
		VBSHOP::build_purchases($buyer);
		
		if ($this->config['notifications'])
		{
			$userids = explode(',', $this->config['notifications']);
			foreach ((array)$userids as $userid)
			{
				$pmrecipient = array('userid' => $userid);
				$this->send_pm(
					$buyer,
					$pmrecipient,
					construct_phrase($vbphrase['dbtech_vbshop_new_sale_x'],
						$this->config['title']
					),
					construct_phrase($vbphrase['dbtech_vbshop_x_just_bought_y'],
						$buyer['username'],
						$this->config['title']
					)
				);
			}
		}
		
		// Activate the item
		$this->config['_activateoverride'] = true;
		$this->activate($purchaseid);
		
		// And we're done.
		return true;
	}
	
	/**
	* Gifting an item
	*
	* @param	integer		Purchase ID
	* @param	array		Buyer info
	* @param	array		Recipient info
	* @param	string		The message from the buyer
	*/	
	public function gift($purchaseid, &$buyer, &$recipient, $message = '')
	{
		global $vbphrase;
		
		if (!$this->can_gift($purchaseid))
		{
			// Can't gift this item
			return false;
		}
		
		$purchases = array();
		$purchases_q = $this->registry->db->query_read_slave("
			SELECT *		
			FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase
			WHERE feature = 'item'
				AND userid = " . intval($recipient['userid']) . "
		");
		while ($purchases_r = $this->registry->db->fetch_array($purchases_q))
		{
			$purchases["$purchases_r[featureid]"] = true;
		}
		
		if ($this->config['uniqueitem'] AND $purchases[$this->config['itemid']])
		{
			// Already bought it
			eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_unique_item_gifterror'])));
		}		
		
		// Send a PM about the gift
		$this->send_pm(
			$buyer,
			$recipient,
			construct_phrase($vbphrase['dbtech_vbshop_new_gift_from_x'],
				$buyer['username']
			),
			construct_phrase($vbphrase['dbtech_vbshop_new_gift_from_x_body'],
				$buyer['username'],
				$this->config['title'],
				$this->config['description'],
				$message
			)
		);
		
		// When transferring the purchase, ensure the item is set to inactive
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . "dbtech_vbshop_purchase
			SET 
				hidden = '0',
				userid = " . intval($recipient['userid']) . ",
				configuration = NULL,
				message = " . $this->registry->db->sql_prepare($message) . "
			WHERE purchaseid = " . intval($purchaseid)
		);
		
		$info = array(
			'feature' 		=> 'item',
			'featureid' 	=> $this->config['itemid'],
			'message' 		=> $message
		);
		
		// init data manager
		$dm =& VBSHOP::datamanager_init('Transactionlog', $this->registry, ERRTYPE_ARRAY);
			$dm->set('userid', 		$buyer['userid']);
			$dm->set('recipient', 	$recipient['userid']);
			$dm->set('ipaddress', 	IPADDRESS);
			$dm->set('action', 		'gift');
			$dm->set('info', 		$info);
		$dm->save();
		unset($dm);	
		
		// Activate item on gift
		$this->config['_isgift'] = true;
		$this->activate($purchaseid, $recipient);	
		
		if (method_exists($this, 'configure'))
		{
			// Configure the item
			$this->config['_overrideconfigerror'] = true;
			$this->configure($purchaseid, $recipient);
		}
		
		// Rebuild the cache
		VBSHOP::build_purchases($buyer);
		VBSHOP::build_purchases($recipient);
		
		return true;
	}
	
	/**
	* Activate an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Recipient
	*/	
	public function activate($purchaseid, $recipient = NULL, $dorebuild = true)
	{
		if (!$this->can_activate($purchaseid))
		{
			// We can't activate this item
			return false;
		}
		
		// Ensure this is set
		$recipient = ($recipient === NULL ? $this->registry->userinfo : $recipient);
		
		// Update flag
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . "dbtech_vbshop_purchase
			SET active = '1'
			WHERE purchaseid = " . intval($purchaseid) . "
		");
		
		if ($dorebuild)
		{
			// Build purchase cache
			VBSHOP::build_purchases($recipient);
		}
		
		return true;
	}
	
	/**
	* Deactivate an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Recipient
	*/	
	public function deactivate($purchaseid, $recipient = null, $dorebuild = true)
	{
		if (!$this->can_deactivate($purchaseid))
		{
			// Cannot deactivate
			return false;
		}
		
		// Ensure this is set
		$recipient = ($recipient === NULL ? $this->registry->userinfo : $recipient);
		
		// Update flag
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . "dbtech_vbshop_purchase
			SET active = '0'
			WHERE purchaseid = " . intval($purchaseid) . "
		");
		
		if ($dorebuild)
		{
			// Build purchase cache
			VBSHOP::build_purchases($recipient);
		}
		
		return true;
	}
		
	/**
	* Sell back an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Recipient
	*/	
	public function sell($purchaseid, $recipient = null)
	{
		if (!$this->can_sell($purchaseid))
		{
			// Can't sell this item
			return false;
		}
		
		if (!$currency = VBSHOP::$cache['currency'][$this->config['currencyid']])
		{
			// This currency doesn't exist anymore
			return false;
		}		
		
		// Ensure this is set
		$recipient = ($recipient === NULL ? $this->registry->userinfo : $recipient);
		
		// Ensure this can be deactivated
		$this->config['_deactivateoverride'] = true;
		
		// Deactivate the item
		$this->deactivate($purchaseid, $recipient);
		
		if ($this->config['buybackreplenish'])
		{
			if ($existing = $this->registry->db->query_first("
				SELECT * 
				FROM " . TABLE_PREFIX . "dbtech_vbshop_shopinventory
				WHERE itemid = " . $this->config['itemid'] . "
					AND shopid = " . $this->config['shopid'] . "
					AND stock > -1
			"))
			{
				// init data manager
				$dm =& VBSHOP::datamanager_init('Shopinventory', $this->registry, ERRTYPE_ARRAY);
					$dm->set_existing($existing);
					$dm->set('stock', 'stock + 1', false);
				$dm->save();
				unset($dm);	
			}
		}
		
		// We're done with the error checking
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . $currency['pointstable'] . "
			SET " . $currency['pointscolumn'] . " = " . $currency['pointscolumn'] . " + " . doubleval($this->config['buybackprice']) . "
			WHERE userid = " . intval($this->purchaseinfo['userid'])
		);	
		
		if (VBSHOP::$cache['shop'][$this->config['shopid']]['ownerid'])
		{
			$remaining = $this->registry->db->query_first("
				SELECT " . $currency['pointscolumn'] . " AS points 
				FROM " . TABLE_PREFIX . $currency['pointstable'] . "
				WHERE userid = " . intval(VBSHOP::$cache['shop'][$this->config['shopid']]['ownerid'])
			);
			
			if ($remaining['points'] < $this->config['buybackprice'])
			{
				// Can't afford to pay back
				$difference = $this->config['buybackprice'] - $remaining['points'];
				
				// Blank out our points
				$this->registry->db->query_write("
					UPDATE " . TABLE_PREFIX . $currency['pointstable'] . "
					SET " . $currency['pointscolumn'] . " = 0
					WHERE userid = " . intval(VBSHOP::$cache['shop'][$this->config['shopid']]['ownerid'])
				);
				
				// Take the difference from bank as we KNOW this can go into minus
				$this->registry->db->query_write("
					UPDATE " . TABLE_PREFIX . "dbtech_vbshop_bank
					SET points = points - " . doubleval($difference) . "
					WHERE userid = " . intval(VBSHOP::$cache['shop'][$this->config['shopid']]['ownerid']) . "
						AND currencyid = " . intval($currency['currencyid'])
				);
			}
			else
			{
				// Owner could afford to pay back
				$this->registry->db->query_write("
					UPDATE " . TABLE_PREFIX . $currency['pointstable'] . "
					SET " . $currency['pointscolumn'] . " = " . $currency['pointscolumn'] . " - " . doubleval($this->config['buybackprice']) . "
					WHERE userid = " . intval(VBSHOP::$cache['shop'][$this->config['shopid']]['ownerid'])
				);				
			}
		}
		
		$info = array(
			'feature' 		=> 'item',
			'featureid' 	=> $this->config['itemid'],
			'shopid' 		=> $this->config['shopid'],
			'currencyid' 	=> $this->config['currencyid'],
			'price' 		=> $this->config['buybackprice']
		);
		
		// init data manager
		$dm =& VBSHOP::datamanager_init('Transactionlog', $this->registry, ERRTYPE_ARRAY);
			$dm->set('userid', 		$this->purchaseinfo['userid']);
			$dm->set('recipient', 	(VBSHOP::$cache['shop'][$this->config['shopid']]['ownerid'] ? VBSHOP::$cache['shop'][$this->config['shopid']]['ownerid'] : $this->purchaseinfo['userid']));
			$dm->set('ipaddress', 	IPADDRESS);
			$dm->set('action', 		'sellback');
			$dm->set('info', 		$info);
		$dm->save();
		unset($dm);		
		
		$this->registry->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase
			WHERE purchaseid = " . intval($purchaseid) . "
		");
		
		// Build purchase cache
		VBSHOP::build_purchases($recipient);		
		
		return true;
	}
	
	/**
	* Discard an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Recipient
	*/	
	public function discard($purchaseid, $recipient = null)
	{
		if (!$this->can_discard($purchaseid))
		{
			// We can't discard this item
			return false;
		}
		
		// Ensure this is set
		$recipient = ($recipient === NULL ? $this->registry->userinfo : $recipient);		
		
		// Ensure this can be deactivated
		$this->config['_deactivateoverride'] = true;
		
		// Deactivate the item
		$this->deactivate($purchaseid);
		
		$info = array(
			'feature' 		=> 'item',
			'featureid' 	=> $this->config['itemid'],
			'shopid' 		=> $this->config['shopid'],
		);
		
		// init data manager
		$dm =& VBSHOP::datamanager_init('Transactionlog', $this->registry, ERRTYPE_ARRAY);
			$dm->set('userid', 		$this->purchaseinfo['userid']);
			$dm->set('recipient', 	$this->purchaseinfo['userid']);
			$dm->set('ipaddress', 	IPADDRESS);
			$dm->set('action', 		'discard');
			$dm->set('info', 		$info);
		$dm->save();
		unset($dm);		
		
		$this->registry->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase
			WHERE purchaseid = " . intval($purchaseid) . "
		");
		
		// Build purchase cache
		VBSHOP::build_purchases($recipient);		
		
		return true;
	}
	
	
	
	
	
	/**
	* Whether we can configure an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Purchase info
	*/		
	public function can_configure($purchaseid, $purchase = null)
	{
		if (!$this->config['_overrideconfigerror'])
		{
			if (!$this->config['reconfigure'] AND ($this->config['configuration'] !== NULL AND count($this->config['configuration'])))
			{
				// Cannot configure this item
				return false;
			}	
			
			if ($this->config['onlygiftable'] AND !$this->config['_configureoverride'])
			{
				// Cannot configure this item
				return false;
			}
			
			if (($this->config['duration'] > 0 AND TIMENOW >= ($this->config['dateline'] + ($this->config['duration'] * 86400))) AND !$this->config['_configureoverride'])
			{
				// Cannot activate this item
				return false;
			}
		}
		
		return true;		
	}
	
	/**
	* Whether we can activate an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Purchase info
	*/		
	public function can_activate($purchaseid, $purchase = null)
	{
		if ($this->config['onlygiftable'] AND !$this->config['_isgift'])
		{
			// Cannot activate this item
			return false;
		}
		
		if (($this->config['duration'] > 0 AND TIMENOW >= ($this->config['dateline'] + ($this->config['duration'] * 86400))) AND !$this->config['_activateoverride'])
		{
			// Cannot activate this item
			return false;
		}
		
		return true;		
	}
	
	/**
	* Whether we can deactivate an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Purchase info
	*/		
	public function can_deactivate($purchaseid, $purchase = null)
	{
		if ($this->config['_nodeactivate'] AND !$this->config['_deactivateoverride'])
		{
			// Cannot deactivate
			return false;
		}
		
		return true;		
	}
	
	/**
	* Whether we can gift an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Purchase info
	*/	
	public function can_gift($purchaseid, $purchase = null)
	{
		if (!$this->config['giftable'])
		{
			// Not giftable
			return false;
		}
		
		if (!is_array($purchase))
		{
			if (!$this->purchaseinfo = $this->registry->db->query_first("
				SELECT *
				FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase
				WHERE purchaseid = " . intval($purchaseid)
			))
			{
				// Purchase didn't exist
				return false;
			}
		}
		else
		{
			// Set purchase info
			$this->purchaseinfo = $purchase;
		}
		
		if (($this->purchaseinfo['userid'] != $this->purchaseinfo['buyer']) AND !$this->config['regift'])
		{
			// Re-gifting gifts? You horrible person.
			return false;
		}
		
		return true;
	}
	
	/**
	* Whether we can sell back an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Purchase info
	*/	
	public function can_sell($purchaseid, $purchase = null)
	{
		if ($this->config['_nosellback'])
		{
			// Cannot sellback
			return false;
		}
		
		if (!$currency = VBSHOP::$cache['currency'][$this->config['currencyid']])
		{
			// This currency doesn't exist anymore
			return false;
		}		
		
		if (!is_array($purchase))
		{
			if (!$this->purchaseinfo = $this->registry->db->query_first("
				SELECT *
				FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase
				WHERE purchaseid = " . intval($purchaseid)
			))
			{
				// Purchase didn't exist
				return false;
			}
		}
		else
		{
			// Set purchase info
			$this->purchaseinfo = $purchase;
		}
		
		if ($this->purchaseinfo['userid'] != $this->purchaseinfo['buyer'])
		{
			// Selling gifts? You horrible person.
			return false;
		}
		
		if (!$this->config['buybackprice'])
		{
			// Store isn't buying back this item
			return false;
		}
		
		if ($this->config['buybacktime'] AND (TIMENOW - $this->purchaseinfo['dateline']) > ($this->config['buybacktime'] * 3600))
		{
			// Too late
			return false;
		}
		
		return true;		
	}
	
	/**
	* Whether we can discard an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Purchase info
	*/	
	public function can_discard($purchaseid, $purchase = null)
	{
		if (!is_array($purchase))
		{
			if (!$this->purchaseinfo = $this->registry->db->query_first("
				SELECT *
				FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase
				WHERE purchaseid = " . intval($purchaseid)
			))
			{
				// Purchase didn't exist
				return false;
			}
		}
		else
		{
			// Set purchase info
			$this->purchaseinfo = $purchase;
		}
		
		return true;		
	}


	
	/**
	* Sends a PM
	*
	* @param	array	The user who made this purchase
	* @param	array	The user who's receiving the item
	*/	
	public function send_pm($sender, $recipient, $title, $message)
	{
		global $vbphrase;
		
		// Who's the PM to
		$pmto = (!$recipient['username'] ? fetch_userinfo($recipient['userid']) : $recipient);
		
		// Send pm
		$pmdm =& datamanager_init('PM', $this->registry, ERRTYPE_ARRAY);
			$pmdm->set_info('is_automated', true); // implies overridequota
			$pmdm->set('fromuserid', 	$sender['userid']);
			$pmdm->set('fromusername', 	$sender['username']);
			$pmdm->set_recipients($pmto['username'], $sender['permissions'], 'cc');
			$pmdm->setr('title', 		$title);
			$pmdm->setr('message', 		$message);
			$pmdm->set('dateline', 		TIMENOW);
			$pmdm->set('allowsmilie', 	0);
		$pmdm->save();
	}
	
	/**
	* Check if we have permissions to buy an item
	*
	* @param	array		User info
	*/	
	public function check_permissions(&$user)
	{
		// Wrapper
		return VBSHOP::check_permissions($user, $this->config['permissions']);
	}
	
	/**
	* Purchasing an item
	*/	
	protected function pre_purchase() {}	
}
?>