<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for shopinventorys
*
* @package	vbshop
*/
class vBShop_DataManager_Shopinventory extends vB_DataManager
{
	/**
	* Array of recognised and required fields for shopinventorys, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'shopid' 				=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD, 	'verify_shopid'),
		'itemid' 				=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD, 	'verify_itemid'),
		'currencyid' 			=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD, 	'verify_currencyid'),		
		'price' 				=> array(TYPE_UNUM, 	REQ_NO),
		'buybackprice' 			=> array(TYPE_UNUM, 	REQ_NO),
		'buybacktime' 			=> array(TYPE_UINT, 	REQ_NO),
		'buybackreplenish' 		=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
		'notifications' 		=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_commalist'),
		'notifications_config' 	=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_commalist'),
		'stock' 				=> array(TYPE_INT, 		REQ_NO),
		'maxstock' 				=> array(TYPE_INT, 		REQ_NO),
		'refilltime' 			=> array(TYPE_UINT, 	REQ_NO),
		'lastrefill' 			=> array(TYPE_UNIXTIME, REQ_NO),
		'configured' 			=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_vbshop_shopinventory';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('shopid = %1$d AND itemid = %2$d', 'shopid', 'itemid');

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function vBShop_DataManager_Shopinventory(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);

		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_shopinventorydata_start')) ? eval($hook) : false;
	}

	/**
	* Verifies that the onoff flag is valid
	*
	* @param	string	On/Off flag
	*
	* @return	boolean
	*/
	function verify_onoff(&$onoff)
	{
		// Validate onoff
		$onoff = (!in_array($onoff, array('0', '1')) ? '1' : $onoff);
		
		return true;
	}
	
	/**
	* Verifies that the specified user exists
	*
	* @param	integer	User ID
	*
	* @return 	boolean	Returns true if user exists
	*/
	function verify_userid(&$userid)
	{
		if ($userid == 0)
		{
			// 0 is valid in this case 
			return true;
		}

		return parent::verify_userid($userid);
	}

	/**
	* Verifies that the shopid is valid
	*
	* @param	integer	shopid
	*
	* @return	boolean
	*/
	function verify_shopid(&$shopid)
	{
		// Validate shopid
		return is_array(VBSHOP::$cache['shop']["$shopid"]);
	}

	/**
	* Verifies that the itemid is valid
	*
	* @param	integer	itemid
	*
	* @return	boolean
	*/
	function verify_itemid(&$itemid)
	{
		// Validate itemid
		return is_array(VBSHOP::$cache['item']["$itemid"]);
	}

	/**
	* Verifies that the currencyid is valid
	*
	* @param	integer	currencyid
	*
	* @return	boolean
	*/
	function verify_currencyid(&$currencyid)
	{
		// Validate currencyid
		return is_array(VBSHOP::$cache['currency']["$currencyid"]);
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}
		
		if ($this->fetch_field('stock') == -1)
		{
			// Override maxstock
			$maxstock = -1;
			$this->do_set('maxstock', $maxstock);
		}
		else
		{
			if ($this->fetch_field('maxstock') < $this->fetch_field('stock'))
			{
				if (!is_numeric($this->fetch_field('stock')))
				{
					// Override maxstock
					$this->set('maxstock', 'maxstock - 1', false);
				}
				else
				{
					// Override maxstock
					$this->do_set('maxstock', $this->fetch_field('stock'));
				}
			}
		}
		
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_shopinventorydata_presave')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}
	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_shopinventorydata_predelete')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_shopinventorydata_postsave')) ? eval($hook) : false;

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_shopinventorydata_delete')) ? eval($hook) : false;
		
		return true;
	}
}


/*======================================================================*\
|| ####################################################################
|| # Created: 16:52, Sat Dec 26th 2009
|| # SVN: $ $Rev$ $ - $ $Date$ $
|| ####################################################################
\*======================================================================*/