<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// vBShop functionality class

/**
* Handles everything to do with vBShop.
*
* @package	vBShop
* @version	$ $Rev$ $
* @date		$ $Date$ $
*/
class VBSHOP
{
	/**
	* Version info
	*
	* @public	mixed
	*/	
	public static $jQueryVersion 	= '1.7.2';	
	public static $version 			= '2.2.5';
	public static $versionnumber	= 225;
	
	/**
	* The vBulletin registry object
	*
	* @private	vB_Registry
	*/	
	protected static $vbulletin 	= NULL;
	
	/**
	* The vBulletin registry object
	*
	* @private	vB_Registry
	*/	
	protected static $prefix 		= 'dbtech_';
	
	/**
	* The vBulletin registry object
	*
	* @private	vB_Registry
	*/	
	protected static $bitfieldgroup	= 'vbshoppermissions';
	
	/**
	* Array of permissions to be returned
	*
	* @public	array
	*/	
	public static $permissions 		= NULL;
	
	/**
	* Array of cached items
	*
	* @public	array
	*/		
	public static $cache			= array();
	
	/**
	* Whether we've called the DM fetcher
	*
	* @public	boolean
	*/		
	protected static $called		= false;
	
	/**
	* Array of cached items
	*
	* @public	array
	*/		
	public static $unserialize		= array(
		'category' => array(
			'permissions',
		),
		'item' => array(
			'permissions',
			'code',
		),
		'lottery' => array(
			'permissions',
			'numbers',
			'drawnnumbers',
			'prizes',
		),
		'lotteryprize' => array(
			'numbers',
		),
		'shop' => array(
			'permissions',
			'salesamounts',
		),
	);
	
	/**
	* Array of postbits
	*
	* @public	array
	*/	
	public static $postbitcache 	= array();
	public static $postbitcache2 	= array();
	
	/**
	* Whether we have the pro version or not
	*
	* @public	boolean
	*/		
	public static $isPro		= false;

	
	/**
	* Does important checking before anything else should be going on
	*
	* @param	vB_Registry	Registry object
	*/
	public static function init($vbulletin)
	{
		// Check if the vBulletin Registry is an object
		if (!is_object($vbulletin))
		{
			// Something went wrong here I think
			trigger_error("Registry object is not an object", E_USER_ERROR);
		}
		
		// Set registry
		self::$vbulletin =& $vbulletin;
		
		// Set permissions shorthand
		self::get_permissions();
		
		foreach (self::$unserialize as $cachetype => $keys)
		{
			foreach ((array)self::$cache[$cachetype] as $id => $arr)
			{
				foreach ($keys as $key)
				{
					// Do unserialize
					self::$cache[$cachetype][$id][$key] = @unserialize($arr[$key]);
				}
			}
		}
		
		// Set pro version
		
	}
	
	/**
	* Grabs what permissions we have got
	*/
	public static function get_permissions()
	{
		// Override bitfieldgroup variable
		$bitfieldgroup = self::$prefix . self::$bitfieldgroup;
		
		if (!is_array(self::$vbulletin->bf_ugp[$bitfieldgroup]))
		{
			// Something went wrong here I think
			require_once(DIR . '/includes/class_bitfield_builder.php');
			if (vB_Bitfield_Builder::build(false) !== false)
			{
				$myobj =& vB_Bitfield_Builder::init();
				if (sizeof($myobj->data['ugp'][$bitfieldgroup]) != sizeof(self::$vbulletin->bf_ugp[$bitfieldgroup]))
				{
					require_once(DIR . '/includes/adminfunctions.php');					
					$myobj->save(self::$vbulletin->db);
					build_forum_permissions();
					
					if (IN_CONTROL_PANEL === true)
					{
						define('CP_REDIRECT', self::$vbulletin->scriptpath);
						print_stop_message('rebuilt_bitfields_successfully');
					}
					else
					{
						self::$vbulletin->url = self::$vbulletin->scriptpath;
						eval(print_standard_redirect(array('redirect_updatethanks', self::$vbulletin->userinfo['username']), true, true));				
					}
				}
			}
			else
			{
				echo "<strong>error</strong>\n";
				print_r(vB_Bitfield_Builder::fetch_errors());
				die();
			}
		}
		
		if (!self::$vbulletin->userinfo['permissions'])
		{
			// For some reason, this is missing
			cache_permissions(self::$vbulletin->userinfo);
		}
		
		foreach ((array)self::$vbulletin->bf_ugp[$bitfieldgroup] as $permname => $bit)
		{
			// Set the permission
			self::$permissions[$permname] = (!$bit ? self::$vbulletin->userinfo['permissions'][$bitfieldgroup][$permname] : (self::$vbulletin->userinfo['permissions'][$bitfieldgroup] & $bit ? 1 : 0));
		}
		
		// What permissions to override
		$override = array(
			'canview',
		);
		
		foreach ($override as $permname)
		{
			// Override various permissions
			self::$permissions[$permname] = (self::$permissions['ismanager'] ? 1 : self::$permissions[$permname]);
		}
	}
	
	/**
	* Quick Method of building the CPNav Template
	*
	* @param	string	The selected item in the CPNav
	*/	
	public static function construct_nav($selectedcell = 'main')
	{
		global $navclass, $vbphrase;
		global $vbulletin, $show, $template_hook;
	
		$cells = array(
			'shop',
			'inventory',
			'shopmanagement',
			'itemmanagement',
			'transactionlog',
			'bank',
			'steal',
			'donate',
			'lottery',
		);
	
		//($hook = vBulletinHook::fetch_hook('usercp_nav_start')) ? eval($hook) : false;
		
		// set the class for each cell/group
		$navclass = array();
		foreach ($cells AS $cellname)
		{
			$navclass[$cellname] = (intval(self::$vbulletin->versionnumber) == 3 ? 'alt2' : 'inactive');
		}
		$navclass[$selectedcell] = (intval(self::$vbulletin->versionnumber) == 3 ? 'alt1' : 'active');
		//($hook = vBulletinHook::fetch_hook('usercp_nav_complete')) ? eval($hook) : false;
	}
		
	/**
	* Check if we have permissions to perform an action
	*
	* @param	array		User info
	* @param	array		Permissions info
	*/		
	public static function check_permissions(&$user, $permissions)
	{
		if (!$user['usergroupid'] OR (!isset($user['membergroupids']) AND $user['userid']))
		{
			// Ensure we have this
			$user = fetch_userinfo($user['userid']);
		}
		
		if (!is_array($user['permissions']))
		{
			// Ensure we have the perms
			cache_permissions($user);
		}
		
		$ugs = fetch_membergroupids_array($user);		
		if (!$ugs[0])
		{
			// Hardcode guests
			$ugs[0] = 1;
		}

		//self::$vbulletin->usergroupcache
		foreach ($ugs as $usergroupid)
		{
			$value = $permissions["$usergroupid"];
			$value = (isset($value) ? $value : -1);
			
			switch ($value)
			{
				case 1:
					// Allow
					return true;
					break;
				
				case -1:
					// Usergroup Default		
					if (!($user['permissions'][self::$prefix . self::$bitfieldgroup] & 4))
					{
						// Allow by default
						return true;
					}
					break;
			}
		}
		
		// We didn't make it
		return false;
	}
	
	/**
	* Ensures the purchases cache is enabled and working
	*
	* @param	array	The user whose cache we're ensuring
	* @param	boolean	(Optional) Do run cache update query?
	* @param	boolean	(Optional) Do attempt to unserialize?
	*/
	public function verify_purchases(&$userinfo, $updatecache = true, $unserialize = true)
	{
		if (!$userinfo['userid'])
		{
			// This isn't a valid user
			$userinfo['dbtech_vbshop_purchase'] = array();
			return false;
		}
		
		if (!isset($userinfo['dbtech_vbshop_purchase']))
		{
			// Add purchases to the userinfo array
			$extrauserinfo = fetch_userinfo($userinfo['userid'], 1);
			$userinfo['dbtech_vbshop_purchase'] = $extrauserinfo['dbtech_vbshop_purchase'];
		}
		
		if ($userinfo['dbtech_vbshop_purchase'] === NULL)
		{
			// Rebuild the purchases cache for this user
			self::build_purchases($userinfo);
		}
		else
		{
			if ($unserialize AND !is_array($userinfo['dbtech_vbshop_purchase']))
			{
				// Attempt to unserialize
				$userinfo['dbtech_vbshop_purchase'] = @unserialize($userinfo['dbtech_vbshop_purchase']);
			}
			
			if (!is_array($userinfo['dbtech_vbshop_purchase']))
			{
				// User had no purchases
				$userinfo['dbtech_vbshop_purchase'] = array();
			}
		}
	}
	
	/**
	* Rebuilds the purchases cache
	*
	* @param	array	The user whose cache we're ensuring
	*/	
	public function build_purchases(&$userinfo)
	{
		if (!$userinfo['userid'])
		{
			// This isn't a valid user
			return false;
		}
		
		// Has no purchases cache generated
		$userinfo['dbtech_vbshop_purchase'] = array();
		
		// Insert the purchase				OR buyer = " . $userinfo['userid'] . "
		$purchases_q = self::$vbulletin->db->query_read_slave("
			SELECT *
			FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase
			WHERE userid = " . $userinfo['userid'] . "
			ORDER BY dateline DESC
		");
		while ($purchases_r = self::$vbulletin->db->fetch_array($purchases_q))
		{
			if (!self::$cache[$purchases_r['feature']][$purchases_r['featureid']])
			{
				// Not a valid purchase
				self::$vbulletin->db->query_write("
					DELETE FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase
					WHERE purchaseid = " . $purchases_r['purchaseid'] . "
				");
				continue;
			}
			
			// Set the cache
			$userinfo['dbtech_vbshop_purchase']["$purchases_r[purchaseid]"] = $purchases_r;
		}
		self::$vbulletin->db->free_result($purchases_q);
		unset($purchases_r);				
		
		// Update the database
		self::$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "user
			SET dbtech_vbshop_purchase = '" . self::$vbulletin->db->escape_string(trim(serialize($userinfo['dbtech_vbshop_purchase']))) . "'
			WHERE userid = " . $userinfo['userid'] . "
		");
	}
	
	/**
	* Initialises an item class.
	*
	* @param	array	Item info
	*/
	public function init_item($item)
	{
		if (!class_exists('vBShop_Item_Core'))
		{
			// Include the needed class
			require_once(DIR . '/dbtech/vbshop/includes/class_items_core.php');
		}
		
		if (!is_file(DIR . VBSHOP::$cache['itemtype']["$item[itemtypeid]"]['filename']) OR $item == NULL)
		{
			// We don't want to init this
			return new vBShop_Item_Core(self::$vbulletin, $item);
		}
		
		$classname = 'vBShop_Item_' . $item['itemtypeid'];
		if (!class_exists($classname))
		{
			// Include the needed class
			require_once(DIR . VBSHOP::$cache['itemtype']["$item[itemtypeid]"]['filename']);
		}
		
		// Return the object
		return new $classname(self::$vbulletin, $item);
	}
	
	
	/**
	* Checks the price of an item and determines if we can afford it
	*
	* @param	array	Item Info
	* @param	array	User Info
	*/
	public function check_price($item, $userinfo = NULL)
	{
		if (!$currency = self::$cache['currency']["$item[currencyid]"])
		{
			// This currency doesn't exist anymore
			return false;
		}
		
		if ($userinfo === NULL)
		{
			// We're using current user
			$userinfo = self::$vbulletin->userinfo;
		}
		
		if (!isset($userinfo["$currency[pointscolumn]"]) OR $userinfo["$currency[pointscolumn]"] < $item['price'])
		{
			// Couldn't afford it
			return false;
		}
		
		// Yay we can afford it
		return true;
	}	
	
	/**
	 * Constructs a bitfield row
	 *
	 * @param	string	The label text
	 * @param	string	The name of the row for the form
	 * @param	string	What bitfields we are using
	 * @param	integer	The value of the setting
	 */	
	public function print_bitfield_row($text, $name, $bitfield, $value)
	{
		global $vbulletin, $vbphrase;
	
		require_once(DIR . '/includes/adminfunctions.php');
		require_once(DIR . '/includes/adminfunctions_options.php');
		
		// make sure all rows use the alt1 class
		$bgcounter--;
	
		$value = intval($value);
		$HTML = '';
		$bitfielddefs =& fetch_bitfield_definitions($bitfield);

		if ($bitfielddefs === NULL)
		{
			print_label_row($text, construct_phrase("<strong>$vbphrase[settings_bitfield_error]</strong>", implode(',', vB_Bitfield_Builder::fetch_errors())), '', 'top', $name, 40);
		}
		else
		{
			#$HTML .= "<fieldset><legend>$vbphrase[yes] / $vbphrase[no]</legend>";
			$HTML .= "<div id=\"ctrl_{$name}\" class=\"smallfont\">\r\n";
			$HTML .= "<input type=\"hidden\" name=\"{$name}[0]\" value=\"0\" />\r\n";
			foreach ($bitfielddefs AS $key => $val)
			{
				$val = intval($val);
				$HTML .= "<table style=\"width:175px; float:left\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr valign=\"top\">
				<td><input type=\"checkbox\" name=\"{$name}[$val]\" id=\"{$name}_$key\" value=\"$val\"" . (($value & $val) ? ' checked="checked"' : '') . " /></td>
				<td width=\"100%\" style=\"padding-top:4px\"><label for=\"{$name}_$key\" class=\"smallfont\">" . fetch_phrase_from_key($key) . "</label></td>\r\n</tr></table>\r\n";
			}

			$HTML .= "</div>\r\n";
			#$HTML .= "</fieldset>";
			print_label_row($text, $HTML, '', 'top', $name, 40);
		}		
	}	
	
	/**
	* Class factory. This is used for instantiating the extended classes.
	*
	* @param	string			The type of the class to be called (user, forum etc.)
	* @param	vB_Registry		An instance of the vB_Registry object.
	* @param	integer			One of the ERRTYPE_x constants
	*
	* @return	vB_DataManager	An instance of the desired class
	*/
	public static function &datamanager_init($classtype, &$registry, $errtype = ERRTYPE_STANDARD)
	{
		if (empty(self::$called))
		{
			// include the abstract base class
			require_once(DIR . '/includes/class_dm.php');
			self::$called = true;
		}
	
		if (preg_match('#^\w+$#', $classtype))
		{
			require_once(DIR . '/dbtech/vbshop/includes/class_dm_' . strtolower($classtype) . '.php');
	
			$classname = 'vBShop_DataManager_' . $classtype;
			$object = new $classname($registry, $errtype);
	
			return $object;
		}
	}
	
	/**
	* JS class fetcher for AdminCP
	*
	* @param	string	The JS file name or the code
	* @param	boolean	Whether it's a file or actual JS code
	*/
	public static function js($js = '', $file = true, $echo = true)
	{
		global $vbulletin;

		$output = '';
		if ($file)
		{
			$output = '<script type="text/javascript" src="' . $vbulletin->options['bburl'] . '/dbtech/vbshop/clientscript/vbshop' . $js . '.js?v=' . self::$versionnumber . '"></script>';
		}
		else
		{
			$output = "
				<script type=\"text/javascript\">
					<!--
					$js
					// -->
				</script>
			";
		}
		
		if ($echo)
		{
			echo $output;
		}
		else
		{
			return $output;
		}
	}
	
	/**
	* Returns a 'depth mark' for use in prefixing items that need to show depth in a hierarchy
	*
	* @param	integer	Depth of item (0 = no depth, 3 = third level depth)
	* @param	string	Character or string to repeat $depth times to build the depth mark
	* @param	string	Existing depth mark to append to
	*
	* @return	string
	*/
	function construct_depth_mark($depth, $depthchar, $depthmark = '')
	{
		for ($i = 0; $i < $depth; $i++)
		{
			$depthmark .= $depthchar;
		}
		return $depthmark;
	}

	/**
	* Breaks down a difference (in seconds) into its days / hours / minutes / seconds components.
	*
	* @param	integer	Difference (in seconds)
	*
	* @return	array
	*/
	function fetch_time_breakdown($difference)
	{
		$breakdown = array();
		
		// Set days
		$breakdown['days'] = intval($difference / 86400);
		$difference -= ($breakdown['days'] * 86400);
		
		// Set hours
		$breakdown['hours'] = intval($difference / 3600);
		$difference -= ($breakdown['hours'] * 3600);
		
		// Set minutes
		$breakdown['minutes'] = intval($difference / 60);
		$difference -= ($breakdown['minutes'] * 60);
		
		// Set seconds
		$breakdown['seconds'] = intval($difference);
		
		return $breakdown;
	}
}


// #############################################################################
// filter functionality class

/**
* Class that handles filtering arrays
*
* @package	Framework
* @version	$ $Rev$ $
* @date		$ $Date$ $
*/
class VBSHOP_FILTER
{
	/**
	* Id Field we are using
	*
	* @private	string
	*/	
	private static $idfield 	= NULL;
	
	/**
	* Id value we are looking for
	*
	* @private	mixed
	*/	
	private static $idval 		= NULL;
	
	
	
	/**
	* Sets up and begins the filtering process 
	*
	* @param	array	Array to filter
	* @param	string	What the ID Field is
	* @param	mixed	What we are looking for
	*
	* @return	array	Filtered array
	*/
	public static function filter($array, $idfield, $idval)
	{
		// Set the two things we can't pass on to the callback
		self::$idfield 	= $idfield;
		self::$idval	= $idval;
		
		// Filter this shiet
		return array_filter($array, array(__CLASS__, 'do_filter'));
	}
	
	/**
	* Checks if this element should be included
	*
	* @param	array	Array to filter
	*
	* @return	boolean	Whether we should include this or not
	*/	
	protected static function do_filter($array)
	{
		$idfield 	= self::$idfield;
		$idval		= self::$idval;
		return ($array["$idfield"] == $idval);
	}
}

function vbshop_js_escape_string(&$arr)
{
	$find = array(
		"\r\n",
		"\n",
		"\t",
		'"'
	);
	
	$replace = array(
		'\r\n',
		'\n',
		'\t',
		'\"',
	);
	
	$arr = str_replace($find, $replace, $arr);
}

function vbshop_json_encode($arr, $assoc = true, $doescape = true)
{
	if ($doescape)
	{
		vbshop_js_escape_string($arr);
	}
	if (!$assoc)
	{
		// Not associative, simple return
		return '{"' . implode('","', $arr) . '"}';
	}
	
	$content = array();
	foreach ((array)$arr as $key => $val)
	{
		$content[] = '"' . $key . '":"' . $val . '"';
	}
	$retval = '{' . implode(',', $content) . '}';
	
	return $retval;
}

/*======================================================================*\
|| ####################################################################
|| # Created: 16:52, Sat Dec 26th 2009
|| # SVN: $ $Rev$ $ - $ $Date$ $
|| ####################################################################
\*======================================================================*/