<?php
global $vbulletin;

if (intval($vbulletin->versionnumber) == 3 AND !class_exists('vB_Template'))
{
	// We need the template class
	require_once(DIR . '/dbtech/vbshop/includes/class_template.php');
}	

if (!class_exists('VBSHOP'))
{
	global $show, $specialtemplates;
	
	// Fetch required classes
	require_once(DIR . '/dbtech/vbshop/includes/class_core.php');
	require_once(DIR . '/dbtech/vbshop/includes/class_cache.php');
	
	if (is_object($this))
	{
		// Loads the cache class
		VBSHOP_CACHE::init($vbulletin, $this->datastore_entries);
	}
	else
	{
		// Loads the cache class
		VBSHOP_CACHE::init($vbulletin, $specialtemplates);
	}
	
	foreach (VBSHOP::$cache['itemtype'] as $typeid => $type)
	{
		if (!file_exists(DIR . $type['filename']))
		{
			// Probably Pro onry
			VBSHOP::$cache['itemtype'][$typeid]['settings'] = VBSHOP::$cache['itemtype'][$typeid]['active'] = 0;
		}
	}
	
	if (!$vbulletin->bf_ugp_dbtech_vbshoppermissions['isexcluded'])
	{
		// For some reason.
		$vbulletin->bf_ugp_dbtech_vbshoppermissions['isexcluded'] = 16;
	}
	
	// Initialise forumon
	VBSHOP::init($vbulletin);
	
	if (VBSHOP::$permissions['canview'])
	{
		$show['vbshop'] = $vbulletin->options['dbtech_vbshop_navbar'];
		$show['vbshop_ispro'] = VBSHOP::$isPro;
		if ($vbulletin->options['dbtech_vbshop_integration'] & 1)
		{
			$show['vbshop_ql'] = true;
		}
		if ($vbulletin->options['dbtech_vbshop_integration'] & 2)
		{
			$show['vbshop_com'] = true;
		}
	}
	
	foreach ((array)VBSHOP::$cache['currency'] as $currencyid => $currency)
	{
		// Create a quick view for the amount of points we have
		$show['vbshop_' . $currency['pointscolumn']] = $currency['title'] . ': ' . $vbulletin->userinfo[$currency['pointscolumn']];
	}

	// reset musername
	unset($vbulletin->userinfo['musername']);
	fetch_musername($vbulletin->userinfo);	
}
?>