/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// #############################################################################
// Setup the main object
vBShop_Hover_Obj = function()
{
	this.cached = [];
	this.objid = 'dbtech_vbshop_itemhover';
	this.display = false;

	// #########################################################################
	// What happens when we item out of the object
	this.out = function(itemobj, itemid)
	{
		this.hide_profile();
		this.display = false;
	};

	// #########################################################################
	// What happens when we item into the object
	this.hover = function(itemobj, itemid)
	{
		this.display = true;

		if (this.cached[itemid])
		{
			this.display_profile(itemobj, itemid);
			return false;
		};
	};

	// #########################################################################
	// Displays the actual object
	this.display_profile = function(itemobj, itemid)
	{
		if (this.display)
		{
			this.hide_profile();
			
			var offset = 35;
			var itemMatches = new RegExp('^item_(\\d+)$', 'i');
			if (itemid.match(itemMatches))
			{
				offset = 25;
			}

			profile = document.createElement('div');
			profile.id = this.objid;
			profile.style.position = 'absolute';
			profile.style.top = (YAHOO.util.Dom.getY(itemobj) + offset) + 'px';
			profile.style.left = YAHOO.util.Dom.getX(itemobj) + 'px';
			profile.style.zIndex = '3';
			profile.innerHTML = this.cached[itemid];

			document.body.appendChild(profile);

			ph = YAHOO.util.Dom.get(this.objid);
			right = (parseInt(ph.style.left) + ph.offsetWidth);

			if (right >= YAHOO.util.Dom.getViewportWidth())
			{
				YAHOO.util.Dom.get(this.objid).style.left = (YAHOO.util.Dom.getViewportWidth() - ph.offsetWidth) + 'px';
			};
		};
	};

	// #########################################################################
	// Displays the actual object
	this.hide_profile = function()
	{
		if (YAHOO.util.Dom.get(this.objid))
		{
			YAHOO.util.Dom.get(this.objid).parentNode.removeChild(YAHOO.util.Dom.get(this.objid));
		};
	};
};

// #########################################################################
// Init the object
var vBShop_Hover = new vBShop_Hover_Obj();


/*======================================================================*\
|| #################################################################### ||
|| # Created: 23:33, Mon Dec 28th 2009								  # ||
|| # SVN: $Rev$							 							  # ||
|| #################################################################### ||
\*======================================================================*/