<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// Add to the navbits
$navbits['vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=inventory'] = $pagetitle = $vbphrase['dbtech_vbshop_inventory'];

// Verify purchases
VBSHOP::verify_purchases($vbulletin->userinfo);

// #############################################################################
if ($_REQUEST['action'] == 'inventory' OR empty($_REQUEST['action']))
{
	$find = array(
		"\r\n",
		"\n",
		"\t",
		"'"
	);
	
	$replace = array(
		'\r\n',
		'\n',
		'\t',
		"\'",
	);
	
	$phrases = array(
		'sellback' => str_replace($find, $replace, $vbphrase['dbtech_vbshop_are_you_sure_sellback']),
		'discard' => str_replace($find, $replace, $vbphrase['dbtech_vbshop_are_you_sure_discard'])
	);
	$items = '';
	$inventory_q = $db->query_write("
		SELECT
			dbtech_vbshop_purchase.*,
			dbtech_vbshop_shopinventory.*
		FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase AS dbtech_vbshop_purchase
		LEFT JOIN " . TABLE_PREFIX . "dbtech_vbshop_item AS dbtech_vbshop_item ON (dbtech_vbshop_item.itemid = dbtech_vbshop_purchase.featureid)
		LEFT JOIN " . TABLE_PREFIX . "dbtech_vbshop_shopinventory AS dbtech_vbshop_shopinventory ON (
			dbtech_vbshop_shopinventory.itemid = dbtech_vbshop_item.itemid AND
			dbtech_vbshop_shopinventory.shopid = dbtech_vbshop_purchase.shopid
		)
		WHERE dbtech_vbshop_purchase.feature = 'item'
			AND dbtech_vbshop_purchase.userid = " . $db->sql_prepare($vbulletin->userinfo['userid']) . "
		ORDER BY dbtech_vbshop_item.title ASC
	");
	while ($inventory_r = $db->fetch_array($inventory_q))
	{
		if (!is_array(VBSHOP::$cache['item'][$inventory_r['itemid']]))
		{
			// Ignore this
			continue;
		}
		
		// Construct the array proper
		$inventory_r = array_merge(VBSHOP::$cache['item'][$inventory_r['itemid']], $inventory_r);
		
		// Init the item
		$itemobj = VBSHOP::init_item($inventory_r);
		
		$inventory_r['_configure'] 		= (method_exists($itemobj, 'configure') AND $itemobj->can_configure($inventory_r['purchaseid'], $inventory_r));
		$inventory_r['_gift'] 			= $itemobj->can_gift($inventory_r['purchaseid'], $inventory_r);
		$inventory_r['_sellback'] 		= $itemobj->can_sell($inventory_r['purchaseid'], $inventory_r);
		$inventory_r['_extra2']			= ($inventory_r['hidden'] ? ' checked="checked"' : '');
		$inventory_r['_extra']			= '';
		if ($inventory_r['active'])
		{
			// It's active
			$inventory_r['_extra']		.= ' checked="checked"';
			if (!$itemobj->can_deactivate($inventory_r['purchaseid'], $inventory_r))
			{
				// We can't deactivate, though
				$inventory_r['_extra']	.= ' disabled="disabled"';
			}
		}
		else
		{
			// Item is inactive
			if (!$itemobj->can_activate($inventory_r['purchaseid'], $inventory_r))
			{
				// We can't activate, though
				$inventory_r['_extra']	.= ' disabled="disabled"';
			}
		}
		
		$templater = vB_Template::create('dbtech_vbshop_inventory_itembit');
			$templater->register('item', $inventory_r);
			$templater->register('phrases', $phrases);
		$items .= $templater->render();
	}
	
	$page_templater = vB_Template::create('dbtech_vbshop_inventory');
		$page_templater->register('pagetitle', 	$pagetitle);
		$page_templater->register('items', 		$items);
	$HTML = $page_templater->render();
}

// #############################################################################
if ($_REQUEST['action'] == 'configure')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'purchaseid' => TYPE_UINT,
	));
	
	$inventory_r = $db->query_first("
		SELECT
			dbtech_vbshop_purchase.*,
			dbtech_vbshop_shopinventory.*
		FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase AS dbtech_vbshop_purchase
		LEFT JOIN " . TABLE_PREFIX . "dbtech_vbshop_item AS dbtech_vbshop_item ON (dbtech_vbshop_item.itemid = dbtech_vbshop_purchase.featureid)
		LEFT JOIN " . TABLE_PREFIX . "dbtech_vbshop_shopinventory AS dbtech_vbshop_shopinventory ON (
			dbtech_vbshop_shopinventory.itemid = dbtech_vbshop_item.itemid AND
			dbtech_vbshop_shopinventory.shopid = dbtech_vbshop_purchase.shopid
		)
		WHERE dbtech_vbshop_purchase.purchaseid = " . $db->sql_prepare($vbulletin->GPC['purchaseid']) . "
			AND dbtech_vbshop_purchase.userid = " . $db->sql_prepare($vbulletin->userinfo['userid'])
	);
	
	if (!is_array(VBSHOP::$cache['item'][$inventory_r['itemid']]))
	{
		// Ignore this
		eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_invalid_item'])));
	}
	
	// Construct the array proper
	$inventory_r = array_merge(VBSHOP::$cache['item'][$inventory_r['itemid']], $inventory_r);
	
	// Init the item
	$itemobj = VBSHOP::init_item($inventory_r);
	
	// Discard the item
	if (!$itemobj->can_configure($inventory_r['purchaseid'], $inventory_r))
	{
		// Ignore this
		eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_invalid_item'])));		
	}
	
	// Set navbits
	$navbits[''] = $pagetitle = construct_phrase($vbphrase['dbtech_vbshop_configure_x'], $inventory_r['title']);
	
	$page_templater = vB_Template::create('dbtech_vbshop_inventory_configure');
		$page_templater->register('pagetitle', 	$pagetitle);
		$page_templater->register('template', 	$itemobj->render());
		$page_templater->register('item', 		$inventory_r);
	$HTML = $page_templater->render();
}

// #############################################################################
if ($_POST['action'] == 'doconfigure')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'purchaseid' => TYPE_UINT,
	));
	
	$inventory_r = $db->query_first("
		SELECT
			dbtech_vbshop_purchase.*,
			dbtech_vbshop_shopinventory.*
		FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase AS dbtech_vbshop_purchase
		LEFT JOIN " . TABLE_PREFIX . "dbtech_vbshop_item AS dbtech_vbshop_item ON (dbtech_vbshop_item.itemid = dbtech_vbshop_purchase.featureid)
		LEFT JOIN " . TABLE_PREFIX . "dbtech_vbshop_shopinventory AS dbtech_vbshop_shopinventory ON (
			dbtech_vbshop_shopinventory.itemid = dbtech_vbshop_item.itemid AND
			dbtech_vbshop_shopinventory.shopid = dbtech_vbshop_purchase.shopid
		)
		WHERE dbtech_vbshop_purchase.purchaseid = " . $db->sql_prepare($vbulletin->GPC['purchaseid']) . "
			AND dbtech_vbshop_purchase.userid = " . $db->sql_prepare($vbulletin->userinfo['userid'])
	);
	
	if (!is_array(VBSHOP::$cache['item'][$inventory_r['itemid']]))
	{
		// Ignore this
		eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_invalid_item'])));
	}
	
	// Construct the array proper
	$inventory_r = array_merge(VBSHOP::$cache['item'][$inventory_r['itemid']], $inventory_r);
	
	// Init the item
	$itemobj = VBSHOP::init_item($inventory_r);
	
	// Discard the item
	if (!$itemobj->can_configure($inventory_r['purchaseid'], $inventory_r))
	{
		// Ignore this
		eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_invalid_item'])));		
	}
	
	// Do configuration
	$itemobj->configure($inventory_r['purchaseid']);
	
	// Success phrase
	$vbulletin->url = 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=inventory';
	eval(print_standard_redirect('redirect_dbtech_vbshop_updatethanks'));	
}



// #############################################################################
if ($_POST['action'] == 'toggleactive')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'active'  	  	=> TYPE_ARRAY_UINT,
		'hidden'  	  	=> TYPE_ARRAY_UINT,
	));
	
	$inventory_q = $db->query_read_slave("
		SELECT
			dbtech_vbshop_purchase.*,
			dbtech_vbshop_shopinventory.*
		FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase AS dbtech_vbshop_purchase
		LEFT JOIN " . TABLE_PREFIX . "dbtech_vbshop_item AS dbtech_vbshop_item ON (dbtech_vbshop_item.itemid = dbtech_vbshop_purchase.featureid)
		LEFT JOIN " . TABLE_PREFIX . "dbtech_vbshop_shopinventory AS dbtech_vbshop_shopinventory ON (
			dbtech_vbshop_shopinventory.itemid = dbtech_vbshop_item.itemid AND
			dbtech_vbshop_shopinventory.shopid = dbtech_vbshop_purchase.shopid
		)
		WHERE dbtech_vbshop_purchase.feature = 'item'
			AND dbtech_vbshop_purchase.userid = " . $db->sql_prepare($vbulletin->userinfo['userid']) . "
		ORDER BY dbtech_vbshop_item.title ASC
	");
	while ($inventory_r = $db->fetch_array($inventory_q))
	{
		if (!is_array(VBSHOP::$cache['item'][$inventory_r['itemid']]))
		{
			// Ignore this
			continue;
		}
		
		// Construct the array proper
		$inventory_r = array_merge(VBSHOP::$cache['item'][$inventory_r['itemid']], $inventory_r);
		
		// Init the item
		$itemobj = VBSHOP::init_item($inventory_r);
		
		if ($inventory_r['active'])
		{
			// It's active
			if (!$vbulletin->GPC['active'][$inventory_r['purchaseid']])
			{
				// Deactivate the item
				$itemobj->deactivate($inventory_r['purchaseid'], NULL, false);
			}
		}
		else
		{
			// Item is inactive
			if ($vbulletin->GPC['active'][$inventory_r['purchaseid']])
			{
				// Deactivate the item
				$itemobj->activate($inventory_r['purchaseid'], NULL, false);
			}
		}
		
		if ($inventory_r['hidden'] != $vbulletin->GPC['hidden'][$inventory_r['purchaseid']])
		{
			// Update hidden flag
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "dbtech_vbshop_purchase
				SET hidden = '" . intval($vbulletin->GPC['hidden'][$inventory_r['purchaseid']]) . "'
				WHERE purchaseid = " . intval($inventory_r['purchaseid'])
			);
		}
	}
	
	// Once more for good measure
	VBSHOP::build_purchases($vbulletin->userinfo);
	
	// Success phrase
	$vbulletin->url = 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=inventory';
	eval(print_standard_redirect('redirect_dbtech_vbshop_updatethanks'));	
}

// #############################################################################
if ($_REQUEST['action'] == 'sellback')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'purchaseid' => TYPE_UINT,
	));
	
	$inventory_r = $db->query_first("
		SELECT
			dbtech_vbshop_purchase.*,
			dbtech_vbshop_shopinventory.*
		FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase AS dbtech_vbshop_purchase
		LEFT JOIN " . TABLE_PREFIX . "dbtech_vbshop_item AS dbtech_vbshop_item ON (dbtech_vbshop_item.itemid = dbtech_vbshop_purchase.featureid)
		LEFT JOIN " . TABLE_PREFIX . "dbtech_vbshop_shopinventory AS dbtech_vbshop_shopinventory ON (
			dbtech_vbshop_shopinventory.itemid = dbtech_vbshop_item.itemid AND
			dbtech_vbshop_shopinventory.shopid = dbtech_vbshop_purchase.shopid
		)
		WHERE dbtech_vbshop_purchase.purchaseid = " . $db->sql_prepare($vbulletin->GPC['purchaseid']) . "
			AND dbtech_vbshop_purchase.userid = " . $db->sql_prepare($vbulletin->userinfo['userid'])
	);
	
	if (!is_array(VBSHOP::$cache['item'][$inventory_r['itemid']]))
	{
		// Ignore this
		eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_invalid_item'])));
	}
	
	// Construct the array proper
	$inventory_r = array_merge(VBSHOP::$cache['item'][$inventory_r['itemid']], $inventory_r);
	
	// Init the item
	$itemobj = VBSHOP::init_item($inventory_r);
	
	// Discard the item
	$itemobj->sell($inventory_r['purchaseid']);
	
	// Success phrase
	$vbulletin->url = 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=inventory';
	eval(print_standard_redirect('redirect_dbtech_vbshop_updatethanks'));	
}

// #############################################################################
if ($_REQUEST['action'] == 'discard')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'purchaseid' => TYPE_UINT,
	));
	
	$inventory_r = $db->query_first("
		SELECT
			dbtech_vbshop_purchase.*,
			dbtech_vbshop_shopinventory.*
		FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase AS dbtech_vbshop_purchase
		LEFT JOIN " . TABLE_PREFIX . "dbtech_vbshop_item AS dbtech_vbshop_item ON (dbtech_vbshop_item.itemid = dbtech_vbshop_purchase.featureid)
		LEFT JOIN " . TABLE_PREFIX . "dbtech_vbshop_shopinventory AS dbtech_vbshop_shopinventory ON (
			dbtech_vbshop_shopinventory.itemid = dbtech_vbshop_item.itemid AND
			dbtech_vbshop_shopinventory.shopid = dbtech_vbshop_purchase.shopid
		)
		WHERE dbtech_vbshop_purchase.purchaseid = " . $db->sql_prepare($vbulletin->GPC['purchaseid']) . "
			AND dbtech_vbshop_purchase.userid = " . $db->sql_prepare($vbulletin->userinfo['userid'])
	);
	
	if (!is_array(VBSHOP::$cache['item'][$inventory_r['itemid']]))
	{
		// Ignore this
		eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_invalid_item'])));
	}
	
	// Construct the array proper
	$inventory_r = array_merge(VBSHOP::$cache['item'][$inventory_r['itemid']], $inventory_r);
	
	// Init the item
	$itemobj = VBSHOP::init_item($inventory_r);
	
	// Discard the item
	$itemobj->discard($inventory_r['purchaseid']);
	
	// Success phrase
	$vbulletin->url = 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=inventory';
	eval(print_standard_redirect('redirect_dbtech_vbshop_updatethanks'));	
}

// draw cp nav bar
VBSHOP::construct_nav('inventory');

/*======================================================================*\
|| #################################################################### ||
|| # Created: 22:38, Sun Sep 7th 2008								  # ||
|| # SVN: $Rev$									 					  # ||
|| #################################################################### ||
\*======================================================================*/
?>