<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'lotteryprize' OR empty($_REQUEST['action']))
{
	print_cp_header($vbphrase['dbtech_vbshop_lotteryprize_management']);
	
	// Table header
	$headings = array();
	$headings[] = $vbphrase['title'];
	$headings[] = $vbphrase['description'];
	$headings[] = $vbphrase['active'];
	$headings[] = $vbphrase['dbtech_vbshop_prize_numbers'];
	
	// Hook goes here
	
	$headings[] = $vbphrase['edit'];
	$headings[] = $vbphrase['delete'];
	
	
	if (count(VBSHOP::$cache['lotteryprize']))
	{
		print_form_header('vbshop', 'lotteryprize');	
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_vbshop_lotteryprize_management'], count($headings));
		print_description_row($vbphrase['dbtech_vbshop_lotteryprize_management_descr'], false, count($headings));	
		print_cells_row($headings, 0, 'thead');
		
		foreach (VBSHOP::$cache['lotteryprize'] as $lotteryprizeid => $lotteryprize)
		{
			// Table data
			$cell = array();
			$cell[] = $lotteryprize['title'];
			$cell[] = nl2br($lotteryprize['description']);
			$cell[] = ($lotteryprize['active'] ? $vbphrase['yes'] : '<span class="col-i"><strong>' . $vbphrase['no'] . '</strong></span>');
			$cell[] = '<strong>' . $vbphrase['dbtech_vbshop_numbers'] . '</strong>: ' . $lotteryprize['numbers']['main'] . '<br />
						<strong>' . $vbphrase['dbtech_vbshop_bonus_numbers'] . '</strong>: ' . $lotteryprize['numbers']['bonus'];
			
			// Hook goes here
			
			$cell[] = construct_link_code($vbphrase['edit'], 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=lotteryprize&amp;action=modify&amp;lotteryprizeid=' . $lotteryprizeid);
			$cell[] = construct_link_code($vbphrase['delete'], 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=lotteryprize&amp;action=delete&amp;lotteryprizeid=' . $lotteryprizeid);
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
		print_submit_row($vbphrase['dbtech_vbshop_add_new_lotteryprize'], false, count($headings));	
	}
	else
	{
		print_form_header('vbshop', 'lotteryprize');	
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_vbshop_lotteryprize_management'], count($headings));
		print_description_row($vbphrase['dbtech_vbshop_no_lotteryprizes'], false, count($headings));
		print_submit_row($vbphrase['dbtech_vbshop_add_new_lotteryprize'], false, count($headings));	
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$lotteryprizeid = $vbulletin->input->clean_gpc('r', 'lotteryprizeid', TYPE_UINT);
	$lotteryprize = ($lotteryprizeid ? VBSHOP::$cache['lotteryprize']["$lotteryprizeid"] : false);
	
	if (!is_array($lotteryprize))
	{
		// Non-existing lotteryprize
		$lotteryprizeid = 0;
	}
	
	$defaults = array(
		'title' 		=> '7+0',
		'description' 	=> 'Having all 7 main numbers correct.',
		'active' 		=> 1,
		'numbers' 		=> array(
			'main' 	=> 7,
			'bonus' => 0
		),
	);
	
	if ($lotteryprizeid)
	{
		// Edit
		print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_vbshop_editing_x_y'], $vbphrase['dbtech_vbshop_lotteryprize'], $lotteryprize['title'])));
		print_form_header('vbshop', 'lotteryprize');
		construct_hidden_code('action', 'update');
		construct_hidden_code('lotteryprizeid', $lotteryprizeid);
		print_table_header(construct_phrase($vbphrase['dbtech_vbshop_editing_x_y'], $vbphrase['dbtech_vbshop_lotteryprize'], $lotteryprize['title']));
	}
	else
	{
		// Add
		print_cp_header($vbphrase['dbtech_vbshop_add_new_lotteryprize']);
		print_form_header('vbshop', 'lotteryprize');
		construct_hidden_code('action', 'update');
		print_table_header($vbphrase['dbtech_vbshop_add_new_lotteryprize']);
		
		$lotteryprize = $defaults;
	}
	
	print_description_row($vbphrase['dbtech_vbshop_main_settings'], false, 2, 'optiontitle');	
	print_input_row($vbphrase['title'], 							'lotteryprize[title]', 			$lotteryprize['title']);
	print_textarea_row($vbphrase['description'], 					'lotteryprize[description]', 	$lotteryprize['description']);
	print_yes_no_row($vbphrase['active'],							'lotteryprize[active]',			$lotteryprize['active']);
	print_input_row($vbphrase['dbtech_vbshop_prize_main_numbers'], 	'lotteryprize[numbers][main]', 	$lotteryprize['numbers']['main']);
	print_input_row($vbphrase['dbtech_vbshop_prize_bonus_numbers'], 'lotteryprize[numbers][bonus]', $lotteryprize['numbers']['bonus']);
	print_submit_row(($lotteryprizeid ? $vbphrase['save'] : $vbphrase['dbtech_vbshop_add_new_lotteryprize']));	
}

// #############################################################################
if ($_REQUEST['action'] == 'update')
{
	// Grab stuff
	$vbulletin->input->clean_array_gpc('p', array(
		'lotteryprizeid' 	=> TYPE_UINT,
		'lotteryprize' 		=> TYPE_ARRAY,
	));
	
	// init data manager
	$dm =& VBSHOP::datamanager_init('Lotteryprize', $vbulletin, ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($vbulletin->GPC['lotteryprizeid'])
	{
		if (!$existing = VBSHOP::$cache['lotteryprize']["{$vbulletin->GPC[lotteryprizeid]}"])
		{
			// Couldn't find the lotteryprize
			print_stop_message('dbtech_vbshop_invalid_x', $vbphrase['dbtech_vbshop_lotteryprize'], $vbulletin->GPC['lotteryprizeid']);
		}
		
		// Set existing
		$dm->set_existing($existing);
				
		// Added
		$phrase = $vbphrase['dbtech_vbshop_edited'];
	}
	else
	{
		// Added
		$phrase = $vbphrase['dbtech_vbshop_added'];
	}
	
	// lotteryprize fields
	foreach ($vbulletin->GPC['lotteryprize'] AS $key => $val)
	{
		if (!$vbulletin->GPC['lotteryprizeid'] OR $existing["$key"] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}
	
	// Save! Hopefully.
	$dm->save();
		
	define('CP_REDIRECT', 'vbshop.php?do=lotteryprize');
	print_stop_message('dbtech_vbshop_x_y', $vbphrase['dbtech_vbshop_lotteryprize'], $phrase);
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$vbulletin->input->clean_gpc('r', 'lotteryprizeid', TYPE_UINT);
	
	print_cp_header(construct_phrase($vbphrase['dbtech_vbshop_delete_x'], $vbphrase['dbtech_vbshop_lotteryprize']));
	print_delete_confirmation('dbtech_vbshop_lotteryprize', $vbulletin->GPC['lotteryprizeid'], 'vbshop', 'lotteryprize', 'dbtech_vbshop_lotteryprize', array('action' => 'kill'), '', 'title');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$vbulletin->input->clean_gpc('r', 'lotteryprizeid', TYPE_UINT);
	
	if (!$existing = VBSHOP::$cache['lotteryprize']["{$vbulletin->GPC[lotteryprizeid]}"])
	{
		// Couldn't find the lotteryprize
		print_stop_message('dbtech_vbshop_invalid_x', $vbphrase['dbtech_vbshop_lotteryprize'], $vbulletin->GPC['lotteryprizeid']);
	}
	
	// init data manager
	$dm =& VBSHOP::datamanager_init('Lotteryprize', $vbulletin, ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	define('CP_REDIRECT', 'vbshop.php?do=lotteryprize');
	print_stop_message('dbtech_vbshop_x_y', $vbphrase['dbtech_vbshop_lotteryprize'], $vbphrase['dbtech_vbshop_deleted']);	
}

print_cp_footer();

/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: lotteryprize.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>