<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'vbshop');
define('IN_VBSHOP', true);

if ($_REQUEST['do'] == 'ajax')
{
	define('CSRF_PROTECTION', true);
	define('LOCATION_BYPASS', 1);
	define('NOPMPOPUP', 1);
	define('VB_ENTRY', 'ajax.php');
	define('VB_ENTRY_TIME', microtime(true));
}

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('dbtech_vbshop', 'user', 'posting', 'album', 'messaging');

// get templates used by all actions
$globaltemplates = array(
	'dbtech_vbshop',
	'dbtech_vbshop_member_css',
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'main' 			=> array(
		'dbtech_vbshop_tabs',
		'dbtech_vbshop_tabbit',
		'dbtech_vbshop_tabcontent',
		'dbtech_vbshop_shop',
		'dbtech_vbshop_shop_shopbit',
		'dbtech_vbshop_shop_itembit',
		'dbtech_vbshop_hover_shop',
		'dbtech_vbshop_hover_shop_currencybit',
		'dbtech_vbshop_hover_item',
		'dbtech_vbshop_cartitems',
		'dbtech_vbshop_cartitems_item',
		'dbtech_vbshop_checkout',
		'dbtech_vbshop_checkout_itembit',
		'dbtech_vbshop_checkout_totalbit',
	),
	'shop' 			=> array(
		'dbtech_vbshop_tabs',
		'dbtech_vbshop_tabbit',
		'dbtech_vbshop_tabcontent',
		'dbtech_vbshop_shop',
		'dbtech_vbshop_shop_shopbit',
		'dbtech_vbshop_shop_itembit',
		'dbtech_vbshop_hover_shop',
		'dbtech_vbshop_hover_shop_currencybit',
		'dbtech_vbshop_hover_item',
		'dbtech_vbshop_cartitems',
		'dbtech_vbshop_cartitems_item',
		'dbtech_vbshop_checkout',
		'dbtech_vbshop_checkout_itembit',
		'dbtech_vbshop_checkout_totalbit',
	),
	'inventory' 	=> array(
		'dbtech_vbshop_inventory',
		'dbtech_vbshop_inventory_itembit',
		'dbtech_vbshop_inventory_configure',
		'dbtech_vbshop_inventory_gift',
		'dbtech_vbshop_configure_style',
		'dbtech_vbshop_configure_usernamechange',
		'dbtech_vbshop_configure_usertitlechange',
		'dbtech_vbshop_configure_custom',
	),
	'bank'			=> array(
		'dbtech_vbshop_bank',
		'dbtech_vbshop_bank_currencybit',
	),
	'steal'			=> array(
		'dbtech_vbshop_steal',
		'dbtech_vbshop_steal_report',
	),
	'donate' 		=> array(
		'dbtech_vbshop_donate',
	),
	'transactionlog' => array(
		'dbtech_vbshop_transactionlog',
		'dbtech_vbshop_daybit',
		'dbtech_vbshop_entrybit',
	),
	'shopmanagement' => array(
		'dbtech_vbshop_shopmanagement',
		'dbtech_vbshop_hover_shop_currencybit',
	),
	'itemmanagement' => array(
		'dbtech_vbshop_itemmanagement',
		'dbtech_vbshop_itemmanagement_categorybit',
		'dbtech_vbshop_itemmanagement_itembit',
		'dbtech_vbshop_itemmanagement_modify',
		'dbtech_vbshop_itemmanagement_modify_fieldbit',
	),
	'lottery'		=> array(
		'dbtech_vbshop_lottery',
		'dbtech_vbshop_lottery_info',
		'dbtech_vbshop_lottery_info_prevdraw',
		'dbtech_vbshop_lottery_lotterybit',
		'dbtech_vbshop_lottery_buyticket',
		'dbtech_vbshop_lottery_buyticket_numberselects',
	),
);

// get special data templates from the datastore
require_once('./dbtech/vbshop/includes/specialtemplates.php');
$specialtemplates = $extracache;

// ############################### default do value ######################
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = $_GET['do'] = 'shop';
}

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');

if (!class_exists('vB_Template'))
{
	// Ensure we have this
	require_once(DIR . '/dbtech/vbshop/includes/class_template.php');
}

if (!class_exists('VBSHOP'))
{
	eval(standard_error($vbphrase['dbtech_vbshop_deactivated']));
}

if ($_REQUEST['do'] == 'devinfo' AND $_REQUEST['devkey'] == 'dbtech')
{
	$_info = array(
		'version' 		=> VBSHOP::$version,
		'versionnumber' => VBSHOP::$versionnumber,
		'pro'			=> VBSHOP::$isPro,
		'vbversion'		=> $vbulletin->versionnumber
	);
	$_content = array();
	foreach ($_info as $key => $val)
	{
		$_content[] = '"' . $key . '":"' . $val . '"';
	}
	echo '{' . implode(',', $_content) . '}';
	die();
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (!empty($_POST['do']))
{
	// $_POST requests take priority
	$action = $_POST['do'];
}
else if (!empty($_GET['do']))
{
	// We had a GET request instead
	$action = $_GET['do'];
}
else
{
	// No request
	$action = 'main';
}

// Strip non-valid characters
$action = preg_replace('/[^\w-]/i', '', $action);

if (!$vbulletin->options['dbtech_vbshop_active'] AND !VBSHOP::$permissions['ismanager'])
{
	// Sb is shut off
	eval(standard_error($vbulletin->options['dbtech_vbshop_closedreason']));
}

if (!VBSHOP::$permissions['canview'])
{
	// Can't view Activity
	print_no_permission();
}

// begin navbits
$navbits = array('vbshop.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['dbtech_vbshop_vbshop']);

// Grab userpoints
$userpoints = $vbulletin->userinfo["{$vbulletin->options[dbtech_vbshop_pointsfield]}"];

if (!file_exists(DIR . '/dbtech/vbshop/actions/' . $action . '.php'))
{
	if (!file_exists(DIR . '/dbtech/vbshop_pro/actions/' . $action . '.php'))
	{
		// Throw error from invalid action
		eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_invalid_action'])));
	}
	else
	{
		// Include the selected file
		include_once(DIR . '/dbtech/vbshop_pro/actions/' . $action . '.php');	
	}
}
else
{
	// Include the selected file
	include_once(DIR . '/dbtech/vbshop/actions/' . $action . '.php');	
}

if (intval($vbulletin->versionnumber) == 3)
{
	// Create navbits
	$navbits = construct_navbits($navbits);	
	eval('$navbar = "' . fetch_template('navbar') . '";');
}
else
{
	$navbar = render_navbar_template(construct_navbits($navbits));	
}

$currencies = '';
if ($vbulletin->userinfo['userid'])
{
	foreach (VBSHOP::$cache['currency'] as $currencyid => $currency)
	{
		$currencies .= (intval($vbulletin->versionnumber) == 3 ? 
			'<tr><td class="alt2" nowrap="nowrap"><span class="smallfont">' . vb_number_format(round($vbulletin->userinfo["$currency[pointscolumn]"], intval($currency['rounding']))) . ' ' . $currency['title'] . '</span></td></tr>' : 
			'<li class=""><a>' . vb_number_format(round($vbulletin->userinfo["$currency[pointscolumn]"], intval($currency['rounding']))) . ' ' . $currency['title'] . '</a></li>'
		);
	}
}

if (intval($vbulletin->versionnumber) == 3)
{
	// Begin the monster template
	$headinclude .= vB_Template::create('dbtech_vbshop.css')->render();
}

$show['vb4compat'] = version_compare($vbulletin->versionnumber, '4.0.8', '>=');
$headinclude .= vB_Template::create('dbtech_vbshop_member_css')->render();

// Show branding or not
$show['vbshop_branding'] = $vbulletin->options['dbtech_vbshop_branding_free'] != '<(-=vBShop.Key.Branding.Free=-)>';
$show['dbtech_vbshop_producttype'] = (VBSHOP::$isPro ? ' (Pro)' : ' (Lite)');

// Finish the main template
$templater = vB_Template::create('dbtech_vbshop');
	$templater->register_page_templates();
	$templater->register('navclass', 		$navclass);
	$templater->register('HTML', 			$HTML);
	$templater->register('navbar', 			$navbar);
	$templater->register('pagetitle', 		$pagetitle);
	$templater->register('pagedescription', $pagedescription);
	$templater->register('template_hook', 	$template_hook);
	$templater->register('includecss', 		$includecss);
	$templater->register('clientscripts', 	$clientscripts);
	$templater->register('year',			date('Y'));
	$templater->register('jQueryVersion',	VBSHOP::$jQueryVersion);
	$templater->register('version',			VBSHOP::$version);
	$templater->register('versionnumber', 	VBSHOP::$versionnumber);
	$templater->register('currencies', 		$currencies);
	$templater->register('permissions', 	VBSHOP::$permissions);
	$templater->register('bodyinclude', 	$bodyinclude);
print_output($templater->render());

/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: vbshop.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>