<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for items
*
* @package	vbshop
*/
class vBShop_DataManager_Item extends vB_DataManager
{
	/**
	* Array of recognised and required fields for items, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'itemid' 		=> array(TYPE_UINT, 	REQ_INCR, 	VF_METHOD, 	'verify_nonzero'),
		'categoryid' 	=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD, 	'verify_categoryid'),		
		'title' 		=> array(TYPE_STR, 		REQ_YES, 	VF_METHOD),
		'description' 	=> array(TYPE_STR, 		REQ_NO),
		//'active' 		=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
		'icon' 			=> array(TYPE_STR, 		REQ_NO),
		'shopicon' 		=> array(TYPE_STR, 		REQ_NO),
		'displayorder' 	=> array(TYPE_UINT, 	REQ_NO),
		//'price' 		=> array(TYPE_UNUM, 	REQ_NO),
		//'currencyid' 	=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD, 	'verify_currencyid'),
		'permissions' 	=> array(TYPE_NOCLEAN, 	REQ_NO, 	VF_METHOD, 	'verify_serialized'),
		'code' 			=> array(TYPE_NOCLEAN, 	REQ_NO, 	VF_METHOD, 	'verify_serialized'),
		'itemtypeid' 	=> array(TYPE_STR, 		REQ_YES),
		'purchases' 	=> array(TYPE_UINT, 	REQ_NO),
		'giftable' 		=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
		'giftpm' 		=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
		'shop' 			=> array(TYPE_UINT, 	REQ_NO),
		'uniqueitem' 	=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
		'onlygiftable' 	=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
		'duration' 		=> array(TYPE_UINT, 	REQ_NO),
		'ownerid' 		=> array(TYPE_UINT, 	REQ_NO, 	VF_METHOD, 	'verify_userid'),
		'moderation' 	=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
		'reconfigure' 	=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
		'regift' 		=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_vbshop_item';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('itemid = %1$d', 'itemid');

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function vBShop_DataManager_Item(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);

		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_itemdata_start')) ? eval($hook) : false;
	}

	/**
	* Verifies that the title is valid
	*
	* @param	string	Title of the item
	*
	* @return	boolean
	*/
	function verify_title(&$title)
	{
		global $vbphrase;
		
		$title = strval($title);
		if ($title === '')
		{
			// Invalid
			return false;
		}
		
		/*
		// Check for existing item of this name
		if ($existing = $this->registry->db->query_first("
			SELECT `title`
			FROM `" . TABLE_PREFIX . "dbtech_vbshop_item`
			WHERE `title` = " . $this->registry->db->sql_prepare($title) . "
				" . ($this->existing['itemid'] ? "AND `itemid` != " . $this->registry->db->sql_prepare($this->existing['itemid']) : '') . "			
			LIMIT 1
		"))
		{
			// Whoopsie, exists
			$this->error('dbtech_vbshop_x_already_exists_y', $vbphrase['dbtech_vbshop_item'], $title);
			return false;
		}
		*/
		
		return true;
	}

	/**
	* Verifies that the onoff flag is valid
	*
	* @param	string	On/Off flag
	*
	* @return	boolean
	*/
	function verify_onoff(&$onoff)
	{
		// Validate onoff
		$onoff = (!in_array($onoff, array('0', '1')) ? '1' : $onoff);
		
		return true;
	}
	
	/**
	* Verifies that the specified user exists
	*
	* @param	integer	User ID
	*
	* @return 	boolean	Returns true if user exists
	*/
	function verify_userid(&$userid)
	{
		if ($userid == 0)
		{
			// 0 is valid in this case 
			return true;
		}

		return parent::verify_userid($userid);
	}

	/**
	* Verifies that the currencyid is valid
	*
	* @param	integer	currencyid
	*
	* @return	boolean
	*/
	function verify_currencyid(&$currencyid)
	{
		// Validate currencyid
		return is_array(VBSHOP::$cache['currency']["$currencyid"]);
	}

	/**
	* Verifies that the categoryid is valid
	*
	* @param	integer	categoryid
	*
	* @return	boolean
	*/
	function verify_categoryid(&$categoryid)
	{
		// Validate categoryid
		return is_array(VBSHOP::$cache['category']["$categoryid"]);
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}
		
		/*
		if (!$this->condition)
		{
			// Check for existing button of this name
			if ($existing = $this->registry->db->query_first("
				SELECT `bitfield`
				FROM `" . TABLE_PREFIX . "dbtech_vbshop_item`
				ORDER BY `bitfield` DESC
				LIMIT 1
			"))
			{
				// Use existing bitfield
				$bitfield = ($existing['bitfield'] * 2);
			}
			else
			{
				// This is the first one
				$bitfield = 1;
			}
			
			// Set the bitfield
			$this->do_set('bitfield', $bitfield);
		}
		*/

		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_itemdata_presave')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}
	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_itemdata_predelete')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		$SQL = array();
		foreach ((array)VBSHOP::$cache['shop'] as $shopid => $shop)
		{
			if (!((int)$shop['bitfield'] & (int)$this->fetch_field('shop')))
			{
				// Not a part of this shi
				$this->registry->db->query_write("
					DELETE FROM " . TABLE_PREFIX . "dbtech_vbshop_shopinventory
					WHERE shopid = '" . $shopid . "'
						AND itemid = '" . $this->fetch_field('itemid') . "'
				");
				continue;
			}
			
			// Add this now
			$SQL[] = "('" . $shopid . "', '" . $this->fetch_field('itemid') . "')";
		}
		
		if (count($SQL))
		{
			$this->registry->db->query_write("
				INSERT IGNORE INTO " . TABLE_PREFIX . "dbtech_vbshop_shopinventory
					(shopid, itemid)
				VALUES " . implode(',', $SQL)
			);
		}
		
		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_itemdata_postsave')) ? eval($hook) : false;

		// Rebuild the cache
		VBSHOP_CACHE::build_cache('item', 'LEFT JOIN ' . TABLE_PREFIX . 'dbtech_vbshop_category AS category ON (category.categoryid = dbtech_vbshop_item.categoryid)
			ORDER BY category.displayorder, dbtech_vbshop_item.displayorder ASC
		');

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_itemdata_delete')) ? eval($hook) : false;
		
		$userids = array();
		$users_q = $this->dbobject->query_read_slave("
			SELECT userid
			FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase
			WHERE feature = 'item'
				AND featureid = " . $this->existing['itemid'] . "
		");
		while ($users_r = $this->dbobject->fetch_array($users_q))
		{
			// Users affected by this
			$userids[] = $users_r['userid'];
		}
		$userids = array_unique($userids);
		
		if (count($userids))
		{
			$this->dbobject->query_write("
				UPDATE " . TABLE_PREFIX . "user
				SET dbtech_vbshop_purchase = NULL
				WHERE userid IN(" . implode(',', $userids) . ")
			");
		}
		
		$this->dbobject->query_write("
			DELETE FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase
			WHERE featureid = " . $this->existing['itemid'] . "
				AND feature = 'item'
		");
		$this->dbobject->query_write("
			DELETE FROM " . TABLE_PREFIX . "dbtech_vbshop_shopinventory
			WHERE itemid = " . $this->existing['itemid'] . "
		");		

		// Rebuild the cache
		VBSHOP_CACHE::build_cache('item', 'LEFT JOIN ' . TABLE_PREFIX . 'dbtech_vbshop_category AS category ON (category.categoryid = dbtech_vbshop_item.categoryid)
			ORDER BY category.displayorder, dbtech_vbshop_item.displayorder ASC
		');
		
		return true;
	}
}


/*======================================================================*\
|| ####################################################################
|| # Created: 16:52, Sat Dec 26th 2009
|| # SVN: $ $Rev$ $ - $ $Date$ $
|| ####################################################################
\*======================================================================*/