/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// #############################################################################
// Setup the main object
vBShop_Admin_Obj = function()
{
	// Array of data for previews
	this.previews = {};

	// #########################################################################
	// Handles the image preview
	this.image_preview = function(name, url)
	{
		var selectMatches = new RegExp('^sel_' + name + '_(\\d+)$', 'i');
		var selects = fetch_tags(document, 'select');
		
		for (var s = 0; s < selects.length; s++)
		{
			if (selects[s].id.match(selectMatches))
			{
				this.previews[selects[s].id] = 
				{
					'prev'	: name,
					'url'	: url
				};
				
				previmg = document.createElement('img');
				previmg.style.paddingLeft = '10px';
				previmg.style.verticalAlign = 'middle';
				previmg.id = name;
				
				selects[s].onchange = function() { vBShop_Admin.image_change(this); };
				selects[s].parentNode.appendChild(previmg);
				
				this.image_change(selects[s]);

				break;
			};
		};
	};

	// #########################################################################
	// Update the image source
	this.image_change = function(sel)
	{
		if (data = vBShop_Admin.previews[sel.id])
		{
			YAHOO.util.Dom.get(data['prev']).src = data['url'] + sel.options[sel.options.selectedIndex].value;
		};
	};
};

// #########################################################################
// Init the object
var vBShop_Admin = new vBShop_Admin_Obj();