<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// Grab shopping cart
$shoppingcart = ($vbulletin->userinfo['userid'] ? $db->query_first_slave("
	SELECT *
	FROM " . TABLE_PREFIX . "dbtech_vbshop_shoppingcart
	WHERE userid = " . intval($vbulletin->userinfo['userid'])
) : array());

// Ensure this is array
$shoppingcart = (is_array($shoppingcart) ? $shoppingcart : array());

// Fetch list of items
$shoppingcart['items'] = (strlen($shoppingcart['items']) ? @unserialize($shoppingcart['items']) : array());

// #############################################################################
if ($_REQUEST['action'] == 'shop' OR empty($_REQUEST['action']))
{
	// Add to the navbits
	$navbits[''] = $pagetitle = $vbphrase['dbtech_vbshop_shop'];
	
	$vbulletin->input->clean_array_gpc('r', array(
		'shopid'  	  	=> TYPE_UINT,
		'pagenumber'  	=> TYPE_UINT,
		'tab'         	=> TYPE_NOHTML,
		'perpage'     	=> TYPE_UINT,
		'sorttype'    	=> TYPE_STR,
		'sortorder'   	=> TYPE_STR,
		'isajax'   		=> TYPE_BOOL,
	));
	
	// Store item ids
	$itemids = array();
	foreach ((array)$shoppingcart['items'] as $shopid => $items)
	{
		foreach ($items as $itemid => $quantity)
		{
			// Store the itemid
			$itemids[] = $itemid;
		}
	}
	
	// Set this
	$userinfo = $vbulletin->userinfo;
	
	if (count($itemids))
	{
		// Store item info
		$iteminfo = array();
		$iteminfo_q = $db->query_read_slave("
			SELECT *		
			FROM " . TABLE_PREFIX . "dbtech_vbshop_shopinventory
			WHERE itemid IN(" . implode(',', $itemids) . ")
		");
		while ($iteminfo_r = $db->fetch_array($iteminfo_q))
		{
			// Index by shopid and itemid
			$iteminfo["$iteminfo_r[shopid]"]["$iteminfo_r[itemid]"] = $iteminfo_r;
		}
		$db->free_result($iteminfo_q);
		unset($iteminfo_r);
		
		$cartitems = '';
		$totalprices = array();
		foreach ((array)$shoppingcart['items'] as $shopid => $items)
		{
			foreach ($items as $itemid => $quantity)
			{
				if (!$currency = VBSHOP::$cache['currency'][$iteminfo["$shopid"]["$itemid"]['currencyid']])
				{
					// This currency doesn't exist anymore
					continue;
				}
				
				if (!is_array(VBSHOP::$cache['item'][$itemid]))
				{
					// This no longer exists
					continue;
				}
				
				if (!is_array($iteminfo[$shopid][$itemid]))
				{
					// This no longer exists
					continue;
				}

				// Store total prices
				$totalprices["$currency[currencyid]"] += ($iteminfo["$shopid"]["$itemid"]['price'] * $quantity);
				
				 // Ensure this is set
				$iteminfo["$shopid"]["$itemid"]['currency'] = $currency['title'];
				$iteminfo["$shopid"]["$itemid"]['quantity'] = $quantity;
								
				// Decrement our available points
				$userinfo["$currency[pointscolumn]"] -= ($iteminfo["$shopid"]["$itemid"]['price'] * $quantity);
				
				$templater = vB_Template::create('dbtech_vbshop_cartitems_item');
					$templater->register('item', array_merge(VBSHOP::$cache['item']["$itemid"], $iteminfo["$shopid"]["$itemid"]));
					$templater->register('price', ($iteminfo["$shopid"]["$itemid"]['price'] * $quantity));
				$cartitems .= $templater->render();
			}
		}	
	}
	
	// Create the cartitems list
	$templater = vB_Template::create('dbtech_vbshop_cartitems');
		$templater->register('items', $cartitems);
	$cartitems = $templater->render();
	
	if (is_array($totalprices))
	{
		foreach ($totalprices as $currencyid => $totalcost)
		{
			// Update the total cost
			$totalprices["$currencyid"] = $totalcost . ' ' . VBSHOP::$cache['currency']["$currencyid"]['title'];
		}
		
		// Finally set the string
		$totalprice = implode('<br />', $totalprices);
	}
	else
	{
		// Cart was empty
		$totalprice = 'N/A';
	}
	$discount = 0;
	
	// Store list of userids to lookup
	$userids = array(0 => 0);
	foreach ((array)VBSHOP::$cache['shop'] as $shopid => $shop)
	{
		if (!$shop['active'])
		{
			// Inactive shop
			continue;
		}
		
		if (isset($userids[$shop['ownerid']]))
		{
			// Ignore this
			continue;
		}
		$userids[$shop['ownerid']] = $shop['ownerid'];
		
		if (isset($userids[$shop['latestcustomer']]))
		{
			// Ignore this
			continue;
		}
		$userids[$shop['latestcustomer']] = $shop['latestcustomer'];		
	}
	foreach ((array)VBSHOP::$cache['item'] as $itemid => $item)
	{
		if (!$category = VBSHOP::$cache['category'][$item['categoryid']])
		{
			// This category isn't to be displayed
			continue;
		}
		
		if (!$category['active'])
		{
			// This category isn't to be displayed
			continue;
		}
		
		if (!VBSHOP::check_permissions($vbulletin->userinfo, $item['permissions']))
		{
			// This item isn't to be displayed
			continue;
		}
		
		if (!VBSHOP::check_permissions($vbulletin->userinfo, $category['permissions']))
		{
			// This category isn't to be displayed
			continue;
		}
		
		if (isset($userids[$item['ownerid']]))
		{
			// Ignore this
			continue;
		}
		
		if (!$item['ownerid'])
		{
			// Skip this
			continue;
		}
		
		$userids[$item['ownerid']] = $item['ownerid'];
	}
	unset($userids[0]);
	
	if (count($userids) > 0)
	{
		$usernames = $db->query_read("
			SELECT
				userid,
				username,
				usergroupid,
				infractiongroupid,
				displaygroupid,
				dbtech_vbshop_purchase
			FROM " . TABLE_PREFIX . "user
			WHERE userid IN(" . implode(',', $userids) . ")
		");
		while ($username = $db->fetch_array($usernames))
		{
			// Grab the markup username
			fetch_musername($username);
			
			// Store this in the lookup
			$userids[$username['userid']] = $username['musername'];
		}
	}
	
	$shops = '';
	$vbulletin->GPC['shopid'] = (!VBSHOP::check_permissions($vbulletin->userinfo, VBSHOP::$cache['shop']["{$vbulletin->GPC[shopid]}"]['permissions']) ? 0 : $vbulletin->GPC['shopid']);
	foreach ((array)VBSHOP::$cache['shop'] as $shopid => $shop)
	{
		if (!$shop['active'])
		{
			// Inactive shop
			continue;
		}
		
		if (!VBSHOP::check_permissions($vbulletin->userinfo, $shop['permissions']))
		{
			// This isn't to be displayed
			continue;
		}
		
		$shop['sales'] 			= ($shop['sales'] 			? vb_number_format($shop['sales']) 							: 'N/A');
		$shop['latestsale'] 	= ($shop['latestsale'] 		? VBSHOP::$cache['item'][$shop['latestsale']]['title'] 		: 'N/A');
		$shop['latestcustomer'] = ($shop['latestcustomer'] 	? $userids[$shop['latestcustomer']] 						: 'N/A');
		$shop['owner'] 			= ($shop['ownerid'] 		? $userids[$shop['ownerid']] 								: 'N/A');
		$shop['description'] 	= (nl2br($shop['description']));
		
		// Ensure this is set
		$shop['logo'] = ($shop['logo'] ? $shop['logo'] : $vbulletin->options['bburl'] . '/dbtech/vbshop/images/unknown_shop.gif');
		
		// Do shop bits
		$templater = vB_Template::create('dbtech_vbshop_shop_shopbit');
			$templater->register('shop', $shop);
		$shops .= $templater->render();		
		
		// Ensure this is correct for the hover
		$shop['title'] 			= htmlspecialchars_uni($shop['title']);
		
		// Do the currency bits
		$currencybits = '';
		foreach ((array)$shop['salesamounts'] as $currencyid => $amount)
		{
			if (!VBSHOP::$cache['currency'][$currencyid])
			{
				// Ignore this
				continue;
			}
						
			// Do currencybits bits
			$templater = vB_Template::create('dbtech_vbshop_hover_shop_currencybit');
				$templater->register('currency', VBSHOP::$cache['currency'][$currencyid]['title']);
				$templater->register('amount', vb_number_format($amount));
			$currencybits .= $templater->render();
		}
		
		// Cache all the hover objects
		$templater = vB_Template::create('dbtech_vbshop_hover_shop');
			$templater->register('shop', $shop);
			$templater->register('currencybits', $currencybits);
		$tmp = $templater->render();
		if (!preg_match('!\S!u', $tmp))
		{
			// String wasn't utf-8, need to encode it
			$tmp = utf8_encode($tmp);
		}
		$tmp = unhtmlspecialchars($tmp);
		$jsinclude .= "vBShop_Hover.cached['shop_" . $shop['shopid'] . "'] = " . (json_encode($tmp)) . ";\n";
		
		// Select first shop
		$vbulletin->GPC['shopid'] = ($vbulletin->GPC['shopid'] != 0 ? $vbulletin->GPC['shopid'] : $shopid);
	}
	
	$itemids 	= array();
	$itemids2 	= array();
	foreach (VBSHOP::$cache['item'] as $itemid => $item)
	{
		if (!$category = VBSHOP::$cache['category'][$item['categoryid']])
		{
			// This category isn't to be displayed
			continue;
		}
		
		if (!$category['active'])
		{
			// This category isn't to be displayed
			continue;
		}
		
		if (!VBSHOP::check_permissions($vbulletin->userinfo, $item['permissions']))
		{
			// This item isn't to be displayed
			continue;
		}
		
		if (!VBSHOP::check_permissions($vbulletin->userinfo, $category['permissions']))
		{
			// This category isn't to be displayed
			continue;
		}
		
		// Get all possible itemids
		$itemids[] = $itemid;
		
		if (!((int)$item['shop'] & (int)VBSHOP::$cache['shop'][$vbulletin->GPC['shopid']]['bitfield']))
		{
			// Not displaying in this shop
			continue;
		}
		
		// Get all possible itemids
		$itemids2[] = $itemid;
	}

	if (count($itemids2))
	{
		// Ensure there's no errors or out of bounds with the page variables
		if ($vbulletin->GPC['pagenumber'] < 1)
		{
			$vbulletin->GPC['pagenumber'] = 1;
		}
		$pagenumber = $vbulletin->GPC['pagenumber'];
		$perpage = (!$vbulletin->GPC['perpage']) ? 25 : $vbulletin->GPC['perpage'];
		$perpage = $vbulletin->GPC['perpage'] = ($perpage > 250) ? 250 : $perpage;
		$vbulletin->GPC['perpage'] = $perpage;
		$sortorder = $vbulletin->GPC['sortorder'] = (!in_array(strtolower($vbulletin->GPC['sortorder']), array('asc', 'desc')) ? 'asc' : strtolower($vbulletin->GPC['sortorder']));
		
		// Shorthands to faciliate easy copypaste
		$reverseorder = ($sortorder == 'asc' ? 'desc' : 'asc');
		
		switch ($vbulletin->GPC['sorttype'])
		{
			case 'popularity':
				$sorttype = 'popularity';
				$sqlsort = 'item.purchases';
				break;
				
			case 'price':
				$sorttype = 'price';
				$sqlsort = 'shopinventory.price';
				break;
			
			case 'title':
				$sorttype = 'title';
				$sqlsort = 'item.title';
				break;
			
			default:
				$sorttype = 'default';
				$sqlsort = 'item.displayorder';
				break;
		}
		
		// Ensure this is set
		$vbulletin->GPC['sorttype'] = $sorttype;
		
		// Count number of users
		$counter['total'] = count($itemids2);
		
		// Ensure every result is as it should be
		sanitize_pageresults($counter['total'], $pagenumber, $perpage, 250, 25);
		
		// Find out where to start
		$startat = ($pagenumber - 1) * $perpage;
		
		// Constructs the page navigation
		$pagenav = construct_page_nav(
			$pagenumber,
			$perpage,
			$counter['total'],
			'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . "do=shop",
			"&amp;shopid=" . $vbulletin->GPC['shopid'] . "&amp;perpage=$perpage&amp;sortorder=$sortorder&amp;sorttype=$sorttype"
		);
		
		// Fetch users
		$items_q = $db->query_read_slave("
			SELECT item.itemid, item.categoryid, shopinventory.*		
			FROM " . TABLE_PREFIX . "dbtech_vbshop_shopinventory AS shopinventory
			LEFT JOIN " . TABLE_PREFIX . "dbtech_vbshop_item AS item ON(item.itemid = shopinventory.itemid)
			WHERE shopinventory.itemid IN(" . implode(',', $itemids) . ")
			ORDER BY $sqlsort $sortorder
		");
		while ($items_r = $db->fetch_array($items_q))
		{
			// Grab the item
			if (!$item = VBSHOP::$cache['item'][$items_r['itemid']])
			{
				// Dunno why this would happen but meh
				continue;
			}
			
			// Merge the info
			$item = array_merge($item, $items_r);
			
			 // Ensure this is set
			$item['currency'] 		= VBSHOP::$cache['currency'][$item['currencyid']]['title'];
			$item['owner'] 			= ($item['ownerid'] 	? $userids[$item['ownerid']] 	: 'N/A');				
			$item['giftable'] 		= ($item['giftable'] 	? $vbphrase['yes'] 				: $vbphrase['no']);				
			$item['unique'] 		= ($item['uniqueitem'] 	? $vbphrase['yes'] 				: $vbphrase['no']);				
			$item['duration'] 		= ($item['duration'] 	? $item['duration'] 			: $vbphrase['unlimited']);				
			$item['buybacktime'] 	= ($item['buybacktime'] ? $item['buybacktime'] 			: $vbphrase['unlimited']);				
			$item['maxstock'] 		= ($item['stock'] > -1 	? $item['maxstock'] 			: $vbphrase['unlimited']);				
			$item['stock'] 			= ($item['stock'] > -1 	? $item['stock'] 				: $vbphrase['unlimited']);	
			$item['maxstock'] 		= ($item['stock'] 		? $item['maxstock'] 			: 0);						
			$item['description'] 	= nl2br($item['description']);				
					
			$templater = vB_Template::create('dbtech_vbshop_hover_item');
				$templater->register('item', $item);
			$tmp = $templater->render();
			if (!preg_match('!\S!u', $tmp))
			{
				// String wasn't utf-8, need to encode it
				$tmp = utf8_encode($tmp);
			}
			$tmp = unhtmlspecialchars($tmp);
			$jsinclude .= "vBShop_Hover.cached['item_" . $item['itemid'] . "_" . $item['shopid'] . "'] = " . json_encode($tmp) . ";\n";
		}
		
		// Begin the sorting array
		$items_by_category = array();
		
		foreach (VBSHOP::$cache['category'] as $categoryid => $category)
		{
			// Ensure this uses the correct display order
			$items_by_category[$categoryid] = array();
		}
		
		// Fetch users
		$items_q = $db->query_read_slave("
			SELECT item.itemid, item.categoryid, shopinventory.*		
			FROM " . TABLE_PREFIX . "dbtech_vbshop_shopinventory AS shopinventory
			LEFT JOIN " . TABLE_PREFIX . "dbtech_vbshop_item AS item ON(item.itemid = shopinventory.itemid)
			WHERE shopinventory.itemid IN(" . implode(',', $itemids2) . ")
			ORDER BY $sqlsort $sortorder
			LIMIT $startat, " . $perpage
		);
		while ($items_r = $db->fetch_array($items_q))
		{
			// Store the category array
			$items_by_category[$items_r['categoryid']][$items_r['itemid']][$items_r['shopid']] = $items_r;
		}
		
		if (!empty($vbulletin->GPC['tab']) AND isset($items_by_category["{$vbulletin->GPC['tab']}"]))
		{
			$selected_tab = $vbulletin->GPC['tab'];
		}
		else
		{
			$selected_tab = '';
		}
		
		$purchases = array();
		$purchases_q = $db->query_read_slave("
			SELECT *		
			FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase
			WHERE feature = 'item'
				AND userid = " . intval($vbulletin->userinfo['userid']) . "
		");
		while ($purchases_r = $db->fetch_array($purchases_q))
		{
			$purchases["$purchases_r[featureid]"] = true;
		}
		
		// Store item ids
		$itemids = array();
		foreach ((array)$shoppingcart['items'] as $shopid => $items)
		{
			foreach ($items as $itemid => $quantity)
			{
				// Store the itemid
				$purchases["$itemid"] = true;
			}
		}
		
		$firsttab = true;
		$tabbits = '';
		$tabcontent = '';
		foreach ($items_by_category as $categoryid => $itemlist)
		{
			if (!count($itemlist))
			{
				// Don't need this showing up
				continue;
			}
			
			// Shorthand
			$category = VBSHOP::$cache['category']["$categoryid"];
			
			$i = 1;
			$items = '';
			foreach ($itemlist as $itemid => $shopids)
			{
				foreach ($shopids as $shopid => $iteminfo)
				{
					// Grab the item
					if (!$item = VBSHOP::$cache['item']["$itemid"])
					{
						// Dunno why this would happen but meh
						continue;
					}
					
					// Merge these
					$item = array_merge($item, $iteminfo);
					
					// Init this
					$disabled = '';
					
					if (!VBSHOP::check_price($item, $userinfo))
					{
						// Couldn't afford
						$disabled = $vbphrase['dbtech_vbshop_insufficient_funds'];
					}
					
					if ($item['stock'] == 0)
					{
						// Out of stock
						$disabled = $vbphrase['dbtech_vbshop_out_of_stock'];
					}
					
					if ($item['uniqueitem'] AND $purchases["$itemid"])
					{
						// Already bought it
						$disabled = $vbphrase['dbtech_vbshop_already_owned_bought'];
					}
					
					// Ensure this is set
					$item['icon'] 		= ($item['icon'] 		? $item['icon'] 	: 'unknown.gif');
					$item['shopicon'] 	= ($item['shopicon'] 	? $item['shopicon'] : 'unknown_shop.gif');
					
					if ($shopid == $vbulletin->GPC['shopid'])
					{
						// Do item bits only if it's in the currently viewing shop
						$templater = vB_Template::create('dbtech_vbshop_shop_itembit');
							$templater->register('item', 		$item);
							$templater->register('disabled', 	$disabled);
						$items .= $templater->render();
						
						if ($i++ % 5 == 0)
						{
							$items .= '</tr><tr>';
						}
					}				
				}
			}
			
			if (!$items)
			{
				// We don't need this
				continue;
			}
			
			$templater = vB_Template::create('dbtech_vbshop_tabbit');
				$templater->register('firsttab', 		$firsttab);
				$templater->register('selected_tab', 	$selected_tab);			
				$templater->register('category', 		$category);
			$tabbits .= $templater->render();
			
			$templater = vB_Template::create('dbtech_vbshop_tabcontent');
				$templater->register('firsttab', 		$firsttab);
				$templater->register('selected_tab', 	$selected_tab);			
				$templater->register('category', 		$category);
				$templater->register('items', 			$items);
			$tabcontent .= $templater->render();
			$firsttab = false;
		}
		
		// Do shop bits
		$templater = vB_Template::create('dbtech_vbshop_tabs');
			$templater->register('tabbits', 	$tabbits);
			$templater->register('tabcontent', 	$tabcontent);
			$templater->register('pagenav', 	$pagenav);
		$HTML = $templater->render();
		
		if (!count($itemids2))
		{
			// No items in the shop
			$HTML = $vbphrase['dbtech_vbshop_no_items_frontend'];
		}
	}
	else
	{
		$HTML = $vbphrase['dbtech_vbshop_no_items_frontend'];
	}
	
	if ($vbulletin->GPC['isajax'])
	{
		echo vbshop_json_encode(array(
			'shopname' 		=> VBSHOP::$cache['shop']["{$vbulletin->GPC[shopid]}"]['title'],
			'shopcontent' 	=> $HTML,
			'cartitems' 	=> $cartitems,
			//'discount' 		=> $discount,
			'totalprice' 	=> $totalprice,
		));
		die();
	}
	
	/*
	vbphrase['dbtech_vbshop_switching_shop'] = "{vb:rawphrase dbtech_vbshop_switching_shop}";
	vbphrase['dbtech_vbshop_switching_shop_descr'] = "{vb:rawphrase dbtech_vbshop_switching_shop_descr}";
	vbphrase['dbtech_vbshop_sorting_items'] = "{vb:rawphrase dbtech_vbshop_sorting_items}";
	vbphrase['dbtech_vbshop_sorting_items_descr'] = "{vb:rawphrase dbtech_vbshop_sorting_items_descr}";
	vbphrase['dbtech_vbshop_buying_item'] = "{vb:rawphrase dbtech_vbshop_buying_item}";
	vbphrase['dbtech_vbshop_buying_item_descr'] = "{vb:rawphrase dbtech_vbshop_buying_item_descr}";	
	*/
	
	$jsphrases = array(
		'dbtech_vbshop_switching_shop' 			=> $vbphrase['dbtech_vbshop_switching_shop'],
		'dbtech_vbshop_switching_shop_descr' 	=> $vbphrase['dbtech_vbshop_switching_shop_descr'],
		'dbtech_vbshop_sorting_items' 			=> $vbphrase['dbtech_vbshop_sorting_items'],
		'dbtech_vbshop_sorting_items_descr' 	=> $vbphrase['dbtech_vbshop_sorting_items_descr'],
		'dbtech_vbshop_buying_item' 			=> $vbphrase['dbtech_vbshop_buying_item'],
		'dbtech_vbshop_buying_item_descr' 		=> $vbphrase['dbtech_vbshop_buying_item_descr'],
	);
	vbshop_js_escape_string($jsphrases);
	
	$headinclude_bottom .= VBSHOP::js($jsinclude, false, false);
	$clientscripts .= VBSHOP::js("var currentInfo = '" . json_encode(array(
		'shopid'  		=> $vbulletin->GPC['shopid'],
		'pagenumber'  	=> $vbulletin->GPC['pagenumber'],
		'tab'         	=> $vbulletin->GPC['tab'],
		'perpage'     	=> $vbulletin->GPC['perpage'],
		'sorttype'    	=> $vbulletin->GPC['sorttype'],
		'sortorder'   	=> $vbulletin->GPC['sortorder'],
	)) . "';", false, false);
	$page_templater = vB_Template::create('dbtech_vbshop_shop');
		$page_templater->register('cartitems', 		$cartitems);
		$page_templater->register('discount', 		$discount);
		$page_templater->register('totalprice', 	$totalprice);
		$page_templater->register('shop', 			VBSHOP::$cache['shop']["{$vbulletin->GPC[shopid]}"]);
		$page_templater->register('shops', 			$shops);
		$page_templater->register('perpage', 		$vbulletin->GPC['perpage']);
		$page_templater->register('HTML', 			$HTML);
	$HTML = $page_templater->render();
}

// #############################################################################
if ($_POST['action'] == 'addtocart')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'shopid'  	  	=> TYPE_UINT,
		'itemid'  	  	=> TYPE_UINT,
	));
	
	if (!$shop = VBSHOP::$cache['shop']["{$vbulletin->GPC[shopid]}"])
	{
		echo json_encode(array('error' => 'error'));
		die();
	}
	
	if (!$item = VBSHOP::$cache['item']["{$vbulletin->GPC[itemid]}"])
	{
		echo json_encode(array('error' => 'error'));

		die();
	}
	
	if (!VBSHOP::check_permissions($vbulletin->userinfo, $shop['permissions']))
	{
		echo json_encode(array('error' => 'error'));
		die();
	}
	
	if (!VBSHOP::check_permissions($vbulletin->userinfo, $item['permissions']))
	{
		echo json_encode(array('error' => 'error'));
		die();
	}
		
	if (!((int)$item['shop'] & (int)$shop['bitfield']))
	{
		echo json_encode(array('error' => 'error'));
		die();
	}
		
	if (!VBSHOP::check_permissions($vbulletin->userinfo, VBSHOP::$cache['category']["$item[categoryid]"]['permissions']))
	{
		echo json_encode(array('error' => 'error'));
		die();
	}
	
	if ($item['uniqueitem'])
	{
		if ($uniquecheck = $db->query_first("
			SELECT *		
			FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase
			WHERE feature = 'item'
				AND featureid = " . intval($vbulletin->GPC['itemid']) . "
				AND userid = " . intval($vbulletin->userinfo['userid']) . "
		"))
		{
			// This is an unique item
			echo json_encode(array('error' => 'error'));
			die();
		}
	}
	
	// Store item ids
	$itemids = array();
	$itemids[] = $vbulletin->GPC['itemid'];
	foreach ((array)$shoppingcart['items'] as $shopid => $items)
	{
		foreach ($items as $itemid => $quantity)
		{
			if ($itemid == $vbulletin->GPC['itemid'] AND $item['uniqueitem'])
			{
				// This is an unique item
				echo json_encode(array('error' => 'error'));
				die();
			}
			// Store the itemid
			$itemids[] = $itemid;
		}
	}
	
	// Store item info
	$iteminfo = array();
	$iteminfo_q = $db->query_read_slave("
		SELECT *		
		FROM " . TABLE_PREFIX . "dbtech_vbshop_shopinventory
		WHERE itemid IN(" . implode(',', $itemids) . ")
	");
	while ($iteminfo_r = $db->fetch_array($iteminfo_q))
	{
		// Index by shopid and itemid
		$iteminfo["$iteminfo_r[shopid]"]["$iteminfo_r[itemid]"] = $iteminfo_r;
	}
	$db->free_result($iteminfo_q);
	unset($iteminfo_r);
	
	if (!is_array($iteminfo[$vbulletin->GPC['shopid']][$vbulletin->GPC['itemid']]))
	{
		echo json_encode(array('error' => 'error'));
		die();
	}
	
	// Merge these
	$item = array_merge($item, $iteminfo[$vbulletin->GPC['shopid']][$vbulletin->GPC['itemid']]);
	
	$userinfo = $vbulletin->userinfo;
	foreach ((array)$shoppingcart['items'] as $shopid => $items)
	{
		foreach ($items as $itemid => $quantity)
		{
			if (!$currency = VBSHOP::$cache['currency'][$iteminfo["$shopid"]["$itemid"]['currencyid']])
			{
				// This currency doesn't exist anymore
				continue;
			}
							
			// Decrement our available points
			$userinfo["$currency[pointscolumn]"] -= ($iteminfo["$shopid"]["$itemid"]['price'] * $quantity);
		}
	}
		
	if (!VBSHOP::check_price($item, $userinfo) OR $item['stock'] == 0)
	{
		echo json_encode(array('error' => 'error'));
		die();
	}
	
	// Increment the item counter
	$shoppingcart['items'][$vbulletin->GPC['shopid']][$vbulletin->GPC['itemid']]++;
	
	// Update shopping cart
	$db->query_first_slave("
		REPLACE INTO " . TABLE_PREFIX . "dbtech_vbshop_shoppingcart
			(userid, items)
		VALUES (
			" . intval($vbulletin->userinfo['userid']) . ",
			" . $db->sql_prepare(trim(serialize($shoppingcart['items']))) . "
		)
	");
	
	echo json_encode(array('success' => 'success'));
	die();
}

// #############################################################################
if ($_REQUEST['action'] == 'deletefromcart')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'shopid'  	  	=> TYPE_UINT,
		'itemid'  	  	=> TYPE_UINT,
	));
	
	// Remove this item
	unset($shoppingcart['items'][$vbulletin->GPC['shopid']][$vbulletin->GPC['itemid']]);
	
	// Update shopping cart
	$db->query_first_slave("
		REPLACE INTO " . TABLE_PREFIX . "dbtech_vbshop_shoppingcart
			(userid, items)
		VALUES (
			" . intval($vbulletin->userinfo['userid']) . ",
			" . $db->sql_prepare(trim(serialize($shoppingcart['items']))) . "
		)
	");
	
	// Success phrase
	$vbulletin->url = 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=shop&action=checkout';
	eval(print_standard_redirect('redirect_dbtech_vbshop_item_deleted'));	
}

// #############################################################################
if ($_REQUEST['action'] == 'checkout')
{
	// Add to the navbits
	$navbits[''] = $pagetitle = $vbphrase['dbtech_vbshop_checkout'];
	
	// Store item ids
	$itemids = array();
	foreach ((array)$shoppingcart['items'] as $shopid => $items)
	{
		foreach ($items as $itemid => $quantity)
		{
			// Store the itemid
			$itemids[] = $itemid;
		}
	}
	
	$allowsubmit = false;
	if (count($itemids))
	{
		$purchases = array();
		$purchases_q = $db->query_read_slave("
			SELECT *		
			FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase
			WHERE feature = 'item'
				AND userid = " . intval($vbulletin->userinfo['userid']) . "
		");
		while ($purchases_r = $db->fetch_array($purchases_q))
		{
			$purchases["$purchases_r[featureid]"] = true;
		}		
		
		// Store item info
		$iteminfo = array();
		$iteminfo_q = $db->query_read_slave("
			SELECT *		
			FROM " . TABLE_PREFIX . "dbtech_vbshop_shopinventory
			WHERE itemid IN(" . implode(',', $itemids) . ")
		");
		while ($iteminfo_r = $db->fetch_array($iteminfo_q))
		{
			// Index by shopid and itemid
			$iteminfo["$iteminfo_r[shopid]"]["$iteminfo_r[itemid]"] = $iteminfo_r;
		}
		$db->free_result($iteminfo_q);
		unset($iteminfo_r);
		
		$userinfo = $vbulletin->userinfo;
		$cartitems = '';
		$totals = '';
		$totalprices = array();
		$allowsubmit = true;
		foreach ((array)$shoppingcart['items'] as $shopid => $items)
		{
			foreach ($items as $itemid => $quantity)
			{
				if ($purchases["$itemid"] AND VBSHOP::$cache['item']["$itemid"]['uniqueitem'])
				{
					// This item is unique, cannot re-buy
					continue;
				}
				
				if ($quantity > 1 AND VBSHOP::$cache['item']["$itemid"]['uniqueitem'])
				{
					// This item is unique
					$quantity = 1;
				}
				
				if (!$currency = VBSHOP::$cache['currency'][$iteminfo["$shopid"]["$itemid"]['currencyid']])
				{
					// This currency doesn't exist anymore
					continue;
				}
				
				// Store total prices
				$totalprices["$currency[currencyid]"] += ($iteminfo["$shopid"]["$itemid"]['price'] * $quantity);
				
				 // Ensure this is set
				$iteminfo["$shopid"]["$itemid"]['currency'] = $currency['title'];
				$iteminfo["$shopid"]["$itemid"]['quantity'] = $quantity;
				
				if ($iteminfo["$shopid"]["$itemid"]['stock'] > -1 AND $iteminfo["$shopid"]["$itemid"]['stock'] < $quantity)
				{
					// Not enough of these items
					continue;
				}				
								
				// Decrement our available points
				$userinfo["$currency[pointscolumn]"] -= ($iteminfo["$shopid"]["$itemid"]['price'] * $quantity);
				
				if ($userinfo["$currency[pointscolumn]"] < 0)
				{
					// We can't afford this
					$allowsubmit = false;
				}
				
				$templater = vB_Template::create('dbtech_vbshop_checkout_itembit');
					$templater->register('item', array_merge(VBSHOP::$cache['item']["$itemid"], $iteminfo["$shopid"]["$itemid"]));
					$templater->register('price', ($iteminfo["$shopid"]["$itemid"]['price'] * $quantity));
				$cartitems .= $templater->render();
			}
		}
		
		foreach ($totalprices as $currencyid => $price)
		{
			$templater = vB_Template::create('dbtech_vbshop_checkout_totalbit');
				$templater->register('currency', VBSHOP::$cache['currency'][$currencyid]['title']);
				$templater->register('price', $price);
			$totals .= $templater->render();
		}
	}
	
	$page_templater = vB_Template::create('dbtech_vbshop_checkout');
		$page_templater->register('cartitems', 		$cartitems);
		$page_templater->register('totals', 		$totals);
		$page_templater->register('allowsubmit', 	$allowsubmit);
	$HTML = $page_templater->render();	
}

// #############################################################################
if ($_POST['action'] == 'confirmcheckout')
{
	// Store item ids
	$itemids = array();
	foreach ((array)$shoppingcart['items'] as $shopid => $items)
	{
		foreach ($items as $itemid => $quantity)
		{
			// Store the itemid
			$itemids[] = $itemid;
		}
	}
	
	$allowsubmit = false;
	if (count($itemids))
	{
		// Store item info
		$iteminfo = array();
		$iteminfo_q = $db->query_read_slave("
			SELECT *		
			FROM " . TABLE_PREFIX . "dbtech_vbshop_shopinventory
			WHERE itemid IN(" . implode(',', $itemids) . ")
		");
		while ($iteminfo_r = $db->fetch_array($iteminfo_q))
		{
			// Index by shopid and itemid
			$iteminfo["$iteminfo_r[shopid]"]["$iteminfo_r[itemid]"] = $iteminfo_r;
		}
		$db->free_result($iteminfo_q);
		unset($iteminfo_r);
		
		$userinfo = $vbulletin->userinfo;
		$cartitems = '';
		$totals = '';
		$totalprices = array();
		$allowsubmit = true;
		
		foreach ((array)$shoppingcart['items'] as $shopid => $items)
		{
			foreach ($items as $itemid => $quantity)
			{
				if (!is_array(VBSHOP::$cache['item'][$itemid]))
				{
					// This no longer exists
					continue;
				}
				
				if (!is_array($iteminfo[$shopid][$itemid]))
				{
					// This no longer exists
					continue;
				}
				
				// Grab the full item info
				$item = array_merge(VBSHOP::$cache['item'][$itemid], $iteminfo[$shopid][$itemid]);
				
				 // Ensure this is set
				$item['quantity'] = $quantity;
								
				// Init the item
				$itemobj = VBSHOP::init_item($item);
				
				if (!$itemobj->purchase($vbulletin->userinfo))
				{
					// Purchase failed
					continue;
				}
			}
		}
	}
	
	// Update shopping cart
	$db->query_first_slave("
		REPLACE INTO " . TABLE_PREFIX . "dbtech_vbshop_shoppingcart
			(userid, items)
		VALUES (
			" . intval($vbulletin->userinfo['userid']) . ",
			" . $db->sql_prepare(trim(serialize(array()))) . "
		)
	");
	
	// Success phrase
	$vbulletin->url = 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=inventory';
	eval(print_standard_redirect('redirect_dbtech_vbshop_purchasethanks'));	
}

// draw cp nav bar
VBSHOP::construct_nav('shop');

/*======================================================================*\
|| #################################################################### ||
|| # Created: 22:38, Sun Sep 7th 2008								  # ||
|| # SVN: $Rev$									 					  # ||
|| #################################################################### ||
\*======================================================================*/
?>