<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

@set_time_limit(0);
ignore_user_abort(1);

print_cp_header($vbphrase['dbtech_vbshop_maintenance']);

$vbulletin->input->clean_array_gpc('r', array(
	'perpage' => TYPE_UINT,
	'startat' => TYPE_UINT,
	'version' => TYPE_UINT
));

if (empty($vbulletin->GPC['perpage']))
{
	$vbulletin->GPC['perpage'] = 250;
}

echo '<p>Finalising Install...</p>';

if ($vbulletin->GPC['version'] == 111)
{
	$users = $db->query_read_slave("
		SELECT DISTINCT purchase.userid
		FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase AS purchase
		WHERE purchase.userid >= " . $vbulletin->GPC['startat'] . "
		LIMIT " . $vbulletin->GPC['perpage']
	);
	
	$finishat = $vbulletin->GPC['startat'];
	
	while ($user = $db->fetch_array($users))
	{
		$userinfo = array('userid' => $user['userid']);
		VBSHOP::build_purchases($userinfo);
		
		echo construct_phrase($vbphrase['processing_x'], $user['userid']) . "<br />\n";
		vbflush();
	
		$finishat = ($user['userid'] > $finishat ? $user['userid'] : $finishat);
	}
	$finishat++;
	
	if ($checkmore = $db->query_first_slave("SELECT purchaseid FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase WHERE userid >= $finishat LIMIT 1"))
	{
		print_cp_redirect("vbshop.php?" . $vbulletin->session->vars['sessionurl'] . "do=finalise&version=" . $vbulletin->GPC['version'] . "&startat=$finishat&pp=" . $vbulletin->GPC['perpage']);
		echo "<p><a href=\"vbshop.php?" . $vbulletin->session->vars['sessionurl'] . "do=finalise&amp;version=" . $vbulletin->GPC['version'] . "&amp;startat=$finishat&amp;pp=" . $vbulletin->GPC['perpage'] . "\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";
	}
	else
	{
		print_cp_message('Repairing cache...', 'index.php?loc=' . urlencode('vbshop.php?do=repaircache'), 1, NULL, false);
	}	
}

if ($vbulletin->GPC['version'] == 200)
{
	$users = $db->query_read_slave("
		SELECT purchase.*
		FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase AS purchase
		WHERE purchase.purchaseid >= " . $vbulletin->GPC['startat'] . "
		ORDER BY purchase.purchaseid
		LIMIT " . $vbulletin->GPC['perpage']
	);
	
	$finishat = $vbulletin->GPC['startat'];
	
	while ($user = $db->fetch_array($users))
	{
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "dbtech_vbshop_transactionlog
				(userid, recipient, dateline, action, info)
			VALUES (
				'$user[buyer]',
				'$user[userid]',
				'$user[dateline]',
				'purchase',
				" . $db->sql_prepare(serialize(array('feature' => $user['feature'], 'featureid' => $user['featureid']))) . "
			)
		");	
		
		echo construct_phrase($vbphrase['processing_x'], $user['purchaseid']) . "<br />\n";
		vbflush();
	
		$finishat = ($user['purchaseid'] > $finishat ? $user['purchaseid'] : $finishat);
	}
	$finishat++;
	
	if ($checkmore = $db->query_first_slave("SELECT purchaseid FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase WHERE purchaseid >= $finishat LIMIT 1"))
	{
		print_cp_redirect("vbshop.php?" . $vbulletin->session->vars['sessionurl'] . "do=finalise&version=" . $vbulletin->GPC['version'] . "&startat=$finishat&pp=" . $vbulletin->GPC['perpage']);
		echo "<p><a href=\"vbshop.php?" . $vbulletin->session->vars['sessionurl'] . "do=finalise&amp;version=" . $vbulletin->GPC['version'] . "&amp;startat=$finishat&amp;pp=" . $vbulletin->GPC['perpage'] . "\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";
	}
	else
	{
		print_cp_message('Repairing cache...', 'index.php?loc=' . urlencode('vbshop.php?do=repaircache'), 1, NULL, false);
	}	
}

print_cp_footer();


/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: vbshout.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>