<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'category' OR empty($_REQUEST['action']))
{
	print_cp_header($vbphrase['dbtech_vbshop_category_management']);
	
	// Table header
	$headings = array();
	$headings[] = $vbphrase['dbtech_vbshop_category_name'];
	$headings[] = $vbphrase['description'];
	$headings[] = $vbphrase['active'];
	$headings[] = $vbphrase['display_order'];
	
	// Hook goes here
	
	$headings[] = $vbphrase['edit'];
	$headings[] = $vbphrase['delete'];
	
	
	if (count(VBSHOP::$cache['category']))
	{
		print_form_header('vbshop', 'category');	
		construct_hidden_code('action', 'displayorder');
		print_table_header($vbphrase['dbtech_vbshop_category_management'], count($headings));
		print_description_row($vbphrase['dbtech_vbshop_category_management_descr'], false, count($headings));	
		print_cells_row($headings, 0, 'thead');
		
		foreach (VBSHOP::$cache['category'] as $categoryid => $category)
		{
			// Table data
			$cell = array();
			$cell[] = $category['title'];
			$cell[] = nl2br($category['description']);
			$cell[] = ($category['active'] ? $vbphrase['yes'] : '<span class="col-i"><strong>' . $vbphrase['no'] . '</strong></span>');
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$categoryid]\" value=\"$category[displayorder]\" tabindex=\"1\" size=\"3\" title=\"" . $vbphrase['edit_display_order'] . "\" />";
			
			// Hook goes here
			
			$cell[] = construct_link_code($vbphrase['edit'], 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=category&amp;action=modify&amp;categoryid=' . $categoryid);
			$cell[] = construct_link_code($vbphrase['delete'], 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=category&amp;action=delete&amp;categoryid=' . $categoryid);
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
		print_submit_row($vbphrase['save_display_order'], false, count($headings), false, "<input type=\"button\" id=\"addnew\" class=\"button\" value=\"" . str_pad($vbphrase['dbtech_vbshop_add_new_category'], 8, ' ', STR_PAD_BOTH) . "\" tabindex=\"1\" onclick=\"window.location = 'vbshop.php?do=category&amp;action=modify'\" />");	
	}
	else
	{
		print_form_header('vbshop', 'category');	
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_vbshop_category_management'], count($headings));
		print_description_row($vbphrase['dbtech_vbshop_no_categories'], false, count($headings));
		print_submit_row($vbphrase['dbtech_vbshop_add_new_category'], false, count($headings));	
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$categoryid = $vbulletin->input->clean_gpc('r', 'categoryid', TYPE_UINT);
	$category = ($categoryid ? VBSHOP::$cache['category']["$categoryid"] : false);
	
	if (!is_array($category))
	{
		// Non-existing category
		$categoryid = 0;
	}
	
	$defaults = array(
		'title' 		=> 'Category',
		'description' 	=> 'A category that holds a number of purchasable items.',
		'active' 		=> 1,
		'displayorder'	=> 10,
	);
	
	$headings = array(
		$vbphrase['usergroup'],
		$vbphrase['dbtech_vbshop_can_access_category']
	);
	
	if ($categoryid)
	{
		// Edit
		print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_vbshop_editing_x_y'], $vbphrase['dbtech_vbshop_category'], $category['title'])));
		print_form_header('vbshop', 'category');
		construct_hidden_code('action', 'update');
		construct_hidden_code('categoryid', $categoryid);
		print_table_header(construct_phrase($vbphrase['dbtech_vbshop_editing_x_y'], $vbphrase['dbtech_vbshop_category'], $category['title']));
	}
	else
	{
		// Add
		print_cp_header($vbphrase['dbtech_vbshop_add_new_category']);
		print_form_header('vbshop', 'category');
		construct_hidden_code('action', 'update');
		print_table_header($vbphrase['dbtech_vbshop_add_new_category']);
		
		$category = $defaults;
	}
	
	print_description_row($vbphrase['dbtech_vbshop_main_settings'], false, 2, 'optiontitle');	
	print_input_row($vbphrase['title'], 			'category[title]', 			$category['title']);
	print_textarea_row($vbphrase['description'], 	'category[description]', 	$category['description']);
	print_yes_no_row($vbphrase['active'],			'category[active]',			$category['active']);
	print_input_row($vbphrase['display_order'], 	'category[displayorder]', 	$category['displayorder']);
	if (VBSHOP::$isPro)
	{	
		print_description_row($vbphrase['dbtech_vbshop_category_settings'], false, 2, 'optiontitle');
		print_yes_no_row($vbphrase['dbtech_vbshop_category_customshops'], 'category[customshops]', $category['customshops']);		
	}
	print_description_row($vbphrase['permissions'], false, 2, 'optiontitle');
	print_cells_row($headings, 0, 'thead');	
	foreach ($vbulletin->usergroupcache as $usergroupid => $usergroup)
	{
		print_yes_no_other_row($usergroup['title'], 'category[permissions][' . $usergroupid . ']', $vbphrase['default'], (isset($category['permissions']["$usergroupid"]) ? $category['permissions']["$usergroupid"] : -1));
	}
	print_submit_row(($categoryid ? $vbphrase['save'] : $vbphrase['dbtech_vbshop_add_new_category']));	
}

// #############################################################################
if ($_REQUEST['action'] == 'update')
{
	// Grab stuff
	$vbulletin->input->clean_array_gpc('p', array(
		'categoryid' 	=> TYPE_UINT,
		'category' 		=> TYPE_ARRAY,
	));
	
	// init data manager
	$dm =& VBSHOP::datamanager_init('Category', $vbulletin, ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($vbulletin->GPC['categoryid'])
	{
		if (!$existing = VBSHOP::$cache['category']["{$vbulletin->GPC[categoryid]}"])
		{
			// Couldn't find the category
			print_stop_message('dbtech_vbshop_invalid_x', $vbphrase['dbtech_vbshop_category'], $vbulletin->GPC['categoryid']);
		}
		
		// Set existing
		$dm->set_existing($existing);
				
		// Added
		$phrase = $vbphrase['dbtech_vbshop_edited'];
	}
	else
	{
		// Added
		$phrase = $vbphrase['dbtech_vbshop_added'];
	}
	
	// category fields
	foreach ($vbulletin->GPC['category'] AS $key => $val)
	{
		if (!$vbulletin->GPC['categoryid'] OR $existing["$key"] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}
	
	// Save! Hopefully.
	$dm->save();
		
	define('CP_REDIRECT', 'vbshop.php?do=category');
	print_stop_message('dbtech_vbshop_x_y', $vbphrase['dbtech_vbshop_category'], $phrase);
}

// #############################################################################
if ($_POST['action'] == 'displayorder')
{
	$vbulletin->input->clean_array_gpc('p', array('order' => TYPE_ARRAY));
	
	if (is_array($vbulletin->GPC['order']))
	{
		foreach ($vbulletin->GPC['order'] as $categoryid => $displayorder)
		{
			if (!$existing = VBSHOP::$cache['category']["$categoryid"])
			{
				// Couldn't find the category
				continue;
			}
			
			if ($existing['displayorder'] == $displayorder)
			{
				// No change
				continue;
			}
			
			// init data manager
			$dm =& VBSHOP::datamanager_init('Category', $vbulletin, ERRTYPE_CP);
				$dm->set_existing($existing);
				$dm->set('displayorder', $displayorder);
			$dm->save();
			unset($dm);	
		}
	}
	
	define('CP_REDIRECT', 'vbshop.php?do=category');
	print_stop_message('saved_display_order_successfully');	
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$vbulletin->input->clean_gpc('r', 'categoryid', TYPE_UINT);
	
	print_cp_header(construct_phrase($vbphrase['dbtech_vbshop_delete_x'], $vbphrase['dbtech_vbshop_category']));
	print_delete_confirmation('dbtech_vbshop_category', $vbulletin->GPC['categoryid'], 'vbshop', 'category', 'dbtech_vbshop_category', array('action' => 'kill'), '', 'title');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$vbulletin->input->clean_gpc('r', 'categoryid', TYPE_UINT);
	
	if (!$existing = VBSHOP::$cache['category']["{$vbulletin->GPC[categoryid]}"])
	{
		// Couldn't find the category
		print_stop_message('dbtech_vbshop_invalid_x', $vbphrase['dbtech_vbshop_category'], $vbulletin->GPC['categoryid']);
	}
	
	// init data manager
	$dm =& VBSHOP::datamanager_init('Category', $vbulletin, ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	define('CP_REDIRECT', 'vbshop.php?do=category');
	print_stop_message('dbtech_vbshop_x_y', $vbphrase['dbtech_vbshop_category'], $vbphrase['dbtech_vbshop_deleted']);	
}

print_cp_footer();

/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: category.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>