<?php
if (!class_exists('vBShop_Item_Core'))
{
	die('No direct access allowed.');
}

class vBShop_Item_usernamestyle extends vBShop_Item_Core
{
	/**
	* The constructor
	*
	* @param	vBulletin	vBulletin registry
	* @param	array		Item info
	*/	
	public function __construct(&$registry, &$item)
	{
		parent::__construct($registry, $item);
		
		// Set purchase template
		$this->config['purchasetemplate'] = 'dbtech_vbshop_configure_style';
		
		// HTML safe
		$this->config['configuration']['color'] = htmlspecialchars_uni($this->config['configuration']['color']);
		$this->config['configuration']['glow'] = htmlspecialchars_uni($this->config['configuration']['glow']);
		$this->config['configuration']['shadow'] = htmlspecialchars_uni($this->config['configuration']['shadow']);
	}
	
	/**
	* Function to call before every action
	*/	
	public function action()
	{
		if (!parent::action())
		{
			// This type is inactive
			return false;
		}
		
		// We made it!
		return true;
	}
	
	/**
	* Prints out an AdminCP form
	*/	
	public function print_admin_form($code)
	{
		global $vbphrase;
		
		$val = 0;
		foreach ((array)$code['value'] as $value)
		{
			// Increment value
			$val += $value;
		}		
		
		// Finally print the select
		require_once(DIR . '/dbtech/vbshop/includes/functions.php');		
		print_bitfield_row($vbphrase['dbtech_vbshop_usernamestyle'], 'item[code][value]', 'nocache|dbtech_vbshop_style', $val);
	}
	
	/**
	* Configure an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Recipient
	*/	
	public function configure($purchaseid, $recipient = null)
	{
		global $vbphrase;
		
		if (!$this->can_configure($purchaseid))
		{
			// Can't configure this item
			return false;
		}
		
		// Ensure this is set
		$recipient = (!$recipient ? $this->registry->userinfo : $recipient);
		
		// Get the form code
		$code 			= $this->registry->input->clean_gpc('p', 'code', 			TYPE_ARRAY);
		$noConfigure 	= $this->registry->input->clean_gpc('p', '_noConfigure', 	TYPE_BOOL);
		
		if ($noConfigure)
		{
			// We're done, we wanted to let the recipient configure it themselves
			return true;
		}
		
		$values = array();
		foreach ($code as $style => $value)
		{
			$output = $value;
			if (is_numeric($value))
			{
				if ($value == 0)
				{
					$output = $vbphrase['no'];
				}
				else if ($value == 1)
				{
					$output = $vbphrase['yes'];
				}				
			}
			else if (!$value)
			{
				$output = 'N/A';
			}
			
			// Set the values
			$values[] = $vbphrase['dbtech_vbshop_' . $style] . ': ' . $output;
		}
		
		if ($this->config['notifications_config'])
		{
			$userids = explode(',', $this->config['notifications_config']);
			foreach ((array)$userids as $userid)
			{
				$pmrecipient = array('userid' => $userid);
				$this->send_pm(
					$recipient,
					$pmrecipient,
					construct_phrase($vbphrase['dbtech_vbshop_new_configuration_x'],
						$this->config['title']
					),
					construct_phrase($vbphrase['dbtech_vbshop_x_just_configured_y'],
						$recipient['username'],
						$this->config['title'],
						implode("\n", $values)
					)
				);
			}
		}	
		
		// Update flag
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . "dbtech_vbshop_purchase
			SET configuration = " . $this->registry->db->sql_prepare(trim(serialize($code))) . "
			WHERE purchaseid = " . intval($purchaseid) . "
		");
		
		// Build purchase cache
		VBSHOP::build_purchases($recipient);
	}
	
	/**
	* Deactivate an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Recipient
	*/	
	public function deactivate($purchaseid, $recipient = null)
	{
		if (!parent::deactivate($purchaseid, $recipient))
		{
			// Couldn't deactivate
			return false;
		}
		
		/*
		// Set username style
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . "user
			SET dbtech_vbshop_usernamestyle = " . $this->registry->db->sql_prepare(trim(serialize(array()))) . "
			WHERE userid = " . intval($recipient['userid'])
		);
		*/
		
		return true;
	}	
	
	/**
	* Actions that override the musername / usertitle
	*
	* @param	array		User info
	* @param	integer		Display group id
	*/	
	public function fetch_musername(&$user, $displaygroupid)
	{
		if (!$this->config['active'])
		{
			// We're not doin this
			return false;
		}
		
		// By default, no open tag
		$this->config['code']['opentag'] = '';
		
		if ($this->config['configuration']['bold'])
		{
			// Bolded username
			$this->config['code']['opentag'] .= 'font-weight:bold; ';
		}
		
		if ($this->config['configuration']['italic'])
		{
			// Bolded username
			$this->config['code']['opentag'] .= 'font-style:italic; ';
		}
		
		if ($this->config['configuration']['underline'])
		{
			// Bolded username
			$this->config['code']['opentag'] .= 'text-decoration:underline; ';
		}
		
		if ($this->config['configuration']['color'])
		{
			// Bolded username
			$this->config['code']['opentag'] .= 'color:' . $this->config['configuration']['color'] . '; ';
		}
		
		if ($this->config['configuration']['glow_onoff'])
		{
			$this->config['code']['opentag'] .= 'text-shadow: 0px 0px 0.2em ' . $this->config['configuration']['glow'] . ', 0px 0px 0.2em ' . $this->config['configuration']['glow'] . ', 0px 0px 0.2em ' . $this->config['configuration']['glow'] . '; ';
			//  filter:progid:DXImageTransform.Microsoft.Glow(Color=#FF0000, Strength=5); _height:1px; 
		}
		
		if ($this->config['configuration']['shadow_onoff'])
		{
			$this->config['code']['opentag'] .= 'text-shadow:2px 2px 4px ' . $this->config['configuration']['shadow'] . '; ';
		}
		
		if ($this->config['code']['opentag'])
		{
			// Close the tag
			$this->config['code']['opentag'] = '<span style="' . $this->config['code']['opentag'] . '">';
			$this->config['code']['closetag'] = '</span>';
		}
		
		if (!empty($this->config['code']['opentag']))
		{
			// We've got musername 
			$user['musername'] = $this->registry->usergroupcache["$displaygroupid"]['opentag'] . $this->config['code']['opentag'] . str_replace(array(
					$this->registry->usergroupcache["$displaygroupid"]['opentag'],
					$this->registry->usergroupcache["$displaygroupid"]['closetag']
				),
				'',
				$user['musername']) . $this->config['code']['closetag'] . $this->registry->usergroupcache["$displaygroupid"]['closetag'];			
		}
	}	
}
?>