<?php
if (!class_exists('vBShop_Item_Core'))
{
	die('No direct access allowed.');
}

class vBShop_Item_usernamechange extends vBShop_Item_Core
{
	/**
	* The constructor
	*
	* @param	vBulletin	vBulletin registry
	* @param	array		Item info
	*/	
	public function __construct(&$registry, &$item)
	{
		$item['_nodeactivate'] = true;		
		parent::__construct($registry, $item);
		
		// Set purchase template
		$this->config['purchasetemplate'] = 'dbtech_vbshop_configure_usernamechange';
	}
	
	/**
	* Function to call before every action
	*/	
	public function action()
	{
		if (!parent::action())
		{
			// This type is inactive
			return false;
		}
		
		// We made it!
		return true;
	}
	
	/**
	* Gifting an item
	*
	* @param	integer		Purchase ID
	* @param	array		Buyer info
	* @param	array		Recipient info
	* @param	string		The message from the buyer
	*/	
	public function gift($purchaseid, &$buyer, &$recipient, $message = '')
	{
		global $vbphrase;
		
		$noConfigure 	= $this->registry->input->clean_gpc('p', '_noConfigure', 	TYPE_BOOL);
		
		if (!$noConfigure)
		{
			// We're done, we wanted to let the recipient configure it themselves
			$noalter = explode(',', $this->registry->config['SpecialUsers']['undeletableusers']);
			if (!is_array($noalter))
			{
				$noalter = array();
			}
	
			if ($buyer['userid'] != $recipient['userid'] AND in_array($recipient['userid'], $noalter))
			{
				// Woups, immune
				eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_recipient_immune'])));
			}
			
			// Ensure we have the necessary files
			require_once(DIR . '/includes/adminfunctions.php');
			require_once(DIR . '/includes/adminfunctions_options.php');
			
			$bitfielddefs =& fetch_bitfield_definitions('nocache|dbtech_vbshop_immunity');
			foreach ($bitfielddefs AS $key => $val)
			{
				if ($key == 'dbtech_vbshop_' . $this->config['itemtypeid'] AND $recipient['userid'] != $buyer['userid'] AND ((int)$recipient['dbtech_vbshop_immunity'] & (int)$val))
				{
					// Woups, immune
					eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_recipient_immune'])));
				}
			}
		}
		
		// Do parent checking
		parent::gift($purchaseid, $buyer, $recipient, $message);
	}

	/**
	* Configure an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Recipient
	*/	
	public function configure($purchaseid, $recipient = null)
	{
		global $vbphrase;
		
		if (!$this->can_configure($purchaseid))
		{
			// Can't configure this item
			return false;
		}
		
		// Ensure this is set
		$recipient = (!$recipient ? $this->registry->userinfo : $recipient);
				
		// Get the form code
		$code 			= $this->registry->input->clean_gpc('p', 'code', 			TYPE_ARRAY);
		$noConfigure 	= $this->registry->input->clean_gpc('p', '_noConfigure', 	TYPE_BOOL);
		
		if ($noConfigure)
		{
			// We're done, we wanted to let the recipient configure it themselves
			return true;
		}
		
		// Change the username
		$userdata =& datamanager_init('User', $this->registry, ERRTYPE_STANDARD);
			$userdata->set_existing($recipient);
			$userdata->set('username', $code['username']);
		$userdata->save();
		
		if ($this->registry->userinfo['userid'] != $recipient['userid'] AND $this->registry->options['dbtech_vbshop_enableemail_usernamechange'])
		{
			vbmail($recipient['email'],
				construct_phrase($vbphrase['dbtech_vbshop_usernamechange_email_title'], $this->registry->options['bbtitle']),
        		construct_phrase($vbphrase['dbtech_vbshop_usernamechange_email_body'], $this->registry->userinfo['username'], $recipient['username'], $code['username']),
				true, $this->registry->options['bbtitle']);
		}
		
		// Ensure we PM the new user
		$recipient['username'] = $code['username'];
		
		$values = array();
		$values[] = $vbphrase['username'] . ': ' . $code['username'];
		if ($this->config['notifications_config'])
		{
			$userids = explode(',', $this->config['notifications_config']);
			foreach ((array)$userids as $userid)
			{
				$pmrecipient = array('userid' => $userid);
				$this->send_pm(
					$recipient,
					$pmrecipient,
					construct_phrase($vbphrase['dbtech_vbshop_new_configuration_x'],
						$this->config['title']
					),
					construct_phrase($vbphrase['dbtech_vbshop_x_just_configured_y'],
						$recipient['username'],
						$this->config['title'],
						implode("\n", $values)
					)
				);
			}
		}
		
		// Update flag
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . "dbtech_vbshop_purchase
			SET configuration = " . $this->registry->db->sql_prepare(trim(serialize($code))) . "
			WHERE purchaseid = " . intval($purchaseid) . "
		");
		
		// Build purchase cache
		VBSHOP::build_purchases($recipient);
	}	
}
?>