<?php
if (!class_exists('vBShop_Item_Core'))
{
	die('No direct access allowed.');
}

class vBShop_Item_immunity extends vBShop_Item_Core
{
	/**
	* The constructor
	*
	* @param	vBulletin	vBulletin registry
	* @param	array		Item info
	*/	
	public function __construct(&$registry, &$item)
	{
		$item['_nodeactivate'] = true;
		parent::__construct($registry, $item);
	}
	
	/**
	* Function to call before every action
	*/	
	public function action()
	{
		if (!parent::action())
		{
			// This type is inactive
			return false;
		}
		
		// We made it!
		return true;
	}
	
	/**
	* Prints out an AdminCP form
	*/	
	public function print_admin_form($code)
	{
		global $vbphrase;
		
		$val = 0;
		foreach ((array)$code['value'] as $value)
		{
			// Increment value
			$val += $value;
		}		

		// Finally print the select
		require_once(DIR . '/dbtech/vbshop/includes/functions.php');		
		print_bitfield_row($vbphrase['dbtech_vbshop_immunity'], 'item[code][value]', 'nocache|dbtech_vbshop_immunity', $val);
	}
	
	/**
	* Activate an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Recipient
	*/	
	public function activate($purchaseid, $recipient = null)
	{
		global $vbphrase;
		
		// Ensure this gets ran
		if (!parent::activate($purchaseid, $recipient))
		{
			// Parent returned false
			return false;
		}
		
		// Ensure this is set
		$recipient = (!$recipient ? $this->registry->userinfo : $recipient);
		
		// Ensure we have the necessary files
		require_once(DIR . '/includes/adminfunctions.php');
		require_once(DIR . '/includes/adminfunctions_options.php');
		
		$bit = 0;
		foreach ((array)$this->config['code']['value'] as $val)
		{
			if ($val)
			{
				$bit = $val;
				break;
			}
		}
		
		$bitfielddefs =& fetch_bitfield_definitions('nocache|dbtech_vbshop_immunity');
		foreach ($bitfielddefs AS $key => $val)
		{
			if (((int)$bit & (int)$val))
			{
				// Update the immunity
				$this->registry->db->query_write("
					UPDATE " . TABLE_PREFIX . "user
					SET dbtech_vbshop_immunity = dbtech_vbshop_immunity + " . intval($val) . "
					WHERE userid = " . intval($recipient['userid']) . "
						AND NOT (dbtech_vbshop_immunity & " . intval($val) . ")
				");
			}
		}
	}
	
	/**
	* Deactivate an item
	*
	* @param	integer		Purchase ID
	* @param	mixed		Recipient
	*/	
	public function deactivate($purchaseid, $recipient = null)
	{
		global $vbphrase;
		
		// Ensure this gets ran
		if (!parent::deactivate($purchaseid, $recipient))
		{
			// Couldn't deactivate
			return false;
		}
		
		// Ensure this is set
		$recipient = (!$recipient ? $this->registry->userinfo : $recipient);
		
		// Ensure we have the necessary files
		require_once(DIR . '/includes/adminfunctions.php');
		require_once(DIR . '/includes/adminfunctions_options.php');
		
		$bit = 0;
		foreach ((array)$this->config['code']['value'] as $val)
		{
			if ($val)
			{
				$bit = $val;
				break;
			}
		}
		
		$bitfielddefs =& fetch_bitfield_definitions('nocache|dbtech_vbshop_immunity');
		foreach ($bitfielddefs AS $key => $val)
		{
			if (((int)$bit & (int)$val))
			{
				// Update the immunity
				$this->registry->db->query_write("
					UPDATE " . TABLE_PREFIX . "user
					SET dbtech_vbshop_immunity = dbtech_vbshop_immunity - " . intval($val) . "
					WHERE userid = " . intval($recipient['userid']) . "
						AND (dbtech_vbshop_immunity & " . intval($val) . ")
				");
			}
		}
	}
}
?>