<?php

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_vbshop_category` (
	  `categoryid` INT( 10 ) UNSIGNED NOT NULL AUTO_INCREMENT ,
	  `title` VARCHAR( 50 ) NOT NULL DEFAULT '',
	  `description` MEDIUMTEXT NULL DEFAULT NULL,
	  `displayorder` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
	  PRIMARY KEY ( `categoryid` )
	)
");
self::report('Created Table', 'dbtech_vbshop_category');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_vbshop_donationlog` (
	  `donationlogid` INT( 10 ) UNSIGNED NOT NULL AUTO_INCREMENT ,
	  `userid` INT( 10 ) UNSIGNED NOT NULL ,
	  `recipient` INT( 10 ) UNSIGNED NOT NULL ,
	  `points` DOUBLE DEFAULT '0',
	  PRIMARY KEY ( `donationlogid` ) ,
	  KEY ( `userid` ) ,
	  KEY ( `recipient` )
	)
");
self::report('Created Table', 'dbtech_vbshop_purchase');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_vbshop_gift` (
	  `giftid` INT( 10 ) NOT NULL AUTO_INCREMENT ,
	  `categoryid` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
	  `title` VARCHAR( 50 ) NOT NULL DEFAULT '',
	  `description` MEDIUMTEXT NULL DEFAULT NULL ,
	  `icon` MEDIUMTEXT NULL DEFAULT NULL ,
	  `shopicon` MEDIUMTEXT NULL DEFAULT NULL ,
	  `displayorder` INT( 10 ) UNSIGNED NOT NULL DEFAULT '10',
	  `purchases` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
	  `price` DOUBLE DEFAULT '0',
	  `permissions` MEDIUMTEXT NULL DEFAULT NULL ,
	  PRIMARY KEY ( `giftid` ) ,
	  KEY ( `categoryid` )
	)
");
self::report('Created Table', 'dbtech_vbshop_gift');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_vbshop_item` (
	  `itemid` INT( 10 ) NOT NULL AUTO_INCREMENT ,
	  `categoryid` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
	  `title` VARCHAR( 50 ) NOT NULL DEFAULT '',
	  `description` MEDIUMTEXT NULL DEFAULT NULL ,
	  `shopicon` MEDIUMTEXT NULL DEFAULT NULL ,
	  `displayorder` INT( 10 ) UNSIGNED NOT NULL DEFAULT '10',
	  `purchases` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
	  `price` DOUBLE DEFAULT '0',
	  `permissions` MEDIUMTEXT NULL DEFAULT NULL ,
	  `code` MEDIUMTEXT NULL DEFAULT NULL ,
	  `itemtype` VARCHAR( 50 ) NOT NULL DEFAULT '',
	  `giftable` ENUM( '0', '1' ) NOT NULL DEFAULT '0',
	  PRIMARY KEY ( `itemid` ) ,
	  KEY ( `categoryid` )
	)
");
self::report('Created Table', 'dbtech_vbshop_item');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_vbshop_purchase` (
	  `purchaseid` INT( 10 ) UNSIGNED NOT NULL AUTO_INCREMENT ,
	  `userid` INT( 10 ) UNSIGNED NOT NULL ,
	  `buyer` INT( 10 ) UNSIGNED NOT NULL ,
	  `feature` VARCHAR( 50 ) NOT NULL DEFAULT '' ,
	  `featureid` INT( 10 ) UNSIGNED NOT NULL ,
	  `dateline` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0' ,
	  PRIMARY KEY ( `purchaseid` ) ,
	  KEY ( `feature`, `featureid` ) ,
	  KEY ( `userid` ) ,
	  KEY ( `buyer` )
	)
");
self::report('Created Table', 'dbtech_vbshop_purchase');



// Add the administrator field
if (self::$db_alter->fetch_table_info('administrator'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbshopadminperms',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::report('Altered Table', 'administrator');
}

// Add the usergroup field
if (self::$db_alter->fetch_table_info('user'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbshop_points',
		'type'       => 'double',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbshop_purchase',
		'type'       => 'mediumtext',
		'null'       => true,	// True = NULL, false = NOT NULL
		'default'    => NULL
	));
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbshop_immunity',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbshop_usernamestyle',
		'type'       => 'mediumtext',
		'null'       => true,	// True = NULL, false = NOT NULL
		'default'    => NULL
	));
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbshop_usertitlestyle',
		'type'       => 'mediumtext',
		'null'       => true,	// True = NULL, false = NOT NULL
		'default'    => NULL
	));
	self::report('Altered Table', 'user');
}

if (self::$db_alter->fetch_table_info('usergroup'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbshoppermissions',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::report('Altered Table', 'usergroup');
}