<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for lotterys
*
* @package	vbshop
*/
class vBShop_DataManager_Lottery extends vB_DataManager
{
	/**
	* Array of recognised and required fields for lotterys, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'lotteryid' 	=> array(TYPE_UINT, 	REQ_INCR, 	VF_METHOD, 	'verify_nonzero'),
		'title' 		=> array(TYPE_STR, 		REQ_YES, 	VF_METHOD),
		'description' 	=> array(TYPE_STR, 		REQ_NO),
		'active' 		=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
		'permissions' 	=> array(TYPE_NOCLEAN, 	REQ_NO, 	VF_METHOD, 	'verify_serialized'),
		'ticketprice' 	=> array(TYPE_UNUM, 	REQ_NO),
		'currencyid' 	=> array(TYPE_UINT, 	REQ_NO, 	VF_METHOD, 	'verify_currencyid'),
		'numbers' 		=> array(TYPE_NOCLEAN, 	REQ_NO, 	VF_METHOD, 	'verify_serialized'),
		'drawnnumbers' 	=> array(TYPE_NOCLEAN, 	REQ_NO, 	VF_METHOD, 	'verify_serialized'),
		'prizes' 		=> array(TYPE_NOCLEAN, 	REQ_NO, 	VF_METHOD, 	'verify_serialized'),
		'drawinterval' 	=> array(TYPE_UINT, 	REQ_NO),
		'nextdraw' 		=> array(TYPE_UNIXTIME, REQ_YES),
		'prevdraw' 		=> array(TYPE_UNIXTIME, REQ_NO),
		'bitfield' 		=> array(TYPE_UINT, 	REQ_AUTO),		
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_vbshop_lottery';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('lotteryid = %1$d', 'lotteryid');

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function vBShop_DataManager_Lottery(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);

		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_lotterydata_start')) ? eval($hook) : false;
	}

	/**
	* Verifies that the title is valid
	*
	* @param	string	Title of the lottery
	*
	* @return	boolean
	*/
	function verify_title(&$title)
	{
		global $vbphrase;
		
		$title = strval($title);
		if ($title === '')
		{
			// Invalid
			return false;
		}
		
		// Check for existing lottery of this name
		if ($existing = $this->registry->db->query_first("
			SELECT `title`
			FROM `" . TABLE_PREFIX . "dbtech_vbshop_lottery`
			WHERE `title` = " . $this->registry->db->sql_prepare($title) . "
				" . ($this->existing['lotteryid'] ? "AND `lotteryid` != " . $this->registry->db->sql_prepare($this->existing['lotteryid']) : '') . "			
			LIMIT 1
		"))
		{
			// Whoopsie, exists
			$this->error('dbtech_vbshop_x_already_exists_y', $vbphrase['dbtech_vbshop_lottery'], $title);
			return false;
		}
		
		return true;
	}

	/**
	* Verifies that the onoff flag is valid
	*
	* @param	string	On/Off flag
	*
	* @return	boolean
	*/
	function verify_onoff(&$onoff)
	{
		// Validate onoff
		$onoff = (!in_array($onoff, array('0', '1')) ? '1' : $onoff);
		
		return true;
	}

	/**
	* Verifies that the currencyid is valid
	*
	* @param	integer	currencyid
	*
	* @return	boolean
	*/
	function verify_currencyid(&$currencyid)
	{
		// Validate currencyid
		return is_array(VBSHOP::$cache['currency']["$currencyid"]);
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}
		
		if (!$this->condition)
		{
			// Check for existing button of this name
			if ($existing = $this->registry->db->query_first("
				SELECT `bitfield`
				FROM `" . TABLE_PREFIX . "dbtech_vbshop_lottery`
				ORDER BY `bitfield` DESC
				LIMIT 1
			"))
			{
				// Use existing bitfield
				$bitfield = ($existing['bitfield'] * 2);
			}
			else
			{
				// This is the first one
				$bitfield = 1;
			}
			
			// Set the bitfield
			$this->do_set('bitfield', $bitfield);
		}
		
		$numbers = $this->fetch_field('numbers');
		$numbers = (!is_array($numbers) ? unserialize($numbers) : $numbers);
		if ($numbers['main'] == 0)
		{
			$numbers['main'] = 1;
			$this->set('numbers', $numbers);
		}
		
		$update = false;
		$prizes = $this->fetch_field('prizes');
		$prizes = (!is_array($prizes) ? unserialize($prizes) : $prizes);
		foreach ($prizes as $key => $prizeinfo)
		{
			$prizeid = $prizeinfo['prizeid'];
			$currencyid = $prizeinfo['currencyid'];
			if (!VBSHOP::$cache['lotteryprize']["$prizeid"])
			{
				// Reset prize
				$prizes["$key"] = array('prizeid' => 0, 'prize' => 0, 'currencyid' => 0);
				$update = true;
			}
			
			if (!VBSHOP::$cache['currency']["$currencyid"])
			{
				// Reset prize
				$prizes["$key"] = array('prizeid' => 0, 'prize' => 0, 'currencyid' => 0);
				$update = true;
			}
			
			if (VBSHOP::$cache['lotteryprize']["$prizeid"]['numbers']['main'] > $numbers['main'] OR
				VBSHOP::$cache['lotteryprize']["$prizeid"]['numbers']['bonus'] > $numbers['bonus'])
			{
				// Reset prize
				$prizes["$key"] = array('prizeid' => 0, 'prize' => 0, 'currencyid' => 0);
				$update = true;
			}
		}
		
		if ($update)
		{
			// Reset prizes
			$this->set('prizes', $prizes);
		}

		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_lotterydata_presave')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}
	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_lotterydata_predelete')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_lotterydata_postsave')) ? eval($hook) : false;

		// Rebuild the cache
		VBSHOP_CACHE::build_cache('lottery', 'ORDER BY `nextdraw` ASC');

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_lotterydata_delete')) ? eval($hook) : false;
		
		// Rebuild the cache
		VBSHOP_CACHE::build_cache('lottery', 'ORDER BY `nextdraw` ASC');
		
		return true;
	}
}


/*======================================================================*\
|| ####################################################################
|| # Created: 16:52, Sat Dec 26th 2009
|| # SVN: $ $Rev$ $ - $ $Date$ $
|| ####################################################################
\*======================================================================*/