<?php
if ($threadedmode != 0)
{
	// $cache_postids
	$postids = 'post.postid IN (' . $cache_postids . ')';
}

if ($postids)
{
	$currencydata = array(
		'fields' => array(),
		'tables' => array(),
		'lookup' => array()
	);
	
	foreach ((array)VBSHOP::$cache['currency'] as $currencyid => $currency)
	{
		if (!$currency['active'])
		{
			// Inactive currency
			continue;
		}
		
		// Setup the fields and tables
		$currencydata['fields'][] = 'pointstable_' . $currencyid . '.' . $currency['pointscolumn'] . ' AS points_' . $currencyid;
		$currencydata['tables'][] = 'LEFT JOIN ' . TABLE_PREFIX . $currency['pointstable'] . ' AS pointstable_' . $currencyid . ' ON(pointstable_' . $currencyid . '.userid = post.userid)';
		$currencydata['lookup']['points_' . $currencyid] = $currencyid;
	}
	
	if (count($currencydata['fields']))
	{
		// Fetch rewards
		$results_q = $db->query_read_slave("
			SELECT
				" . implode(',', $currencydata['fields']) . ",
				post.userid
			FROM " . TABLE_PREFIX . "post AS post
			" . implode(' ', $currencydata['tables']) . "
			WHERE $postids
		");
		while ($results_r = $db->fetch_array($results_q))
		{
			foreach ($currencydata['lookup'] as $key => $val)
			{
				VBSHOP::$cache['currencies'][$results_r['userid']][$val] = $results_r[$key];
			}
		}
		$db->free_result($results_q);
		unset($results_r);
	}
}
?>