<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
if (!is_object($vbulletin->db))
{
	exit;
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (defined('IN_CONTROL_PANEL'))
{
	define('ECHO_CRON_LOG', true);
}

foreach ((array)VBSHOP::$cache['lottery'] as $lotteryid => $lottery)
{
	if ($lottery['nextdraw'] > TIMENOW)
	{
		// Not drawing yet
		continue;
	}
	
	if ($lottery['nextdraw'] == $lottery['prevdraw'])
	{
		// This is a non-recurring lottery
		continue;
	}
	
	$drawnnumbers = array(
		'main' 	=> array(),
		'bonus' => array(),
	);
	foreach (array('main', 'bonus') as $key)
	{
		$usednumbers = array();
		for ($i = 1; $i <= $lottery['numbers'][$key]; $i++)
		{
			$retry = true;
			while ($retry)
			{
				$num = mt_rand(1, $lottery['numbers']['total']);
				$retry = (bool)$usednumbers[$num];
			}
			
			// Used number
			$usednumbers[$num] = true;
			$drawnnumbers[$key][$i] = $num;
		}
		
		sort($drawnnumbers[$key], SORT_NUMERIC);
	}
	
	$usertickets = $vbulletin->db->query_read_slave("
		SELECT *
		FROM " . TABLE_PREFIX . "dbtech_vbshop_lotteryticket
		WHERE lotteryid = " . intval($lottery['lotteryid']) . "
			AND lotterydraw = " . intval($lottery['nextdraw']) . "
			AND prizeid = 0
	");
	while ($ticket = $vbulletin->db->fetch_array($usertickets))
	{
		$matchednumbers = array(
			'main' 	=> 0,
			'bonus' => 0,
		);
		
		// Get the numbers selected
		$numbers = @unserialize($ticket['numbers']);
		
		foreach ($numbers as $num)
		{
			foreach (array('main', 'bonus') as $key)
			{
				if (in_array($num, $drawnnumbers[$key]))
				{
					// We matched a number, woo
					$matchednumbers[$key]++;
				}
			}
		}
		
		foreach ($lottery['prizes'] as $key => $prizeinfo)
		{
			if (!VBSHOP::$cache['lotteryprize'][$prizeinfo['prizeid']] OR 
				!$prizeinfo['prize'] OR
				!VBSHOP::$cache['currency'][$prizeinfo['currencyid']]
			)
			{
				// Gtfo
				continue;
			}
			
			$prize = VBSHOP::$cache['lotteryprize'][$prizeinfo['prizeid']];
			
			if ($matchednumbers['main'] >= $prize['numbers']['main'] AND
				$matchednumbers['bonus'] >= $prize['numbers']['bonus'])
			{
				// Winrar
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "dbtech_vbshop_lotteryticket
					SET prizeid = " . intval($key) . "
					WHERE lotteryticketid = " . intval($ticket['lotteryticketid'])
				);
				
				// Can't have more prizes
				break;
			}
		}
	}
	
	$prizes = array();
	$winners = array();
	$usertickets = $vbulletin->db->query_read_slave("
		SELECT *
		FROM " . TABLE_PREFIX . "dbtech_vbshop_lotteryticket
		WHERE lotteryid = " . intval($lottery['lotteryid']) . "
			AND lotterydraw = " . intval($lottery['nextdraw']) . "
			AND prizeid > 0
	");
	while ($ticket = $vbulletin->db->fetch_array($usertickets))
	{
		$prizes[$ticket['prizeid']]++;
		$winners[$ticket['prizeid']][] = $ticket['userid'];
	}
	
	if (count($winners))
	{
		foreach ($prizes as $prizeid => $count)
		{
			$payout = ceil($lottery['prizes'][$prizeid]['prize'] / $count);
			$currency = VBSHOP::$cache['currency'][$lottery['prizes'][$prizeid]['currencyid']];
			
			foreach ($winners[$prizeid] as $userid)
			{
				// We're done with the error checking
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . $currency['pointstable'] . "
					SET " . $currency['pointscolumn'] . " = " . $currency['pointscolumn'] . " + " . doubleval($payout) . "
					WHERE userid = " . intval($userid)
				);
			
				$info = array(
					'lotteryid' 	=> $lottery['lotteryid'],
					'currencyid' 	=> $currency['currencyid'],
					'winnings' 		=> $payout,
					'prizeid' 		=> $lottery['prizes'][$prizeid]['prizeid']
				);
				
				// init data manager
				$dm =& VBSHOP::datamanager_init('Transactionlog', $vbulletin, ERRTYPE_ARRAY);
					$dm->set('userid', 		$userid);
					$dm->set('recipient', 	$userid);
					$dm->set('ipaddress', 	IPADDRESS);
					$dm->set('action', 		'lotteryprize');
					$dm->set('info', 		$info);
				$dm->save();
				unset($dm);	
			}
		}
		
	}
	
	if (!$existing = VBSHOP::$cache['lottery']["$lotteryid"])
	{
		// Doesn't exist anymore
		continue;
	}
	
	$newdrawnnumbers = $existing['drawnnumbers'];
	$newdrawnnumbers[$existing['nextdraw']] = $drawnnumbers;
	
	// init data manager
	$dm =& VBSHOP::datamanager_init('Lottery', $vbulletin, ERRTYPE_SILENT);
		$dm->set_existing($existing);
		$dm->set('drawnnumbers', $newdrawnnumbers);
		$dm->set('prevdraw', $existing['nextdraw']);
		$dm->set('nextdraw', ($existing['nextdraw'] + (86400 * $existing['drawinterval'])));
	$dm->save();
	unset($dm);
}

/*
if (!function_exists('fetch_microtime_difference'))
{
	// Deceptor sucks at the internet
	require(DIR . '/includes/functions_misc.php');
}

// Any lottery items?
$lottery = array();

if (is_array(VBSHOP::$cache['item']))
{
	foreach (VBSHOP::$cache['item'] as $item)
	{
		if ($item['itemtypeid'] == 'lotteryticket')
		{
			$lottery[$item['itemid']] = $item;
		}
	}
}

if (!empty($lottery))
{
	foreach ($lottery as $lotto)
	{
		$winners = array();
		$losers = array();
		$pm = array();
		$lotto = VBSHOP::init_item($lotto);

		if (TIMENOW >= $lotto->nextdraw())
		{
			// Find available tickets
			$tickets = $lotto->fetchtickets();
			$ticketids = array();

			if (count($tickets) > 0)
			{
				$numbers = $lotto->getnumbers();
				$prizes = $lotto->prizes($lotto->config['code']['prize']);

				foreach ($tickets as $ticket)
				{
					$ticketids[] = $ticket['ticketid'];
					$matches = $lotto->matches($numbers, unserialize($ticket['numbers']));
					$prize = $lotto->findprize($matches, $prizes);

					if ($prize)
					{
						// We have a winner!
						$winners[] = array('ticket' => $ticket, 'prize' => ceil($lotto->calcprize($prize, $tickets)));
					}
					else
					{
						// Better luck next time!
						$losers[] = array('ticket' => $ticket);
					}
				}
				
				// Deceptor sucks at the internet
				$vbphrase['dbtech_vbshop_lottery_winner'] 			= fetch_phrase('dbtech_vbshop_lottery_winner', 			'global');
				$vbphrase['dbtech_vbshop_lottery_winner_message'] 	= fetch_phrase('dbtech_vbshop_lottery_winner_message', 	'global');
				$vbphrase['dbtech_vbshop_lottery_loser'] 			= fetch_phrase('dbtech_vbshop_lottery_loser', 			'global');
				$vbphrase['dbtech_vbshop_lottery_loser_message'] 	= fetch_phrase('dbtech_vbshop_lottery_loser_message', 	'global');

				// Any winners?
				foreach ($winners as $winner)
				{
					// Update funds
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "{$vbulletin->options[dbtech_vbshop_pointstable]}
						SET {$vbulletin->options[dbtech_vbshop_pointsfield]} = {$vbulletin->options[dbtech_vbshop_pointsfield]} + {$winner['prize']}
						WHERE userid = " . $winner['ticket']['userid'] . "
					");

					// Apply to PM array
					$pm[] = array(
						'userid'	=> $winner['ticket']['userid'],
						'username'	=> $winner['ticket']['username'],
						'title'		=> $vbphrase['dbtech_vbshop_lottery_winner'],
						'message'	=> sprintf($vbphrase['dbtech_vbshop_lottery_winner_message'], $matches, $prize, implode(', ', array_values($numbers)), $vbulletin->options['dbtech_vbshop_pointsname']),
					);
				}

				// Any losers?
				foreach ($losers as $loser)
				{
					$pm[] = array(
						'userid'	=> $loser['ticket']['userid'],
						'username'	=> $loser['ticket']['username'],
						'title'		=> $vbphrase['dbtech_vbshop_lottery_loser'],
						'message'	=> sprintf($vbphrase['dbtech_vbshop_lottery_loser_message'], implode(', ', array_values($numbers))),
					);
				}

				// Nullify tickets
				log_cron_action('Updating Tickets: ' . implode(',', $ticketids), $nextitem);
				$vbulletin->db->query_write("update " . TABLE_PREFIX . "dbtech_vbshop_ticket set active = '0' where ticketid in (" . implode(',', $ticketids) . ")");
			}
			else
			{
				log_cron_action('No tickets to check...', $nextitem);
			}

			// Update the lottery runtime
			$lotto->config['code']['start'] = $lotto->nextdraw();
			
			log_cron_action('Updating Item: ' . $lotto->config['itemid'], $nextitem);
			$vbulletin->db->query_write("update " . TABLE_PREFIX . "dbtech_vbshop_item set code = '" . $vbulletin->db->escape_string(serialize($lotto->config['code'])) . "' where itemid = " . intval($lotto->config['itemid']));
			VBSHOP_CACHE::build_cache('item');

			// Send the private messages
			if (count($pm) > 0)
			{
				$permissions = array(
					'pmsendmax' => 10,
				);

				foreach ($pm as $message)
				{
					$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
					$pmdm->set_info('is_automated', true); // implies overridequota
					$pmdm->set('fromuserid', $message['userid']);
					$pmdm->set('fromusername', $message['username']);
					$pmdm->setr('title', $message['title']);
					$pmdm->set_recipients($message['username'], $permissions, 'cc');
					$pmdm->setr('message', $message['message']);
					$pmdm->set('dateline', TIMENOW);
					$pmdm->set('allowsmilie', 0);

					if ($pmdm->pre_save() AND empty($pmdm->errors))
					{
						log_cron_action("Sending PM to: $message[username]", $nextitem);
						$pmdm->save();
					}
					else
					{
						log_cron_action(implode(', ', $pmdm->errors), $nextitem);
					}
				}
			}
			else
			{
				log_cron_action('No users to PM...', $nextitem);
			}

			break; // 1 lottery per cron rotation max!
		}
		else
		{
			log_cron_action(TIMENOW . ' is less than ' . $lotto->nextdraw() . '...', $nextitem);
		}
	}
}
else
{
	log_cron_action('No lotteries found...', $nextitem);
}
*/

//log_cron_action('Lottery Processed', $nextitem);

/*======================================================================*\
|| #################################################################### ||
|| # Created: 16:56, Sun Sep 7th 2008								  # ||
|| # SVN: $Rev$							 							  # ||
|| #################################################################### ||
\*======================================================================*/