/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2011 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// For some reason this needs to go here alluvasudden...
var currentInfo = $.parseJSON(currentInfo);

$.noConflict(true)(function($)
{
	// Define some variables
	var styleConfig = $('input[name^="code["]:visible'),
		ftd = $(document),
		stylePreview = $('span[name=previewusername]'),
		previewUsername = $('span[name=previewusername]:first').text();
	
	// Shop button clicks
	ftd.on('click', 'input[name=shoploader]', function()
	{
		var shopid = $(this).attr('data-shopid');
		if (currentInfo.shopid != shopid)
		{
			// Animate box
			animateBox(
				vbphrase['dbtech_vbshop_switching_shop'],
				vbphrase['dbtech_vbshop_switching_shop_descr'],
				true
			);
			
			// refresh the shop
			refreshShop(shopid);
		}
	});
	
	// When to refresh items
	ftd.on('click', 'a[name=default]', 		itemSort);
	ftd.on('click', 'a[name=title]', 		itemSort);
	ftd.on('click', 'a[name=popularity]', 	itemSort);
	ftd.on('click', 'a[name=price]', 		itemSort);
	
	// Shop refreshing
	ftd.on('change', 'select[name=perpage]', function()
	{
		animateBox(
			vbphrase['dbtech_vbshop_sorting_items'],
			vbphrase['dbtech_vbshop_sorting_items_descr'],
			true
		);
		
		// Set the new value
		currentInfo.perpage = $(this).val();
		
		// refresh the shop
		refreshShop(currentInfo.shopid, true, true);
	});
	
	// Purchase button click
	ftd.on('click', 'input[name=purchase]', function()
	{
		animateBox(
			vbphrase['dbtech_vbshop_buying_item'],
			vbphrase['dbtech_vbshop_buying_item_descr'],
			true
		);
		
		var extraParams = {};
			extraParams['do'] 		= 'shop';
			extraParams['action'] 	= 'addtocart';
			extraParams['isajax'] 	= '1';
			extraParams['shopid'] 	= currentInfo.shopid;
			extraParams['itemid'] 	= $(this).attr('data-itemid');
		
		$.post('vbshop.php', SESSIONURL + 'securitytoken=' + SECURITYTOKEN + '&' + $.param(extraParams), function(data)
		{
			// Parse the data
			data = $.parseJSON(data);
			
			if (data.success)
			{
				// refresh the shop
				refreshShop(currentInfo.shopid, true, true);
			}
		});		
		
	});
	
	// Sort the "style config" previews
	styleConfig.on('keyup keydown change', updatePreview);
	
	// Launch this right away in case this is a refresh
	updatePreview();
	
	// Item sort function
	function itemSort(e)
	{
		animateBox(
			vbphrase['dbtech_vbshop_sorting_items'],
			vbphrase['dbtech_vbshop_sorting_items_descr'],
			true
		);
		
		var clickedLink = $(this);
		if (currentInfo.sorttype == clickedLink.attr('name'))
		{
			// Just change sort order
			currentInfo.sortorder = (currentInfo.sortorder == 'asc' ? 'desc' : 'asc');
		}
		else
		{
			// Just sort by the new thing
			currentInfo.sorttype = clickedLink.attr('name');
			currentInfo.sortorder = 'asc';
		}

		// refresh the shop
		refreshShop(currentInfo.shopid, true);
	}
	
	// Shop refreshing function
	function refreshShop(shopid, refreshSame, noPage)
	{
		var extraParams = {};
			extraParams['do'] 			= 'shop';
			extraParams['action'] 		= 'shop';
			extraParams['isajax'] 		= '1';
			extraParams['shopid'] 		= shopid;
			extraParams['perpage'] 		= currentInfo.perpage;
			extraParams['sorttype'] 	= currentInfo.sorttype;
			extraParams['sortorder'] 	= currentInfo.sortorder;
		if (refreshSame)
		{
			extraParams['tab'] = currentInfo.tab;
			if (!noPage)
			{
				extraParams['pagenumber'] = currentInfo.pagenumber;
			}
		}
		
		$.get('vbshop.php', SESSIONURL + '&' + $.param(extraParams), function(data)
		{
			// Parse the data
			data = $.parseJSON(data);
			
			for (var i in data)
			{
				// Set this content
				$('#' + i).html(data[i]);
			}
			
			// Set new shopid
			currentInfo.shopid = shopid;
			
			// Animate box
			animateBox(false, false, false);			
		});		
	}
	
	// Handle box animation
	function animateBox(title, description, onoff)
	{
		// Define variables
		var box = $('#ajaxprogress');
		
		if (onoff)
		{
			// Set CSS properties
			box.css('display', 'inline-block');
			box.css('opacity', 0);
		}
		
		if (title)
		{
			// Set title
			$('#progresstitle').html(title);
		}
		
		if (description)
		{
			// Set description
			$('#progresscontent').html(description);
		}
		
		// Set animation
		box.animate({
			opacity: (onoff ? 0.8 : 0)
		},
		{
			duration: 700
		});		
	}
	
	// Live preview function
	function updatePreview(e)
	{
		var openTag = '';
		var closeTag = '';
		
		var configOptions = new Array();
		styleConfig.each(function(index)
		{
			var self = $(this),
				cb = self.is(':checkbox'),
				chk = self.is(':checked'),
				val = self.val(),
				inputName = self.attr('name')
					.replace('code[', '')
					.replace(']', '')
				;
			
			if (cb)
			{
				// It's a checkbox
				configOptions[inputName] = chk;
			}
			else
			{
				// It's an input field
				configOptions[inputName] = val
					.replace(/&/g, "&amp;")
					.replace(/</g, "&lt;")
					.replace(/>/g, "&gt;")
					.replace(/"/g, "&quot;")
					.replace(/'/g, "&#039;")
				;
			}
		});
		
		if (configOptions['bold'])
		{
			// Bolded username
			openTag += 'font-weight:bold; ';
		}
		
		if (configOptions['italic'])
		{
			// Bolded username
			openTag += 'font-style:italic; ';
		}
		
		if (configOptions['underline'])
		{
			// Bolded username
			openTag += 'text-decoration:underline; ';
		}
		
		if (configOptions['color'])
		{
			// Bolded username
			openTag += 'color:' + configOptions['color'] + '; ';
		}
		
		if (configOptions['glow_onoff'])
		{
			openTag += 'text-shadow: 0px 0px 0.2em ' + configOptions['glow'] + ', 0px 0px 0.2em ' + configOptions['glow'] + ', 0px 0px 0.2em ' + configOptions['glow'] + '; ';
			//  filter:progid:DXImageTransform.Microsoft.Glow(Color=#FF0000, Strength=5); _height:1px; 
		}
		
		if (configOptions['shadow_onoff'])
		{
			openTag += 'text-shadow:2px 2px 4px ' + configOptions['shadow'] + '; ';
		}
		
		if (openTag)
		{
			// Close the tag
			openTag = '<span style="' + openTag + '">';
			closeTag = '</span>';
		}
		
		// Set the preview
		stylePreview.html(openTag + previewUsername + closeTag);
	}
});

// #############################################################################
// Do sidebar scrolling
YAHOO.util.Event.onDOMReady(function()
{
	if (YAHOO.util.Dom.get('sidebar'))
	{
		var scroll_offset = YAHOO.util.Dom.get('sidebar').offsetTop;
		YAHOO.util.Dom.setStyle('sidebar', 'width', YAHOO.util.Dom.getStyle('sidebar_container', 'width'));
	
		YAHOO.util.Event.addListener(window, 'scroll', function()
		{	
			var scroll_top = YAHOO.util.Dom.getDocumentScrollTop();
			if (scroll_top + YAHOO.util.Dom.get('sidebar').offsetHeight < YAHOO.util.Dom.get('content').offsetHeight && scroll_top > scroll_offset)
			{
				YAHOO.util.Dom.setStyle('sidebar', 'position', 'fixed');
				YAHOO.util.Dom.setStyle('sidebar', 'marginTop', '-' + scroll_offset + 'px');
			}
			else if (scroll_top > scroll_offset)
			{
				YAHOO.util.Dom.setStyle('sidebar', 'position', '');
				YAHOO.util.Dom.setStyle('sidebar', 'marginTop', ((YAHOO.util.Dom.get('content').offsetHeight - YAHOO.util.Dom.get('sidebar').offsetHeight) > 0 ? (YAHOO.util.Dom.get('content').offsetHeight - YAHOO.util.Dom.get('sidebar').offsetHeight) : 0) + 'px');
			}
			else if (scroll_top < scroll_offset)
			{
				YAHOO.util.Dom.setStyle('sidebar', 'position', '');
				YAHOO.util.Dom.setStyle('sidebar', 'marginTop', '0px');
			}
		});
	}
});

function getParentElement(starterElement, classPattern, testTagName) {
	//
	var currElement = starterElement;
	var foundElement = null;
	while(!foundElement && (currElement = currElement.parentNode))
	{
		if ((classPattern && (currElement.className.indexOf(classPattern) != -1)) || (testTagName && (testTagName.toLowerCase() == currElement.tagName.toLowerCase()))) 
		{
			foundElement = currElement;
		}
	}
	//go up the parentNode tree until found element with matching className
	return foundElement;
}
//getParentElement

function tabViewPicker(anchorObject) {
	//
	
	var clickedTabId = null;

	var tabtree = getParentElement(anchorObject, "tabslight");
	var anchorInventory = tabtree.getElementsByTagName("a");

	var tabIds = [];
	
	for (var i=0; (currAnchor = anchorInventory[i]); i++) {
		//
		var anchorId = currAnchor.href.substring(currAnchor.href.indexOf("#") + 1, currAnchor.href.length);
		var parentDd = getParentElement(currAnchor,null,"dd");
		if (currAnchor == anchorObject) {
			clickedTabId = anchorId;
			parentDd.className = "selected";
		} else {
			parentDd.className = "";
		}
		tabIds.push(anchorId);
	}
	
	//loop thru anchors to gather all tab IDs and set appropriate selected status
	for (var j=0; (currTabId = tabIds[j]); j++) {
		//
		var elem = document.getElementById("view-" + currTabId);
		if (!elem) {continue;}
		if (currTabId == clickedTabId) {
			currentInfo.tab = clickedTabId;
			elem.style.display="block";
		} else {
			elem.style.display="none";
		}
	}
        

	//set appropriate status on all tabs.

	return false;
}
//tabViewPicker


/*======================================================================*\
|| #################################################################### ||
|| # Created: 23:33, Mon Dec 28th 2009								  # ||
|| # SVN: $Rev$							 							  # ||
|| #################################################################### ||
\*======================================================================*/