<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
require_once(DIR . '/dbtech/vbshop/includes/functions.php');

// #############################################################################
if ($_REQUEST['action'] == 'currency' OR empty($_REQUEST['action']))
{
	print_cp_header($vbphrase['dbtech_vbshop_currency_management']);
	
	// Table header
	$headings = array();
	$headings[] = $vbphrase['dbtech_vbshop_currency_name'];
	$headings[] = $vbphrase['description'];
	$headings[] = $vbphrase['active'];
	$headings[] = $vbphrase['display_order'];
	if (VBSHOP::$isPro) $headings[] = $vbphrase['dbtech_vbshop_custom_shops'];
	$headings[] = $vbphrase['dbtech_vbshop_pointstable'];
	$headings[] = $vbphrase['dbtech_vbshop_pointscolumn'];
	$headings[] = $vbphrase['dbtech_vbshop_points_perpost'];
	$headings[] = $vbphrase['dbtech_vbshop_points_perthread'];
	
	// Hook goes here
	
	$headings[] = $vbphrase['edit'];
	$headings[] = $vbphrase['delete'];
	
	
	if (count(VBSHOP::$cache['currency']))
	{
		print_form_header('vbshop', 'currency');	
		construct_hidden_code('action', 'displayorder');
		print_table_header($vbphrase['dbtech_vbshop_currency_management'], count($headings));
		print_description_row($vbphrase['dbtech_vbshop_currency_management_descr'], false, count($headings));	
		print_cells_row($headings, 0, 'thead');
		
		foreach (VBSHOP::$cache['currency'] as $currencyid => $currency)
		{
			// Table data
			$cell = array();
			$cell[] = $currency['title'];
			$cell[] = nl2br($currency['description']);
			$cell[] = ($currency['active'] ? $vbphrase['yes'] : '<span class="col-i"><strong>' . $vbphrase['no'] . '</strong></span>');
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$currencyid]\" value=\"$currency[displayorder]\" tabindex=\"1\" size=\"3\" title=\"" . $vbphrase['edit_display_order'] . "\" />";
			if (VBSHOP::$isPro) $cell[] = ($currency['customshops'] ? $vbphrase['yes'] : '<span class="col-i"><strong>' . $vbphrase['no'] . '</strong></span>');
			$cell[] = $currency['pointstable'];
			$cell[] = $currency['pointscolumn'];
			$cell[] = $currency['perreply'];
			$cell[] = $currency['perthread'];
			
			// Hook goes here
			
			$cell[] = construct_link_code($vbphrase['edit'], 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=currency&amp;action=modify&amp;currencyid=' . $currencyid);
			$cell[] = construct_link_code($vbphrase['delete'], 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=currency&amp;action=delete&amp;currencyid=' . $currencyid);
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
		print_submit_row($vbphrase['save_display_order'], false, count($headings), false, "<input type=\"button\" id=\"addnew\" class=\"button\" value=\"" . str_pad($vbphrase['dbtech_vbshop_add_new_currency'], 8, ' ', STR_PAD_BOTH) . "\" tabindex=\"1\" onclick=\"window.location = 'vbshop.php?do=currency&amp;action=modify'\" />");	
	}
	else
	{
		print_form_header('vbshop', 'currency');	
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_vbshop_currency_management'], count($headings));
		print_description_row($vbphrase['dbtech_vbshop_no_currencys'], false, count($headings));
		print_submit_row($vbphrase['dbtech_vbshop_add_new_currency'], false, count($headings));	
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$currencyid = $vbulletin->input->clean_gpc('r', 'currencyid', TYPE_UINT);
	$currency = ($currencyid ? VBSHOP::$cache['currency']["$currencyid"] : false);
	
	if (!is_array($currency))
	{
		// Non-existing currency
		$currencyid = 0;
	}
	
	$defaults = array(
		'title' 		=> 'Points',
		'description' 	=> 'The default vBShop currency.',
		'active' 		=> 1,
		'displayorder'	=> 10,
		'customshops'	=> 1,
	);
	
	$privacy = array(
		0 => $vbphrase['dbtech_vbshop_shop_managers_only'],
		1 => $vbphrase['dbtech_vbshop_self_and_shop_managers_only'],
		2 => $vbphrase['dbtech_vbshop_everybody'],
	);
	
	if ($currencyid)
	{
		// Edit
		print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_vbshop_editing_x_y'], $vbphrase['dbtech_vbshop_currency'], $currency['title'])));
		print_form_header('vbshop', 'currency');
		construct_hidden_code('action', 'update');
		construct_hidden_code('currencyid', $currencyid);
		print_table_header(construct_phrase($vbphrase['dbtech_vbshop_editing_x_y'], $vbphrase['dbtech_vbshop_currency'], $currency['title']));
	}
	else
	{
		// Add
		print_cp_header($vbphrase['dbtech_vbshop_add_new_currency']);
		print_form_header('vbshop', 'currency');
		construct_hidden_code('action', 'update');
		print_table_header($vbphrase['dbtech_vbshop_add_new_currency']);
		
		$currency = $defaults;
	}
	
	print_description_row($vbphrase['dbtech_vbshop_main_settings'], false, 2, 'optiontitle');	
	print_input_row($vbphrase['title'], 										'currency[title]', 				$currency['title']);
	print_textarea_row($vbphrase['description'], 								'currency[description]', 		$currency['description']);
	print_yes_no_row($vbphrase['active'],										'currency[active]',				$currency['active']);
	print_input_row($vbphrase['display_order'], 								'currency[displayorder]', 		$currency['displayorder']);
	print_description_row($vbphrase['dbtech_vbshop_currency_settings'], false, 2, 'optiontitle');
	print_input_row($vbphrase['dbtech_vbshop_points_table'],					'currency[pointstable]', 		$currency['pointstable']);
	print_input_row($vbphrase['dbtech_vbshop_points_column'],					'currency[pointscolumn]', 		$currency['pointscolumn']);
	print_yes_no_row($vbphrase['dbtech_vbshop_currency_canbank'],				'currency[canbank]',			$currency['canbank']);
	print_yes_no_row($vbphrase['dbtech_vbshop_currency_cansteal'],				'currency[cansteal]',			$currency['cansteal']);
	print_input_row($vbphrase['dbtech_vbshop_currency_stealprotect'],			'currency[stealprotect]',		$currency['stealprotect']);
	if (VBSHOP::$isPro)
	{
		print_input_row($vbphrase['dbtech_vbshop_currency_interest'],			'currency[interest]', 			$currency['interest']);
		print_yes_no_row($vbphrase['dbtech_vbshop_currency_customshops'],		'currency[customshops]',		$currency['customshops']);		
	}
	//print_input_row($vbphrase['dbtech_vbshop_currency_rounding'],				'currency[rounding]', 			$currency['rounding']);
	//print_select_row($vbphrase['dbtech_vbshop_currency_privacy'],				'currency[privacy]', $privacy, 	$currency['privacy']);
	//print_yes_no_row($vbphrase['dbtech_vbshop_currency_customshops'],			'currency[customshops]',		$currency['customshops']);
	print_input_row($vbphrase['dbtech_vbshop_currency_points_per_post'],		'currency[perreply]', 			$currency['perreply']);
	print_input_row($vbphrase['dbtech_vbshop_currency_points_per_thread'],		'currency[perthread]', 			$currency['perthread']);
	//print_bitfield_row($vbphrase['dbtech_vbshop_currency_postbit_integration'], 'currency[postbit]', 'nocache|dbtech_vbshop_postbit', $currency['postbit']);
	
	print_submit_row(($currencyid ? $vbphrase['save'] : $vbphrase['dbtech_vbshop_add_new_currency']));	
}

// #############################################################################
if ($_REQUEST['action'] == 'update')
{
	// Grab stuff
	$vbulletin->input->clean_array_gpc('p', array(
		'currencyid' 	=> TYPE_UINT,
		'currency' 		=> TYPE_ARRAY,
	));
	
	// init data manager
	$dm =& VBSHOP::datamanager_init('Currency', $vbulletin, ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($vbulletin->GPC['currencyid'])
	{
		if (!$existing = VBSHOP::$cache['currency']["{$vbulletin->GPC[currencyid]}"])
		{
			// Couldn't find the currency
			print_stop_message('dbtech_vbshop_invalid_x', $vbphrase['dbtech_vbshop_currency'], $vbulletin->GPC['currencyid']);
		}
		
		// Set existing
		$dm->set_existing($existing);
				
		// Added
		$phrase = $vbphrase['dbtech_vbshop_edited'];
	}
	else
	{
		// Added
		$phrase = $vbphrase['dbtech_vbshop_added'];
	}
	
	// currency fields
	foreach ($vbulletin->GPC['currency'] AS $key => $val)
	{
		if (!$vbulletin->GPC['currencyid'] OR $existing["$key"] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}
	
	// Save! Hopefully.
	$dm->save();
		
	define('CP_REDIRECT', 'vbshop.php?do=currency');
	print_stop_message('dbtech_vbshop_x_y', $vbphrase['dbtech_vbshop_currency'], $phrase);
}

// #############################################################################
if ($_POST['action'] == 'displayorder')
{
	$vbulletin->input->clean_array_gpc('p', array('order' => TYPE_ARRAY));
	
	if (is_array($vbulletin->GPC['order']))
	{
		foreach ($vbulletin->GPC['order'] as $currencyid => $displayorder)
		{
			if (!$existing = VBSHOP::$cache['currency']["$currencyid"])
			{
				// Couldn't find the currency
				continue;
			}
			
			if ($existing['displayorder'] == $displayorder)
			{
				// No change
				continue;
			}
			
			// init data manager
			$dm =& VBSHOP::datamanager_init('Currency', $vbulletin, ERRTYPE_CP);
				$dm->set_existing($existing);
				$dm->set('displayorder', $displayorder);
			$dm->save();
			unset($dm);	
		}
	}
	
	define('CP_REDIRECT', 'vbshop.php?do=currency');
	print_stop_message('saved_display_order_successfully');	
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$vbulletin->input->clean_gpc('r', 'currencyid', TYPE_UINT);
	
	print_cp_header(construct_phrase($vbphrase['dbtech_vbshop_delete_x'], $vbphrase['dbtech_vbshop_currency']));
	print_delete_confirmation('dbtech_vbshop_currency', $vbulletin->GPC['currencyid'], 'vbshop', 'currency', 'dbtech_vbshop_currency', array('action' => 'kill'), '', 'title');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$vbulletin->input->clean_gpc('r', 'currencyid', TYPE_UINT);
	
	if (!$existing = VBSHOP::$cache['currency']["{$vbulletin->GPC[currencyid]}"])
	{
		// Couldn't find the currency
		print_stop_message('dbtech_vbshop_invalid_x', $vbphrase['dbtech_vbshop_currency'], $vbulletin->GPC['currencyid']);
	}
	
	// init data manager
	$dm =& VBSHOP::datamanager_init('Currency', $vbulletin, ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	define('CP_REDIRECT', 'vbshop.php?do=currency');
	print_stop_message('dbtech_vbshop_x_y', $vbphrase['dbtech_vbshop_currency'], $vbphrase['dbtech_vbshop_deleted']);	
}

print_cp_footer();

/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: currency.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>