<?php
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('GET_EDIT_TEMPLATES', true);
define('THIS_SCRIPT', 'gifts');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('posting');

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
	'GIFTS',
	'gifts_list_bit',
	'gifts_list_row_start',
	'gifts_list_row_break',
	'gifts_add_category_select'
	
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'editoptions' => array(
		'modifyavatar',
		'help_avatars_row',
		'modifyavatar_category',
		'modifyavatarbit',
		'modifyavatarbit_custom',
		'modifyavatarbit_noavatar',
	),
	'give' => array(
		'gifts_add',
		'gifts_add_selection_bit',
		'gifts_add_category_bit'
	),
	'delete' => array(
		'gifts_delete'
	)
);

/* ALTER TABLE `gift_type` ADD `categoryid` SMALLINT( 5 ) UNSIGNED NOT NULL ; ALTER TABLE `gifts` ADD `categoryid` SMALLINT( 5 ) UNSIGNED NOT NULL ;
 ALTER TABLE `gift_categories` CHANGE `giftcount` `giftcount` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0' 
INSERT INTO `vb370`.`gift_categories` (
`categoryid` ,
`title` ,
`description` ,
`giftcount`
)
VALUES (
NULL , 'Uncategorized', 'This is a category for uncategorized gifts.', '0'
);


*/

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if (!$vbulletin->userinfo['userid'] || !($permissions['giftpermissions'] & $vbulletin->bf_ugp_giftpermissions['canview']))
{
	print_no_permission();
}

if (!$vbulletin->options['gifts_enabled'])
{
	eval(standard_error(fetch_error('gifts_notenabled',$vbulletin->options['gifts_reason'])));
}

$cansee['privategifts'] = ($permissions['giftpermissions'] & $vbulletin->bf_ugp_giftpermissions['canseeprivategifts']);
$candelete = array();
$candelete['own'] = ($permissions['giftpermissions'] & $vbulletin->bf_ugp_giftpermissions['candeleteowngifts']);
$candelete['others'] = ($permissions['giftpermissions'] & $vbulletin->bf_ugp_giftpermissions['candeleteothersgifts']);

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'list';
}

// universal navbits
$navbits = array();
$navbits["gifts.php"] = $vbphrase['gifts'];

if ($_REQUEST['do'] == 'list')
{
		$vbulletin->input->clean_array_gpc('r', array(
			'u' => TYPE_UINT
		));
		
		// if the list userid is empty, then just show the list.
		$userid = ($vbulletin->GPC['u'] ? $vbulletin->GPC['u'] : $vbulletin->userinfo['userid']);
		$userinfo = fetch_userinfo($userid);
		
		$username = fetch_musername($userinfo);
		
		// START PAGINATION
		$vbulletin->input->clean_array_gpc('r', array(
			'page' => TYPE_INT,
			'pp' => TYPE_INT,
			'order' => TYPE_NOHTML,
			'sort' => TYPE_NOHTML
		 ));
		
		$total_gifts = $db->query_first('SELECT COUNT(*) FROM ' . TABLE_PREFIX . 'gifts WHERE recipientid = ' . $userid, DBARRAY_NUM);
		$total_gifts = $total_gifts[0];
		
		$perpage = ($vbulletin->GPC['pp'] > 0 ? $vbulletin->GPC['pp'] : $vbulletin->options['gifts_per_page']);
		$sort = ($vbulletin->GPC['sort'] ? $vbulletin->GPC['sort'] : 'dateline');
		$order = ($vbulletin->GPC['order'] ? $vbulletin->GPC['order'] : 'DESC');
		$page =& $vbulletin->GPC['page'];
		
		if (empty($page))
		{
			$page = 1;
		}
		
		$start= (($page * $perpage) - $perpage);
		
		if ($pagenumber > $total_brokers)
		{
			$pagenumber = $total_brokers;
		}
		
		$num_pages = ceil($total_gifts / $perpage);
		if ($page <= $num_pages && is_numeric($page))
		{
			$pagenumber = $page;
		}
		$page_navigation = construct_page_nav($pagenumber, $perpage, $total_gifts, 'gifts.php?' . $vbulletin->session->vars['sessionurl'] . "do=list&amp;u=" . $userid . (!empty($vbulletin->GPC['pp']) ? "&amp;pp=$perpage" : ""));
		
		$gifts = $db->query_read_slave("
			SELECT
				gifts.gifttypeid, gifts.giftid, gifts.comment, gifts.message,
				gifts.private, gifts.recipient, gifts.recipientid, gifts.sender,
				gifts.senderid, gifts.dateline, gift_type.title, gift_type.description,
				gift_type.image, gift_categories.title AS categorytitle, gift_categories.categoryid AS catid
			FROM " . TABLE_PREFIX . "gifts AS gifts
			LEFT JOIN " . TABLE_PREFIX . "gift_type AS gift_type ON(gifts.gifttypeid = gift_type.gifttypeid)
			LEFT JOIN " . TABLE_PREFIX . "gift_categories AS gift_categories ON gift_type.categoryid = gift_categories.categoryid
			WHERE recipientid = $userid
			ORDER BY $sort $order
			LIMIT $start, $perpage
		");
		
		if ($db->num_rows($gifts))
		{ 
			$show['gifts'] = true;
			
			$i = 0;
			
			// setup the width of each column
			$width = round(100 / $vbulletin->options['gifts_perrow']);
			
			eval('$gifts_bit .= "' . fetch_template('gifts_list_row_start') . '";');
			while ($gift = $db->fetch_array($gifts))
			{
				if ($i == ($vbulletin->options['gifts_perrow']))
				{
					$i = 0;
					eval('$gifts_bit .= "' . fetch_template('gifts_list_row_break') . '";');
					eval('$gifts_bit .= "' . fetch_template('gifts_list_row_start') . '";');
				}
				
				$gift['date'] = vbdate($vbulletin->options['dateformat'], $gift['dateline']);
				if ($vbulletin->options['gifts_showtime'])
				{
					$gift['time'] = vbdate($vbulletin->options['timeformat'], $gift['dateline']);
				}
				
				if ($gift['private'] && !$cansee['privategifts'])
				{
					$gift['sender'] = 'Private';
					$show['privategifts'] = false;
				}
				else
				{
					$show['privategifts'] = true;
				}
				
				if ($candelete['own'] && ($vbulletin->userinfo['userid'] == $userid))
				{
					$show['deletebutton'] = true;
				}
				else if ($candelete['others'] && ($vbulletin->userinfo['userid'] != $userid))
				{
					$show['deletebutton'] = true;
				}
				else
				{
					$show['deletebutton'] = false;
				}
				
				$i++;
				eval('$gifts_bit .= "' . fetch_template('gifts_list_bit') . '";');
			}
			eval('$gifts_bit .= "' . fetch_template('gifts_list_row_break') . '";');
			$db->free_result($gift);
		}
		else
		{
			$show['gifts'] = false;
			eval('$gifts_bit .= "' . fetch_template('gifts_list_nogifts') . '";');
		}
		
		$navbits= construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');
		eval('print_output("' . fetch_template('GIFTS') . '");');
}

if ($_REQUEST['do'] == 'give')
{
		// START PAGINATION
		$vbulletin->input->clean_array_gpc('r', array(
			'page' => TYPE_INT,
			'pp' => TYPE_INT,
			'order' => TYPE_NOHTML,
			'sort' => TYPE_NOHTML,
			'r' => TYPE_UINT,
			'c' => TYPE_UINT
		 ));
		 
		 if (!($permissions['giftpermissions'] & $vbulletin->bf_ugp_giftpermissions['cansendgifts']))
		 {
		 	print_no_permission();
		 }
		 
		 if (empty($vbulletin->GPC['r']))
		 {
		 	eval(standard_error(fetch_error('gifts_norecipientid')));
		 }
		
		$total_gifts = $db->query_first('SELECT COUNT(*) FROM ' . TABLE_PREFIX . 'gift_type WHERE active = 1 AND categoryid = ' . ($vbulletin->GPC['c'] ? $vbulletin->GPC['c'] : 1), DBARRAY_NUM);
		$total_gifts = $total_gifts[0];
		
		$perpage = ($vbulletin->GPC['pp'] > 0 ? $vbulletin->GPC['pp'] : 24);
		$sort = ($vbulletin->GPC['sort'] ? $vbulletin->GPC['sort'] : 'title');
		$order = ($vbulletin->GPC['order'] ? $vbulletin->GPC['order'] : 'DESC');
		$page =& $vbulletin->GPC['page'];
		$categoryid =& $vbulletin->GPC['c'];
		
		$r =& $vbulletin->GPC['r'];
		
		if (empty($page))
		{
			$page = 1;
		}
		
		$start= (($page * $perpage) - $perpage);
		
		if ($pagenumber > $total_brokers)
		{
			$pagenumber = $total_brokers;
		}
		
		$num_pages = ceil($total_gifts / $perpage);
		if ($page <= $num_pages && is_numeric($page))
		{
			$pagenumber = $page;
		}
		
		$page_navigation = construct_page_nav($pagenumber, $perpage, $total_gifts, 'gifts.php?' . $vbulletin->session->vars['sessionurl'] . 'do=give&amp;' . ($vbulletin->GPC['c'] ? 'c=' . $vbulletin->GPC['c'] . '&amp;' : '') . 'r=' . $vbulletin->GPC['r'] . (!empty($vbulletin->GPC['pp']) ? '&amp;pp=' . $perpage : ''));
		 
		$userinfo = fetch_userinfo($vbulletin->GPC['r']);
		
		if (!$userinfo)
		{
			// invalid user
		}
		
		$categories = $db->query_read("
			SELECT
				gift_categories.categoryid, gift_categories.title,
				gift_categories.description
			FROM " . TABLE_PREFIX . "gift_categories AS gift_categories
			ORDER BY title DESC
		");
		
		$bgclass = 'alt1';
		while ($category = $db->fetch_array($categories))
		{
			if ($vbulletin->options['gifts_showcategorycount'])
			{
				$giftcount = $db->query_first('SELECT COUNT(*) FROM ' . TABLE_PREFIX . 'gift_type AS gift_type WHERE active = 1 AND categoryid = ' . $category['categoryid'],DBARRAY_NUM);
				$giftcount = $giftcount[0];
			}
			
			exec_switch_bg();
			eval('$category_bit .= "' . fetch_template('gifts_add_category_bit') . '";');
		}
		$db->free_result($category);
		
		if ($categoryid)
		{
			$gifts = $db->query_read("
				SELECT
					gift_type.title, gift_type.image,
					gift_type.gifttypeid
				FROM " . TABLE_PREFIX . "gift_type AS gift_type
				WHERE active = 1
				AND categoryid = $categoryid
				ORDER BY $sort $order
				LIMIT $start, $perpage
			");
			
			if ($db->num_rows($gifts) == 0)
			{
				eval('$gifts_bit .= "' . fetch_template('gifts_add_no_gifts') . '";');
			}
			else
			{
				$i = 0;
				// setup the width of each column
				$width = round(100 / $vbulletin->options['gifts_add_perrow']);
				while ($gift = $db->fetch_array($gifts))
				{
					if ($i == ($vbulletin->options['gifts_add_perrow']))
					{
						$i = 0;
						eval('$gifts_bit .= "' . fetch_template('gifts_list_row_break') . '";');
						eval('$gifts_bit .= "' . fetch_template('gifts_list_row_start') . '";');
					}
					$i++;
					eval('$gifts_bit .= "' . fetch_template('gifts_add_selection_bit') . '";');
				}
				$db->free_result($gift);
			}
		}
		else
		{
			eval('$gifts_bit = "' . fetch_template('gifts_add_category_select') . '";');
		}
		
		require_once(DIR . '/includes/functions_editor.php');
		$show['wysiwyg'] = ($setting['allow_bbcode'] ? is_wysiwyg_compatible() : 0);
		$istyles_js = construct_editor_styles_js();
		
	  $editorid = construct_edit_toolbar('', 0, 0, 1, 1, false, 'fe');
		$messagearea = "
		<script type=\"text/javascript\">
		<!--
			var require_click = false;
			var threaded_mode = 1;
			var is_last_page = false;
		// -->
		</script>
		$messagearea
	  ";
		
		$navbits[''] = "Give A Gift";
		$navbits= construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');
		eval('print_output("' . fetch_template('gifts_add') . '");');
}

if ($_REQUEST['do'] == 'insert')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'public_message' => TYPE_NOHTML,
		'recipientid' => TYPE_UINT,
		'recipient' => TYPE_NOHTML,
		'private' => TYPE_BOOL,
		'message' => TYPE_STR,
		'wysiwyg' => TYPE_BOOL,
		'gift' => TYPE_UINT
	));
	
	
	if (!($permissions['giftpermissions'] & $vbulletin->bf_ugp_giftpermissions['cansendgifts']))
	{
		print_no_permission();
	}
	
	$recipientid =& $vbulletin->GPC['recipientid'];
	$recipient = fetch_userinfo($recipientid);
	
	$sender = $vbulletin->userinfo['username'];
	$senderid = $vbulletin->userinfo['userid'];

	
	if (empty($vbulletin->GPC['gift']))
	{
		eval(standard_error(fetch_error('gifts_nogiftselected')));
	}
	
	$gift = $db->query_first('
		SELECT 
			gift_type.image, gift_type.description,
			gift_type.title
		FROM ' . TABLE_PREFIX . 'gift_type AS gift_type
		WHERE active = 1
		AND gifttypeid = ' . $vbulletin->GPC['gift']
	);
	
	if ($vbulletin->options['gifts_prefixurls'])
	{
		if (!strpos($gift['image'],"http://"))
		{
			if (strpos($gift['image'],"/") == 1)
			{
				$gift['image'] = $vbulletin->options['bburl'] . $gift['image'];
			}
			else
			{
				$gift['image'] = $vbulletin->options['bburl'] . '/' . $gift['image'];
			}
		}
	}
	
	
	if ($vbulletin->GPC['message'])
	{
		if ($vbulletin->GPC['wysiwyg'])
		{
			require_once(DIR . '/includes/functions_wysiwyg.php');
			$message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
		}
		else
		{
			$message = $vbulletin->GPC['message'];
		}
		
		// set up an alias of the PM datamanager
		$pm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY); 
		
		// evaluate the message
		$p = $vbulletin->options['gifts_private_message'];
		eval('$pmcontents = "' . fetch_template('gifts_pm_template') . '";');
		
		// Force the PM through
		$doit['adminpermissions'] = 2;

		// create the DM to do error checking and insert the new PM
		$pm->set('fromuserid', $senderid);
		$pm->set('fromusername', $sender);
		$pm->set('title', 'You have a new gift!');
		$pm->set('message', $pmcontents);
		$pm->set_recipients($recipient['username'], $doit);
		$pm->set('dateline', TIMENOW);
		$pm->save();
	}
	
	$db->query_write('
	INSERT INTO ' . TABLE_PREFIX . 'gifts
		(gifttypeid, comment, message, private, recipient, recipientid, sender, senderid, dateline)
		VALUES
		(' . htmlspecialchars_uni($vbulletin->GPC['gift']) . ', "' . htmlspecialchars_uni($db->escape_string($vbulletin->GPC['public_message'])) . '", "' . htmlspecialchars_uni($db->escape_string($message)) . '", ' . $vbulletin->GPC['private'] . ', "' . htmlspecialchars_uni($db->escape_string($recipient['username'])) . '", ' . $recipientid . ', "' . $sender . '", ' . $senderid . ', ' . TIMENOW . ')
	');
	
	$vbulletin->url = 'gifts.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $recipientid;
	eval(print_standard_redirect('gifts_gift_given_successfully'));
}

if ($_REQUEST['do'] == 'delete')
{
		$vbulletin->input->clean_array_gpc('r', array(
			'giftid' => TYPE_UINT,
			'u' => TYPE_UINT
		));
		
		$giftid =& $vbulletin->GPC['giftid'];
		$u =& $vbulletin->GPC['u'];
		
		if (empty($vbulletin->GPC['giftid']))
		{
		 eval(standard_error(fetch_error('gifts_nogiftid')));
		}
		
		if (empty($vbulletin->GPC['u']))
		{
			eval(standard_error(fetch_error('gifts_nouserid')));
		}

		
		if (($vbulletin->userinfo['userid'] == $u) && !$candelete['own'])
		{
			print_no_permission();
		}
		else if (($vbulletin->userinfo['userid'] != $u) && !$candelete['others'])
		{
			print_no_permission();
		}
		
		//$vbulletin->url = 'index.php' . $vbulletin->session->vars['sessionurl_q'];
		//eval(print_standard_redirect('gifts_gift_deleted_successfully',1));
		$navbits[''] = "Delete Gift";
		$navbits= construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');
		eval('print_output("' . fetch_template('gifts_delete') . '");');
}

if ($_REQUEST['do'] == 'processdelete')
{
		$vbulletin->input->clean_array_gpc('p', array(
			'giftid' => TYPE_UINT,
			'u' => TYPE_UINT
		));
		
		if (empty($vbulletin->GPC['giftid']))
		{
		 eval(standard_error(fetch_error('gifts_nogiftid')));
		}
		
		if (empty($vbulletin->GPC['u']))
		{
			eval(standard_error(fetch_error('gifts_nouserid')));
		}
		
		$candelete['owngifts'] = ($vbulletin->userinfo['userid'] == $vbulletin->GPC['u'] && ($permissions['giftpermissions'] & $vbulletin->bf_ugp_giftpermissions['candeleteowngifts']));
		$candelete['othersgifts'] = ($permissions['giftpermissions'] & $vbulletin->bf_ugp_giftpermissions['candeleteothersgifts']);
		
		if (($vbulletin->userinfo['userid'] == $vbulletin->GPC['u']) && !$candelete['own'])
		{
			print_no_permission();
		}
		else if (($vbulletin->userinfo['userid'] != $vbulletin->GPC['u']) && !$candelete['others'])
		{
			print_no_permission();
		}

		// if we have an id go ahead
		$db->query_write('
			DELETE FROM ' . TABLE_PREFIX . 'gifts
			WHERE giftid = ' . $vbulletin->GPC['giftid']
		);

		$vbulletin->url = 'gifts.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $vbulletin->GPC['u'];
		eval(print_standard_redirect('gifts_gift_deleted_successfully',1));
}

?>