<?php

/**
 * Dragonbyte-Tech.com vBSlider Mod 1.0.0
 * 
 * @author Brad Szopinski
 * @copyright 2011
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

if (file_exists(DIR . '/packages/vbcms/content.php'))
{
    $get_widget_id = $vbulletin->db->query_read("
    	SELECT 
    		widgetid 
    	FROM " . TABLE_PREFIX . "cms_widget
    	WHERE 
    		title = 'vBSlider' && 
    		description = 'Dragonbyte Technologies : vBSlider Content Slider'
    "); 

    if ($vbulletin->db->num_rows($get_widget_id) == 0)
    {
    	// Set default widget parameters
    	$template_data = 'dbtech_vbslider';
    	$cache_data = '5';
    	$content_data = 'require_once(DIR . "/dbtech/vbslider/actions/widget.php");';
    	
    	//Clear old cache
    	$clear_widget_cache	= $vbulletin->db->query_write("
    		DELETE FROM " . TABLE_PREFIX . "cache 
    		WHERE 
    			cacheid LIKE 'widget.%'
    	"); 
    
    	//Get PHP Eval Widget ID
    	$widgettypeid = $vbulletin->db->query_first_slave("
    		SELECT 
    			widgettypeid 
    		FROM "  .TABLE_PREFIX . "cms_widgettype 
    		WHERE 
    			class = 'ExecPhp'
    	"); 
    	$php_widget_type = $widgettypeid['widgettypeid'];
    
    	//Create Slider Widget
    	$vbulletin->db->query_write("
    		INSERT INTO " . TABLE_PREFIX . "cms_widget 
    			(
    				varname, 
    				widgettypeid,
    				title,
    				description) 
    			VALUES 
    			(
    				'', 
    				$php_widget_type,
    				'vBSlider', 
    				'Dragonbyte Technologies : vBSlider Content Slider'
    			)
    	");
    	
    	$widgetid = $vbulletin->db->insert_id();
    
    	//Create Widget Config records
    	$vbulletin->db->query_write("
    		INSERT INTO " . TABLE_PREFIX . "cms_widgetconfig 
    			(
    				widgetid,
    				nodeid,
    				name, 
    				value, 
    				serialized
    			) 
    			VALUES 
    			(
    				$widgetid, 
    				0,
    				'template_name', " . 
    				$vbulletin->db->sql_prepare($template_data) . ", 0),(
    				$widgetid,
    				0,
    				'phpcode', " .
    				$vbulletin->db->sql_prepare($content_data) . ", 0),(
    				$widgetid,
    				0,
    				'cache_ttl', " .
    				$vbulletin->db->sql_prepare($cache_data) . ", 0)
    	");
    	
    	$vbulletin->widget_processed = true;
    
    	self::report('Added CMS Widget', 'vBSlider');
    }
}	

?>