<?php

/**
 * Dragonbyte-Tech.com vBSlider Mod 1.0.7
 * 
 * @author Brad Szopinski
 * @copyright 2011
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */
global $vbulletin, $vbphrase; 
$rm = $vbphrase['read_more_phrase'];
$defaultcmsimage = $vbulletin->options['dbtech_vbslider_cms_default_image'];
$defaultforumimage = $vbulletin->options['dbtech_vbslider_forum_default_image'];
$defaultblogimage = $vbulletin->options['dbtech_vbslider_blog_default_image'];
$imgtag = $vbulletin->options['dbtech_vbslider_imgtag'];
$minheight = $vbulletin->options['dbtech_vbslider_min_height'];
$minwidth = $vbulletin->options['dbtech_vbslider_min_width'];
if ($defaultcmsimage == '')
{
    $defaultcmsimage = 'dbtech/vbslider/images/DBTech_vBSlider.png';
}
if ($defaultforumimage == '')
{
    $defaultforumimage = 'dbtech/vbslider/images/DBTech_vBSlider.png';
}
if ($defaultblogimage == '')
{
    $defaultblogimage = 'dbtech/vbslider/images/DBTech_vBSlider.png';
}
$dots = '...';
if (THIS_SCRIPT == 'vbcms')
{
	$forumlist = $vbulletin->options['dbtech_vbslider_cms_pick_forum'];
	$sectionlist = $vbulletin->options['dbtech_vbslider_cms_pick_section'];
	$threadqty = $vbulletin->options['dbtech_vbslider_cms_latest_thread_qty'];
	$articleqty = $vbulletin->options['dbtech_vbslider_cms_latest_article_qty'];
	$customqty = $vbulletin->options['dbtech_vbslider_cms_custom_entry_qty'];
    $blogqty = $vbulletin->options['dbtech_vbslider_cms_latest_blog_qty'];
    $blogcat = $vbulletin->options['dbtech_vbslider_cms_pick_blogcat'];
	$contentLR = $vbulletin->options['dbtech_vbslider_cms_contentLR'];
	$align = $vbulletin->options['dbtech_vbslider_cms_align'];
	$msglength = $vbulletin->options['dbtech_vbslider_cms_msglength'];
	$cms = 'Y';
} else {
	$forumlist = $vbulletin->options['dbtech_vbslider_forum_pick_forum'];
	$sectionlist = $vbulletin->options['dbtech_vbslider_forum_pick_section'];
	$threadqty = $vbulletin->options['dbtech_vbslider_forum_latest_thread_qty'];
	$articleqty = $vbulletin->options['dbtech_vbslider_forum_latest_article_qty'];
	$customqty = $vbulletin->options['dbtech_vbslider_forum_custom_entry_qty'];
    $blogqty = $vbulletin->options['dbtech_vbslider_forum_latest_blog_qty'];
    $blogcat = $vbulletin->options['dbtech_vbslider_forum_pick_blogcat'];
	$contentLR = $vbulletin->options['dbtech_vbslider_forum_contentLR'];
	$align = $vbulletin->options['dbtech_vbslider_forum_align'];
	$msglength = $vbulletin->options['dbtech_vbslider_forum_msglength'];
	$cms = 'N';
}
if (intval($vbulletin->versionnumber) == 4)
{
    $vbver = true;
    $selectsql = ' contenttype.class, attachment.attachmentid as previewimage, fd.width, fd.height';
	$contentsql = 'LEFT JOIN ' . TABLE_PREFIX . 'contenttype as contenttype ON (contenttype.contenttypeid = attachment.contenttypeid)';
    $attachsql = 'attachment.contentid = post.postid';
    $filedatasql = 'LEFT JOIN ' . TABLE_PREFIX . 'filedata as fd ON (attachment.filedataid = fd.filedataid)';
} else {
    $vbver = false;
    $selectsql = ' attachment.attachmentid as previewimage';
    $contentsql = '';
    $attachsql = 'attachment.postid = post.postid';
    $filedatasql = '';
}

// Get user-selected forums to threads
$selected = explode(',', $forumlist); 
if ($selected)
{
	if (in_array(-1, $selected))
	{
		$forumids = array_keys($vbulletin->forumcache);
	}
	else
	{
		$forumids = $selected;
	}
}
else
{
	$forumids = array_keys($this->registry->forumcache);
}
foreach ((array)$forumids AS $forumid)
{
	$forumperms =& $vbulletin->userinfo['forumpermissions']["$forumid"];
	if ($forumperms & $vbulletin->bf_ugp_forumpermissions['canview']
		AND ($forumperms & $vbulletin->bf_ugp_forumpermissions['canviewothers'])
		AND (($forumperms & $vbulletin->bf_ugp_forumpermissions['canviewthreads']))
		AND verify_forum_password($forumid, $vbulletin->forumcache["$forumid"]['password'], false)
		)
	{ 
		$forumchoice[] = $forumid;
	}
}
if (!empty($forumchoice))
{
	$forumsql = "AND thread.forumid IN(" . implode(',', $forumchoice) . ")";
}

// remove threads from users on the global ignore list if user is not a moderator
$globalthreadignore = '';
$globalblogignore = '';
if (trim($vbulletin->options['globalignore']) != '')
{
	require_once(DIR . '/includes/functions_bigthree.php');
	if ($Coventry = fetch_coventry('string'))
	{
		$globalthreadignore = "AND thread.postuserid NOT IN ($Coventry) ";
		$globalblogignore = "AND blog.userid NOT IN ($Coventry) ";		
	}
} 

//Get user-selected sections for articles
$sectionidsql = '';
if (!in_array(-1, explode(',', $sectionlist)))
{
	$sectionidsql = " AND cms_node.parentnode IN (-1";
	foreach (explode(',', $sectionlist) AS $catid)
	{
		$sectionidsql .= ",$catid";
	}
	$sectionidsql .= ")";
}

//Get user-selected categories for blogs
$catidsql = '';
if (!in_array(-2, (array)$blogcat))
{
	if (in_array(-1, (array)$blogcat))
	{
		$catidsql .= " AND (cu.blogcategoryid IS NULL OR cu.blogcategoryid IN (-1";
	}
	else
	{
		$catidsql .= " AND (cu.blogcategoryid IN (-1";
	}
	foreach ((array)$blogcat AS $catid)
	{
		$catidsql .= ",$catid";
	}
	$catidsql .= "))";

	if (!empty($vbulletin->registry->userinfo['blogcategorypermissions']['cantview']))
	{
		$catidsql .= " AND cu.blogcategoryid NOT IN (" . implode(", ", $vbulletin->registry->userinfo['blogcategorypermissions']['cantview']) . ")";
	}
}
// query last threads from visible / chosen forums
$thread = $vbulletin->db->query_read("SELECT thread.threadid, thread.title, thread.dateline, forum.forumid, forum.title_clean as forumtitle, post.pagetext AS message, $selectsql
FROM " . TABLE_PREFIX . "thread AS thread
INNER JOIN " . TABLE_PREFIX . "forum AS forum ON(forum.forumid = thread.forumid)
LEFT JOIN " . TABLE_PREFIX . "post AS post ON (post.postid = thread.firstpostid)
LEFT JOIN " . TABLE_PREFIX . "attachment AS attachment ON ($attachsql)
$contentsql
$filedatasql
WHERE 1=1
$forumsql
AND thread.visible = 1
AND post.visible = 1
AND open <> 10
AND thread.dateline <= " . TIMENOW . "
$globalthreadignore
GROUP BY thread.threadid 
ORDER BY thread.dateline DESC
LIMIT 0," . $threadqty);

// query last articles from visible / chosen sections
if (file_exists(DIR . '/packages/vbcms/content.php') && $article != 'N/A')
{
    $article = $vbulletin->db->query_read("SELECT cms_article.contentid, cms_article.pagetext AS message, cms_node.nodeid, cms_node.url, cms_node.publishdate, cms_nodeinfo.title, cms_article.previewimage
    FROM " . TABLE_PREFIX . "cms_article AS cms_article
    INNER JOIN " . TABLE_PREFIX . "cms_node AS cms_node ON ( cms_node.contentid = cms_article.contentid )
    INNER JOIN " . TABLE_PREFIX . "cms_nodeinfo AS cms_nodeinfo ON ( cms_nodeinfo.nodeid = cms_node.nodeid )
    LEFT JOIN " . TABLE_PREFIX . "cms_nodecategory AS cms_nodecategory ON ( cms_node.nodeid = cms_nodecategory.nodeid )
    WHERE 1 =1
    $sectionidsql
    AND cms_node.setpublish =1
    AND cms_node.publishdate <= " . TIMENOW . "
    AND cms_node.publicpreview =1
    ORDER BY cms_node.publishdate DESC
    LIMIT 0," . $articleqty);
}
// query last custom entries
$custom = $vbulletin->db->query_read("SELECT custom.contentid, custom.pagetext AS message, custom.url, custom.publishdate, custom.title, custom.previewimage, custom.contentLR, custom.align, custom.in_cms, custom.in_forum, custom.target
FROM " . TABLE_PREFIX . "dbtech_vbslider_customcontent AS custom
WHERE 1 =1
AND custom.publishdate <= " . TIMENOW . "
ORDER BY custom.publishdate DESC
LIMIT 0,". $customqty);

// query last blog entries
if (file_exists(DIR . '/packages/vbblog/attach/blogentry.php') && $blog != 'N/A')
{
    $blog = $vbulletin->db->query_read("SELECT blog.blogid, blog.title, blog.dateline AS publishdate, blog_text.blogtextid, blog_text.pagetext AS message, $selectsql
        FROM " . TABLE_PREFIX . "blog AS blog
        INNER JOIN " . TABLE_PREFIX . "blog_text AS blog_text ON (blog_text.blogtextid = blog.firstblogtextid)
        LEFT JOIN " . TABLE_PREFIX . "blog_categoryuser AS cu ON (cu.blogid = blog.blogid)
		LEFT JOIN " . TABLE_PREFIX . "contenttype as contenttype ON (contenttype.class = 'BlogEntry')
		LEFT JOIN " . TABLE_PREFIX . "attachment AS attachment ON ( attachment.contentid = blog.blogid ) AND ( contenttype.contenttypeid = attachment.contenttypeid )
        $filedatasql
        WHERE 1=1
        $catidsql
        AND blog.dateline <= " . TIMENOW . "
       	$globalblogignore
		GROUP BY blog.blogid
        ORDER BY blog.dateline DESC
        LIMIT 0," . $blogqty);
}

$row = array();
if ($vbulletin->db->num_rows($thread) > 0)
{
	while($rowthread = $vbulletin->db->fetch_array($thread)){
			$image = '';
		if ($vbver) {
			$width = $rowthread['width'];
			$height = $rowthread['height'];
			if (($width > $minwidth)&& ($height > $minheight))
			{
				if ($rowthread['class'] == "Post") {
					$image = 'attachment.php?attachmentid=' . $rowthread['previewimage'];
				}
			}
		} else {
			if ($rowthread['previewimage'] != "") {
				$image = 'attachment.php?attachmentid=' . $rowthread['previewimage'];
			}
		}
		$row[] = array(
					'contentid'	    => $rowthread['threadid'], 
					'message'		=> $rowthread['message'], 
					'nodeid'		=> '',
   				    'url'			=> $vbver ? fetch_seo_url('thread', $rowthread) : 'showthread.php?'. $vbulletin->session->vars['sessionurl'] . "t=" . $rowthread['threadid'],
					'publishdate'	=> $rowthread['dateline'], 
					'title'			=> $rowthread['title'], 
					'previewimage'	=> $image, 
					'contentLR'     => $contentLR,
					'align'         => $align,
					'in_cms'		=> 1,
					'in_forum'		=> 1,
                    'target'        => '_self',
					'type'			=> 'thread');
	}
}

if ($vbulletin->db->num_rows($article) > 0) 
{
	while($rowarticle = $vbulletin->db->fetch_array($article)){
		$row[] = array(
					'contentid'	=> $rowarticle['contentid'], 
					'message'		=> $rowarticle['message'], 
					'nodeid'		=> $rowarticle['nodeid'], 
					'url'			=> $rowarticle['url'], 
					'publishdate'	=> $rowarticle['publishdate'], 
					'title'			=> $rowarticle['title'], 
					'previewimage'	=> $rowarticle['previewimage'], 
					'contentLR'     => $contentLR,
					'align'         => $align,
					'in_cms'		=> 1,
					'in_forum'		=> 1,
                    'target'        => '_self',
					'type'			=> 'article');
	}
}

if ($vbulletin->db->num_rows($custom) > 0)
{
	while($rowcustom = $vbulletin->db->fetch_array($custom)){
        $target = '';
		switch ($rowcustom['target']) {
			case 0:
                $target = '_self'; break;
            case 1:
                $target = '_blank'; break;
            case 2:
                $target = '_parent'; break;
            case 3:
                $target = '_top'; break;
		}
		$row[] = array(
					'contentid'	    => $rowcustom['contentid'], 
					'message'		=> unhtmlspecialchars($rowcustom['message']), 
					'nodeid'		=> '', 
					'url'			=> $rowcustom['url'], 
					'publishdate'	=> $rowcustom['publishdate'], 
					'title'			=> $rowcustom['title'], 
					'previewimage'	=> $rowcustom['previewimage'],
					'contentLR'     => $rowcustom['contentLR'],
					'align'         => $rowcustom['align'], 
					'in_cms'		=> $rowcustom['in_cms'],
					'in_forum'		=> $rowcustom['in_forum'],
                    'target'        => $target,	
					'type'			=> 'custom');
	}
}

if ($vbulletin->db->num_rows($blog) > 0)
{
	while($rowblog = $vbulletin->db->fetch_array($blog)){
		$image = '';
		$width = $rowblog['width'];
        $height = $rowblog['height'];
        if (($width > $minwidth)&& ($height > $minheight))
        {
    		if (!empty($rowblog['previewimage'])) {
    			$image = 'attachment.php?attachmentid=' . $rowblog['previewimage'];
    		}
        }
		$row[] = array(
					'contentid'	    => $rowblog['blogid'], 
					'message'		=> $rowblog['message'], 
					'nodeid'		=> '', 
					'url'			=> fetch_seo_url('entry', $rowblog),
					'publishdate'	=> $rowblog['publishdate'], 
					'title'			=> $rowblog['title'], 
					'previewimage'	=> $image,
					'contentLR'     => $contentLR,
					'align'         => $align, 
					'in_cms'		=> 1,
					'in_forum'		=> 1,	
                    'target'        => '_self',
					'type'			=> 'blog');
	}
}

shuffle($row);

//Output the content to the widget

$vbslidertimeout = $vbulletin->options['dbtech_vbslider_forum_timeout'];
if ($vbslidertimeout == '')
{
    $vbslidertimeout=5000;
}
if ($vbulletin->options['dbtech_vbslider_loadjquery'])
{
	$static = '<script src="http://ajax.googleapis.com/ajax/libs/jquery/' . $vbulletin->options['dbtech_vbslider_jquery_version'] . '/jquery.min.js" type="text/javascript"></script>';
}
$static .='<script src="dbtech/vbslider/clientscript/s3Slider.js" type="text/javascript"></script>
<script type="text/javascript">
jQuery.noConflict();  
	jQuery(document).ready(function() {
		jQuery(\'#slider\').s3Slider({
			timeOut: ' . $vbslidertimeout . '
		});
	});
</script>';
$static .='<div id="slider">';
$static .='   <ul id="sliderContent">';

for($i = 0; $i < count($row); $i++)
{  
	if (($cms == 'Y' && $row[$i]['in_cms'] == 1) || ($cms == 'N' && $row[$i]['in_forum'] == 1))
	{ 
		if ($row[$i]['contentLR'] == 3)
		{
			$loc = mt_rand(0,2);
		} else
		{
			$loc = $row[$i]['contentLR'];
		} 

		if ($loc == 0){
				$span = "L";
		} elseif ($loc == 1){
				$span = "R";
		} else {
				$span = "T";
		}

		if ($row[$i]['align'] == 0) {
				$span .= "L";
		} elseif ($row[$i]['align'] == 1) {
				$span .= "R";
		} else {
				$span .= "C";
		}
		
        if($imgtag == 1 && empty($row[$i]['previewimage'])) {
            $message = $row[$i]['message'];
			if(stripos($message,"[IMG]")>0)
			{
				$start=stripos($row[$i]['message'],"[IMG]");
				$end=stripos($row[$i]['message'],"[/IMG]");
				$length=$end-$start;
                if (($minheight > 0) && ($minwidth > 0) && ini_get('allow_url_fopen')) {
                    list($width, $height)= getimagesize(substr($message,$start+5,$length-5));
                }
                if(($width > $minwidth)&&($height > $minheight))
                {
				    $row[$i]['previewimage'] = substr($message,$start+5,$length-5);
                } else {
                    $row[$i]['previewimage'] = "";
                }
			} 
        } elseif($imgtag == 2) {
            $message = $row[$i]['message'];
			if(stripos($message,"[IMG]")>0)
			{
				$start=stripos($row[$i]['message'],"[IMG]");
				$end=stripos($row[$i]['message'],"[/IMG]");
				$length=$end-$start;
                if (($minheight > 0) && ($minwidth > 0) && ini_get('allow_url_fopen')) {
                    list($width, $height)= getimagesize(substr($message,$start+5,$length-5));
                }
                if(($width > $minwidth)&&($height > $minheight))
                {
				    $row[$i]['previewimage'] = substr($message,$start+5,$length-5);
                } else {
                    $row[$i]['previewimage'] = "";
                }
			}
		}
     
        if(empty($row[$i]['previewimage']))
        {
            if($row[$i]['type'] == 'article') { 
                $row[$i]['previewimage'] = $defaultcmsimage;
            } elseif($row[$i]['type'] == 'thread') {
                $row[$i]['previewimage'] = $defaultforumimage;
            } elseif($row[$i]['type'] == 'blog') {
                $row[$i]['previewimage'] = $defaultblogimage;
            }		              
        } 

    	if(strlen($row[$i]['message']) > $msglength)
		{
			$row[$i]['message'] = substr($row[$i]['message'],0,$msglength);
			$row[$i]['message'] = substr($row[$i]['message'],0,strrpos($row[$i]['message']," ")) . $dots;
		}
		if(strlen($row[$i]['message']) < 1)
		{
			$span .= '" style="height:0px; width:0px; padding:0px;';
		}
		$static .='      <li class="sliderImage">';
		$static .='          <img src="'. $row[$i]['previewimage'] . '" />';
		$static .='          <span class="' . $span . '">';
		if(strlen($row[$i]['message']) > 1)
		{
			if($row[$i]['type'] == 'article'){
				$static .='<a href="' . $vbulletin->options['bburl'] . '/content.php/' . $row[$i]['nodeid'] . '-' . $row[$i]['url'] . '"><h2>' . $row[$i]['title'] . '</h2></a>';
			} elseif(($row[$i]['type'] == 'thread') || ($row[$i]['type'] == 'blog')) {
				$static .='<a href="' .$row[$i]['url'] . '"><h2>' . $row[$i]['title'] . '</h2></a>';
			} else {
				$static .='<a href="' .$row[$i]['url'] . '" target="' . $target . '"><h2>' . $row[$i]['title'] . '</h2></a>';
			} 
			$static .=strip_bbcode($row[$i]['message'],true,true,false,true,false);
			$static .='<br /><br />';
			if(!empty($row[$i]['url'])) {
				if($row[$i]['type'] == 'article'){
					$static .='<a href="' . $vbulletin->options['bburl'] . '/content.php/' . $row[$i]['nodeid'] . '-' . $row[$i]['url'] . '">' . $rm . '</a>';
				} elseif(($row[$i]['type'] == 'thread') || ($row[$i]['type'] == 'blog')) {
					$static .='<a href="' .$row[$i]['url'] . '">' . $rm . '</a>';
				} else {
					$static .='<a href="' .$row[$i]['url'] . '" target="' . $target . '">' . $rm . '</a>';
				}
			 }
		 } 	
		$static .='      </span>';
		$static .='      </li>';
		$loc = '';
		$span = '';
	}
}
$static .='      <li>';
$static .='      <div class="clear sliderImage"></div>';
$static .='      </li>';
$static .='   </ul>';
$static .='</div>'; 


if ( $vbulletin->options['dbtech_vbslider_branding_free'] != '<:(;{DBT_vBSlIDer.Key:|:DBT_vBSlIDer.Branding.Free};):>')
{
	$slider_footer = true;
}


if ( $vbulletin->options['dbtech_vbslider_displayversion'])
{
	$slider_version = true;
}

$output['footer'] = $slider_footer;
$output['version'] = $slider_version;
$output['text'] = $static;

?>