<?php
# vbMediaWiki Vector - Copyright © 2010 bepe - http://www.vbulletin.org/forum/showthread.php?t=247279

$phrases['manual']['en-us'] = array(
	'title' => 'Manual',
	'items' => array(
		array('section',	"Introduction", "introduction"),
		array('subsection',		"What is vbMediaWiki", "vbmediawiki"),
		array('text',				"vbMediaWiki is a vBulletin plugin which provides a seamless integration the of free MediaWiki software package into the vBulletin community software."),
		array('subsection',		"The Problem", "problem"),
		array('text',				"To install vBulletin and MediaWiki to the same server is no problem at all, so you'll get two links, each to one of the software systems. The user needs to create two accounts and can use both of them separately. Mostly both software systems are meant for the same users, the forum to talk and the wiki to collect knowledge. Like a forum about cars with all the car models in the wiki."),
		array('text',				"So it seems reasonable to integrate the wiki into the forum. A good integration would mean that it looks like a part of the forum or you need to sign-on just once or you can use the same search box to get results about wiki articles and forum posts."),
		array('text',				"And that's what this Plugin is doing..."),
		array('text',				"However, these are two independent software systems, so the integration is a bit tricky."),
		array('subsection',		"What you get", "content"),
		array('subsubsection',			"Single sign-on (SSO)", "sso"),
		array('text',						"The wiki and the forum are using the same user accounts, a user logs in once and gains access to vBulletin and also to the Wiki."),
		array('image',						"sso1.png"),
		array('text',						"Signing out terminates access to both software systems."),
		array('image',						"sso2.png"),
		array('subsubsection',			"Forum Layout Integration", "layout"),
		array('text',						"The vbMediaWiki Skin that is completely integrated into the forum:"),
		array('list',						"Wiki tab on the NavBar", "Personal Wiki Links under the NavBar", "NavBits showing the location"),
		array('text',						"3 Skins for different integration types:"),
		array('list',					"[url=images/skin-vbmediawikiforum.png]Forum Skin[/url]", "[url=images/skin-vbmediawikivector.png]Integrated Vector[/url]", "[url=images/skin-vector.png]Vector[/url]"),
		array('subsubsection',			"Search Integration", "search"),
		array('text',						"The MediaWiki content is implemented as a new content type into the vBulletin search system. Search results are shown together with the results from the Forum, Blog, CMS search. Indexing is all done exactly the same way as the original vBulletin content types."),
		array('image',						"search.png"),
		array('subsubsection',			"Advanced Search", "advanced"),
		array('text',						"Search the indexed MediaWiki pages with advanced search options like title only, by user, by date and sort the results."),
		array('image',						"advanced.png"),
		array('subsubsection',			"\"What's New\" Integration", "new"),
		array('text',						"Showing a list of the last Wiki pages that where created or edited. The list is created directly from the Wiki database and does not rely on the vBulletin index."),
		array('image',						"new.png"),
		array('subsubsection',			"\"Who's Online\" integration", "who"),
		array('text',						"The \"Who's Online\" page will show a link to the actual wiki page viewed by the user. Different phrases for Viewing, Editing and History of a MediaWiki pages."),
		array('image',						"who.png"),
		array('subsubsection',			"Permissions Settings", "permissions"),
		array('text',						"Interesting might be the \"Minimum of required posts\" for editing Wiki pages; It will reduce write access to active forum members."),
		array('image',						"permissions.png"),
		array('subsubsection',			"User Stats", "stats"),
		array('text',						"Additional stats about how many pages a user edited or created."),
		array('image',						"stats.png"),
		array('subsubsection',			"Wiki Forum Stats[NEW/]", "forumstats"),
		array('text',						"Showing some Wiki stats."),
		array('image',						"forum_stats.png"),
		array('subsubsection',			"XML Sitemap Integration[NEW/]", "sitemap"),
		array('text',						"All the Wiki pages will be included when bulding the XML Sitemap in the Admin Control Panel."),

		array('section',	"System Requirements", "requirements"),
		array('text',			"This plugin was designed for only the following product versions:"),
		array('list',			"vBulletin Version: 4.0.x", "MediaWiki Version: [url=http://www.mediawiki.org/wiki/MediaWiki]1.16.0[/url]"),
		array('text',			"This plugin was designed for only the following product versions:"),

		array('section',	"Upgrade from an older vbMediaWiki Version", "upgrade"),
		array('text',			"You need to uninstall the old vBMediaWiki product inside the Admin Control Panel before installing a new version! The 'Allow Overwrite' option is not enough!"),

		array('section',	"Installation", "installation"),
		array('text',			"The forum and the wiki must have the same domain, something like:"),
		array('list',			"http://www.domain.com/ - for the forum", "http://www.domain.com/wiki/ - for the wiki"),
		
		array('subsection',		"Prepare the Server", "server"),
		array('text',				"It might be necessary to turn off magic quotes either in php.ini or in .htaccess. Else you might get this error when editing pages:"),
		array('quote',				"Error: Your edit has been rejected because your client mangled the punctuation characters in the edit token. The edit has been rejected to prevent corruption of the page text. This sometimes happens when you are using a buggy web-based anonymous proxy service."),
		array('subsection',		"Prepare vBulletin", "vbulletin"),
		array('subsubsection',		"HTML Character Set", "html"),
		array('text',					"One big problem is that MediaWiki only supports the UTF-8 charset, while vBulletin's default is ISO-8859-1. The plugin is trying to convert the wiki to the forums charset, but if you want to have it perfect, switch vBulletin's charset to UTF-8 too."),
		array('important',				"IMPORTANT: If your forum is in use already it's not that easy to change the charset, because existing posts might get messed up."),
		array('text',					"But that isn't a problem of this plugin, even without changing the charset it is doing the best to show everything as it should be."),
		array('text',					"So let's say in case of a fresh forum installation the first thing you should do is to set the forum to UTF-8, for that go to the forum's Admin Control Panel:"),
		array('step',					"Languages & Phrases", "Language Manager", "[Edit Settings]"),
		array('text',					"There set \"HTML Character Set\" to \"utf-8\" like this:"),
		array('image',					"charset.png"),
		array('subsubsection',		"Name Character Set", "name"),
		array('text',					"Next difference is the user name charset that is restriction by MediaWiki. Problem there is that every user name also is a wiki page title. Bad charters in the user name might break that page."),
		array('step',					"Settings", "Options", "User Registration Options"),
		array('text',					"There set \"Username Regular Expression\" to something like:"),
		array('code',					"^[A-Za-z0-9]+$"),
		array('text',					"This would allow alphanumeric characters only."),
		array('subsection',		"Prepare MediaWiki", "mediawiki"),
		array('text',				"You just need to install the MediaWiki Version 1.16 and do the initial setup."),
		array('text',				"For download and installation notes goto:"),
		array('link',				"http://www.mediawiki.org/wiki/MediaWiki", "http://www.mediawiki.org/wiki/MediaWiki"),
		array('subsection',		"Installing vbMediaWiki", "installing"),
		array('subsubsection',		"Modify and setup the Wiki", "wiki"),
		array('text',					"STEP 1: Upload the contents of the \"wiki upload\" directory into your wiki root directory."),
		array('text',					"STEP 2: Add this lines to the very end of your LocalSettings.php:"),
		array('code',					"define( \"VB_INSTALL_PATH\", \"<<placeholder>>\" );\nrequire_once( \"\$IP/includes/vbMediaWikiAuthPlugin.php\" );"),
		array('text',					"Replace \"<<placeholder>>\" by the relative path to your vBulletin installation. Ensure you do not add a trailing slash!"),
		array('text',					"Here are some example configurations:"),

		array('subsubsection',		"Modify and setup the Forum", "forum"),
		array('text',					"STEP 1: Upload the contents of the \"forum upload\" directory into your forum root directory."),
		array('text',					"STEP 2: Import the product product-vbmediawiki.xml via your Admin CP."),
		array('text',					"STEP 3: Go to your vBulletin Options and look for \"vBulletin MediaWiki: Options\"."),
		array('text',					"Change \"Path\" to the URL of your wiki and also enter the \"Wiki Database\" access data."),
		array('text',					"If your wiki is on a different subdomain, you need to put the full URL of your wiki path minus the trailing slash. Otherwise, just a relative directory is fine."),

		array('section',	"Settings", "settings"),
		array('subsection',		"vbMediaWiki Options", "options"),
		array('text',				"Go to the forum's Admin Control Panel:"),
		array('step',				"Settings", "Options", "vBulletin MediaWiki: Options", "Press \"Edit Settings\""),
		array('image',				"options.png"),
		array('subsubsection',		"Path", "path"),
		array('text',					"This will be used for Navbar and the search results links."),
		array('text',					"It's just the URL to your Wiki, so if this would be your Wiki domain:"),
		array('text',					"http://www.domain.com/wiki/index.php?title=PageTitle"),
		array('text',					"Then you should use this Path:"),
		array('text',					"http://www.domain.com/wiki"),
		array('text',					"It's also possible to use paths relative to the forum."),
		array('subsubsection',		"Aliases for \"Who's online\"", "aliases"),
		array('text',					"In case that you see an \"Unknown Location\" that belongs to your MediaWiki you need to add that URL to this list."),
		array('image',					"unknown.png"),
		array('text',					"Take the URL below \"Unknown Location\" and add it this way:"),
		array('list',					"If the URL contains \"index.php\", take the whole URL up to the end of that.\nExamples:\n[b][/wiki/index.php][/b]?title=PageTitle\n[b][/wiki/index.php][/b]/PageTitle",
										"Otherwise take the URL up to the last part, which should be the page title.\nExample:\n[[b]/wiki[/b]]/PageTitle"),
		array('text',					"Don't add the trailing slash or \"?\"."),
		array('subsubsection',		"Wiki Database", "database"),
		array('text',					"Fill in the connection data to the Wiki database. Use the same information you used to set up your MediaWiki."),
		array('text',					"You'll find this information in your \"LocalSettings.php\":"),
		array('code',					"## Database settings\n...\n\$wgDBserver = ...;\n\$wgDBname = ...;\n\$wgDBuser = ...;\n\$wgDBpassword = ...;\n\n# MySQL specific settings\n\$wgDBprefix = ...;"),
		array('subsection',		"Wiki Usergroup Permissions", "usergroup"),
		array('text',				"Access is set per usergroup, so go to the forum's Admin Control Panel:"),
		array('step',				"Usergroups", "Usergroup Manager"),
		array('image',				"permissions.png"),
		array('text',				"Press the 'Go' button for the Usergroup that you would like to edit, and then scroll down to \"Wiki General Permissions\""),
		array('text',				"This way you can setup the permissions for every vBulletin usergroup."),
		array('subsubsection',		"Wiki Visible", "visible"),
		array('text',					"Turning this off will:"),
		array('list',					"hide the navbar link", "hide all wiki stats from the user pages", "hide the \"what's new\" wiki entry", "don't show any wiki search results in the forum"),
		array('text',					"Just the wiki content type will still be shown in the advanced search."),
		array('text',					"Other usergroups will still have full access to everything."),
		array('subsubsection',		"Can Read", "read"),
		array('text',					"The usergroup will get this Permission error if set to \"No\":"),
		array('image',					"nopermission.png"),
		array('subsubsection',		"Can Login", "login"),
		array('text',					"No Wiki account will be created, so the user cannot edit or create pages. Without login the user cannot set his Wiki preferences."),
		array('text',					"The user will just see his IP under the Navbar like this:"),
		array('image',					"ip.png"),
		array('subsubsection',		"Is MediaWiki Sysop", "sysop"),
		array('text',					"See: [url=http://www.mediawiki.org/wiki/Project:Administrators]http://www.mediawiki.org/wiki/Project:Administrators[/url]"),
		array('subsubsection',		"Is MediaWiki Bureaucrat", "bureaucrat"),
		array('text',					"See: [url=http://www.mediawiki.org/wiki/Project:Bureaucrats]http://www.mediawiki.org/wiki/Project:Bureaucrats[/url]"),
		array('subsubsection',		"Minimum Forum Posts", "posts"),
		array('text',					"Users with fewer posts will get this notification:"),
		array('image',					"posts.png"),
		array('text',					"But the user can still read the Wiki!"),


		array('section',	"How-to", "how"),
		array('subsection',		"How users change the Wiki skin", "skin"),
		array('text',				"Every user with login permission is able to change the Wiki skin."),
		array('text',				"There are two options within the wiki preferences:"),
		array('image',				"preferences.png"),
		array('text',				"This way everyone can chose how he wants to use the wiki. Default is the \"Forum Skin\"."),
		array('subsection',		"How to use the Wiki bbcode for linking wiki pages", "bbcode"),
		array('text',				"The bbcode can be used when posting in the forum, just use it like this examples:"),
		array('code',				"[wiki]Main Page[/wiki]\n[wiki=Main Page]Check out the new wiki![/wiki]\n[wiki]User:Bepe[/wiki]\n[wiki=User:Bepe]bepe's wiki user page[/wiki]"),
		array('text',				"That wills create this links:"),
		array('text',				"[url=../index.php/Main_Page]Main Page[/url]\n[url=../index.php/Main_Page]Check out the new wiki![/url]\n[url=../index.php/User:Bepe]User:Bepe[/url]\n[url=../index.php/User:Bepe]bepe's wiki user page[/url]"),
		array('text',				"When some day you change the domain name or the path of the wiki, then the wiki links will still be working. And sure, it's shorter than writing:"),
		array('code',				"[\\url=\"http://localhost/wiki/index.php?title=Main Page\"]Main Page[/url]"),

		array('subsection',		"How to disable magic quotes on the server", "magicquotes"),
		array('text',				"Turn off magic quotes either in php.ini or in .htaccess:"),
		array('text',				"See: [url=http://www.php.net/magic_quotes]http://www.php.net/magic_quotes[/url]"),

		array('section',	"vbMediaWiki Manual and Diagnostic script", "manualdiagnostic"),
		array('subsection',		"The Manual", "manual"),
		array('text',				"Since you are reading this I might not need to explain where to find the manual :)"),
		array('text',				"Anyway, the most actual version can be found at: [url=http://www.bepe80.com/vbmediawiki]http://www.bepe80.com/vbmediawiki[/url]"),
		array('text',				"Your wiki upload files also contain a copy of it:"),
		array('text',				"Open the URL of your wiki in a browser and add \"vbmediawiki\" to the end like this:"),
		array('code',				"http://your.domain.com/wiki/vbmediawiki/"),
		array('subsection',		"The Diagnostic script", "diagnostic"),
		array('text',				"Open the URL of your wiki in a browser and add \"vbmediawiki\" to the end like this:"),
		array('code',				"http://your.domain.com/wiki/vbmediawiki/"),
		array('text',				"At the top select Diagnostic"),
		array('text',				"If your configuration is right, you should see something like this:"),
		array('image',				"diag.png"),
		array('subsection',		"The Admin script[NEW/]", "admin"),
		array('text',				"Right now there is only one item, but it might become more :)"),
		array('text',				"You need to login to the forum using an Admin account, else you will not get access."),
		array('image',				"initcounters.png"),
		
		array('section',	"Troubleshooting", "troubleshooting"),
		array('subsection',		"I can edit the Wiki but cannot save anything", "save"),
		array('text',				"Read the next problem, it should be the same."),
		array('subsection',		"I get \"Your edit has been rejected...\" when saving wiki pages", "rejected"),
		array('quote',				"Error: Your edit has been rejected because your client mangled the punctuation characters in the edit token. The edit has been rejected to prevent corruption of the page text. This sometimes happens when you are using a buggy web-based anonymous proxy service."),
		array('text',				"You need to turn off magic quotes, Check out the How To about that."),

		array('subsection',		"The wiki editor does not look like the one on the screenshots", "editor"),
		array('text',				"The new editor is just an extension for MediaWiki 1.16."),
		array('text',				"It's part of the UsabilityInitiative:"),
		array('text',				"See: [url=http://www.mediawiki.org/wiki/Extension:UsabilityInitiative]http://www.mediawiki.org/wiki/Extension:UsabilityInitiative[/url]"),
		
		array('subsection',		"I don't have a file called LocalSettings.php", "localsettings"),
		array('text',				"That file is the config file of the MediaWiki. You need to install the wiki before installing this plugin. For download and instructions see: [url=http://www.mediawiki.org/wiki/MediaWiki]http://www.mediawiki.org/wiki/MediaWiki[/url]"),
	)
);
