<?php

require_once (DIR . '/vb/search/result.php');
require_once (DIR . '/includes/mediawiki_functions_search.php');

class vBMediaWiki_Search_Result_Wiki extends vB_Search_Result
{
	public static function create($id)
	{
		global $vbulletin;
		
		$wikidb = connect_wiki_db();

		$res = mysql_query(vBMediaWiki_Search_Result_Wiki::get_query("page.page_id = " . intval($id)), $wikidb['db']);
		$fields = mysql_fetch_array($res, MYSQL_ASSOC);
		mysql_free_result($res);
		
		if ( ($vbulletin->userinfo['lang_charset'] != '') AND (strtolower($vbulletin->userinfo['lang_charset']) != 'utf-8') ) {
			$fields['username']    = iconv( "UTF-8", $vbulletin->userinfo['lang_charset'] . "//TRANSLIT//IGNORE", $fields['username'] );
			$fields['title']       = iconv( "UTF-8", $vbulletin->userinfo['lang_charset'] . "//TRANSLIT//IGNORE", $fields['title'] );
			$fields['keywordtext'] = iconv( "UTF-8", $vbulletin->userinfo['lang_charset'] . "//TRANSLIT//IGNORE", $fields['keywordtext'] );
		}
		
		if ($fields)
		{
			fix_wiki_user($fields);
			$fields['dateline'] = gmmktime(
				substr($fields['dateline'], 8, 2), 
				substr($fields['dateline'], 10, 2), 
				substr($fields['dateline'], 12, 2), 
				substr($fields['dateline'], 4, 2), 
				substr($fields['dateline'], 6, 2), 
				substr($fields['dateline'], 0, 4)
			);
			$item = new vBMediaWiki_Search_Result_Wiki();
			$item->wiki['id']           = $fields['id'];
			$item->wiki['title']        = $fields['title'];
			$item->wiki['username']     = $fields['username'];
			$item->wiki['userid']       = $fields['userid'];
			$item->wiki['lasteditdate'] = vbdate($vbulletin->options['dateformat'], $fields['dateline'], true);
			$item->wiki['lastedittime'] = vbdate($vbulletin->options['timeformat'], $fields['dateline'], true);
			$item->wiki['views']        = $fields['views'];
			$item->wiki['pagetext']     = $fields['keywordtext'];

			return $item;
		}
		return new vB_Search_Result_Null();
	}
	
	private static function get_query($filter)
	{
		$wikidb = connect_wiki_db();

		return "
			SELECT page.page_id AS id, page.page_title AS title, LEFT(text.old_text, 32) AS keywordtext, page.page_counter AS views, page.page_touched AS dateline, revision.rev_user_text AS username
			FROM {$wikidb['prefix']}page AS page
			INNER JOIN {$wikidb['prefix']}revision AS revision ON page.page_latest = revision.rev_id
			INNER JOIN {$wikidb['prefix']}text AS text ON revision.rev_text_id = text.old_id
			WHERE (revision.rev_deleted = 0 AND page.page_namespace = 0 AND page.page_is_redirect = 0) AND ($filter)
			";
	}

	public function get_contenttype()
	{
		return vB_Search_Core::get_instance()->get_contenttypeid('vBMediaWiki', 'Wiki');
	}

	public function can_search($user)
	{
		global $vbulletin;
		if($vbulletin->userinfo['permissions']['wikipermissions'] & $vbulletin->bf_ugp_wikipermissions['wiki_visible'])
			return true;
		return false;
	}

	public function render($current_user, $criteria, $template_name = '')
	{
		global $vbulletin;
		
		$template = vB_Template::create('mediawiki_search_results');
		$template->register('wiki', $this->wiki);
		$template->register('userinfo', $vbulletin->userinfo);
		$template->register('vboptions', $vbulletin->vboptions);
		
		return $template->render();
	}

	private $wiki;
}