<?php
# vbMediaWiki Vector - Copyright © 2010 bepe - http://www.vbulletin.org/forum/showthread.php?t=247279

chdir( '..' );

// wiki WebStart also includes forum access
require_once( "./includes/WebStart.php" );

function execute() {
	global $vbmwlanguage, $vbulletin;

	if ( ($vbulletin->userinfo['permissions']['wikipermissions'] & $vbulletin->bf_ugp_wikipermissions['wiki_sysop']) == 0) {
		print_out( "<h3>*** Access denied! ***</h3>\n", 0 );
		return;
	}
	
	print_out( "<div class=\"admin\">\n", 1 );

	if ( isset( $_GET['exec'] ) )
	{
		if ( $_GET['exec'] == "initcounters") {
			initCounters();
		}
	}
	else
	{
		print_out( "<h3>Admin tools</h3>\n", 0 );
		print_out( "<ul>\n", 1 );
		print_out( "<li>[<a href=\"?language=$vbmwlanguage&do=admin&exec=initcounters\"> Init Counters </a>]</li>\n", 0 );
		print_out( "</ul>\n", -1 );
	}
		
	print_out( "</div>\n", -1 );
}

function initCounters() {
	global $vbulletin, $wgDBprefix;

	$dbr = wfGetDB( DB_SLAVE );
	$res = $dbr->query(
		"SELECT user_name AS name,
		COUNT(CASE WHEN rev_parent_id=0 THEN 1 ELSE null END) as count,
		COUNT(rev_user_text) AS editcount
		FROM {$wgDBprefix}user
		LEFT OUTER JOIN {$wgDBprefix}revision ON user_name=rev_user_text
		GROUP BY user_name", __METHOD__ );

	print_out( "<h3>Initializing Counters...</h1>\n", 0 );
	print_out( "<p>User Counts:</p>\n", 0 );
	print_out( "<ul>\n", 1 );
	while ( $row = $dbr->fetchObject( $res ) ) {

		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "user SET
				wikiedits = '" . $row->editcount . "',
				wikicreations = '" . $row->count . "'
			WHERE username = '" . $row->name . "'");
			
		print_out( "<li>" . $row->name . " (Created: " . $row->count . ", Edited: " . $row->editcount . ")</li>\n", 0 );
	}
	$dbr->freeResult( $res );
	print_out( "</ul>\n", -1 );


    $wikistats['total_pages']      = $dbr->selectField( 'page', 'COUNT(*)' );
    $wikistats['total_edits']      = $dbr->selectField( 'revision', 'COUNT(*)' );
    $wikistats['total_categories'] = $dbr->selectField( 'category', 'COUNT(*)' );
	
	build_datastore('wikistats', serialize($wikistats), 1);
	print_out( "<p>Total Pages: " . $wikistats['total_pages'] . "</p>\n", 0 );
	print_out( "<p>Total Edits: " . $wikistats['total_edits'] . "</p>\n", 0 );
	print_out( "<p>Total Categories: " . $wikistats['total_categories'] . "</p>\n", 0 );
	
	print_out( "<h3>... Done!</h1>\n", 0 );
	
	print_out( "<a href=\"?language=$vbmwlanguage&do=admin\">Back</a>\n", 0 );
}