<?php
# vbMediaWiki Vector - Copyright © 2010 bepe - http://www.vbulletin.org/forum/showthread.php?t=247279

function execute() {
	$manualitems = getPhrase('manual', 'items');

	$lastsectionindex = -1;
	$sections = array();

	if(getPhrase('manual', 'info') !== false)
		print_out( "<p class=\"info\">" . gethtml(getPhrase('manual', 'info')) . "</p>\n", 0 );
	
	print_out( "<div class=\"toc\">\n", 1 );
	foreach ($manualitems as $item) {
		$sectionindex = 0;
		switch($item[0]) {
		case "subsubsection":
			$sectionindex++;
		case "subsection":
			$sectionindex++;
		case "section":
			if ( $lastsectionindex == $sectionindex ) {
				print_out( "</li>\n", -1 );
				$sections[$sectionindex]++;
			}
			elseif ( $lastsectionindex < $sectionindex ) {
				print_out( "<ul>\n", 1 );
				$sections[$sectionindex] = 1;
			}
			else {
				while ( $lastsectionindex != $sectionindex ) {
					print_out( "</li>\n", -1 );
					print_out( "</ul>\n", -1 );
					unset($sections[$lastsectionindex]);
					$lastsectionindex--;
				}
				$sections[$sectionindex]++;
				print_out( "</li>\n", -1 );
			}
			$lastsectionindex = $sectionindex;
			print_out( "<li>\n", 1 );
			if(strpos($item[1], "[NEW/]") !== false) {
				print_out( "<a href=\"#" . $item[2] . "\">" . implode(".", $sections) . " " . gethtml(str_replace("[NEW/]", "", $item[1])) . "</a><p class=\"new\">  *NEW*</p>\n", 0 );
			}
			else {
				print_out( "<a href=\"#" . $item[2] . "\">" . implode(".", $sections) . " " . gethtml($item[1]) . "</a>\n", 0 );
			}

			break;
		}
	}
	while ( $lastsectionindex != -1 ) {
		print_out( "</li>\n", -1 );
		print_out( "</ul>\n", -1 );
		unset($sections[$lastsectionindex]);
		$lastsectionindex--;
	}
	print_out( "</div>\n", -1 );

	print_out( "<div class=\"content\">\n", 1 );
	foreach ($manualitems as $item) {
		$sectionindex = 0;
		switch($item[0]) {
		case "subsubsection":
			$sectionindex++;
		case "subsection":
			$sectionindex++;
		case "section":
			if ( $lastsectionindex == $sectionindex ) {
				print_out( "</li>\n", -1 );
				$sections[$sectionindex]++;
			}
			elseif ( $lastsectionindex < $sectionindex ) {
				print_out( "<ul>\n", 1 );
				$sections[$sectionindex] = 1;
			}
			else {
				while ( $lastsectionindex != $sectionindex ) {
					print_out( "</li>\n", -1 );
					print_out( "</ul>\n", -1 );
					unset($sections[$lastsectionindex]);
					$lastsectionindex--;
				}
				$sections[$sectionindex]++;
				print_out( "</li>\n", -1 );
			}
			$lastsectionindex = $sectionindex;
			print_out( "<li>\n", 1 );
			$h = $sectionindex + 1;
			print_out( "<h$h id=\"" . $item[2] . "\">" . implode(".", $sections) . " " . gethtml(str_replace("[NEW/]", "", $item[1])) . "</h$h>\n", 0 );
			break;
		case "text":
			print_out("<p>" . gethtml($item[1]) . "</p>\n", 0 );
			break;
		case "link":
			print_out("<a href=\"" . $item[1] . "\">" . gethtml($item[2]) . "</a>\n", 0 );
			break;
		case "important":
			print_out("<p class=\"important\">" . gethtml($item[1]) . "</p>\n", 0 );
			break;
		case "quote":
			print_out("<p class=\"quote\"><b>\"</b>" . gethtml($item[1]) . "<b>\"</b></p>\n", 0 );
			break;
		case "code":
			print_out( "<ul class=\"code\">\n", 1 );
			print_out( "<li>\n", 1 );
			print_out("<pre>" . gethtml($item[1]) . "</pre>\n", 0 );
			print_out( "</li>\n", -1 );
			print_out( "</ul>\n", -1 );
			break;
		case "list":
			print_out( "<ul class=\"list\">\n", 1 );
			print_out( "<li>" . gethtml($item[1]) . "</li>\n", 0 );
			for ($i = 2; $i < count($item); $i++) {
				print_out( "<li>" . gethtml($item[$i]) . "</li>\n", 0 );
			}
			print_out( "</ul>\n", -1 );
			break;
		case "step":
			print_out( "<ul class=\"step\">\n", 1 );
			print_out("<li>" . gethtml($item[1]), 0 );
			for ($i = 2; $i < count($item); $i++) {
				print_out("<img style=\"vertical-align:middle\" src=\"images/ARROW_RIGHT.gif\" alt=\">\" />\n", 0 );
				print_out("</li>\n", 0 );
				print_out("<li>" . gethtml($item[$i]), 0 );
			}
			print_out("</li>\n", 0 );
			print_out( "</ul>\n", -1 );
			break;
		case "image":
			print_out("<img src=\"images/$item[1]\" alt=\"$item[1]\" />\n", 0 );
			break;
		}
	}
	while ( $lastsectionindex != -1 ) {
		print_out( "</li>\n", -1 );
		print_out( "</ul>\n", -1 );
		unset($sections[$lastsectionindex]);
		$lastsectionindex--;
	}

	print_out( "</div>\n", -1 );
}