<?php
# vbMediaWiki Vector - Copyright © 2010 bepe - http://www.vbulletin.org/forum/showthread.php?t=247279
 
function check_file_list( $path, $files ) {
	$result = true;
	foreach($files as $file) {
		if( !file_exists( $path . $file ) ) {
			if($result) {
				echo( "<br />" );
				$result = false;
			}
			echo( "<strong style='color: red;'>Missing: " . $path . $file . ".</strong><br />" );
		}
	}
	return $result;
}

function endsWith( $str, $sub ) {
	return ( substr( $str, strlen( $str ) - strlen( $sub ) ) == $sub );
}

function print_error( $test, $text) {
	if( !$test ) {
		print_out( "<div class=\"error\"><p>" . gethtml(getPhrase('diagnostics', 'ERROR')) . ":</p> " . gethtml(getPhrase('diagnostics', $text)) . "</div>\n", 0 );
		exit();
	}
}

function print_ok($text) {
	print_out( "<div class=\"ok\"><p>" . gethtml(getPhrase('diagnostics', 'OK')) . ":</p> " . gethtml(getPhrase('diagnostics', $text)) . "</div>\n", 0 );
}

function execute() {
	print_out( "<div class=\"diagnostics\">\n", 1 );
	print_out( "<ul>\n", 1 );

	chdir( ".." );

	/***************************************/
	print_out( "<li>\n", 1 );
	print_out( "<h1>" . gethtml(getPhrase('diagnostics', '01STEP')) . "</h1>\n", 0 );

	print_error( file_exists( "./includes/Defines.php" ) && file_exists( "./includes/DefaultSettings.php" ) && file_exists( "./includes/ProfilerStub.php" ), '01ERROR1');
	print_error( file_exists( "./LocalSettings.php" ), '01ERROR2' );

	define('MEDIAWIKI', '1');
	require_once( "./includes/Defines.php" );
	$IP = getcwd();
	require_once( "./includes/DefaultSettings.php" );

	print_ok('01OK');

	print_out( "</li>\n", -1 );
	/***************************************/
	/***************************************/
	print_out( "<li>\n", 1 );
	print_out( "<h1>" . gethtml(getPhrase('diagnostics', '02STEP')) . "</h1>\n", 0 );

	print_error( file_exists( "./vbmediawiki/files.php" ), '02ERROR1' );
	require_once( "./vbmediawiki/files.php" );
	print_error( check_file_list( ".", $files_wiki ), '02ERROR2'  ); 

	print_ok('02OK');

	print_out( "</li>\n", -1 );
	/***************************************/
	/***************************************/
	print_out( "<li>\n", 1 );
	print_out( "<h1>" . gethtml(getPhrase('diagnostics', '03STEP')) . "</h1>\n", 0 );

	define('VBMW_DIAG', '1');
	global $vbulletin;
	require_once( "./includes/ProfilerStub.php" );
	require_once( "./LocalSettings.php" );
	print_error( defined( 'VB_INSTALL_PATH' ), '03ERROR1' );
	print_error( !endsWith( VB_INSTALL_PATH, '/' ) && !endsWith( VB_INSTALL_PATH, '\\' ), '03ERROR2' );

	print_error( file_exists( VB_INSTALL_PATH . "/global.php" ), '03ERROR3' );
	print_error( file_exists( VB_INSTALL_PATH . "/includes/config.php" ), '03ERROR4' );

	print_ok('03OK');
	
	print_out( "</li>\n", -1 );
	/***************************************/
	/***************************************/
	print_out( "<li>\n", 1 );
	print_out( "<h1>" . gethtml(getPhrase('diagnostics', '04STEP')) . "</h1>\n", 0 );

	print_error( check_file_list( VB_INSTALL_PATH, $files_forum ), '04ERROR'  ); 

	print_ok('04OK');
	
	print_out( "</li>\n", -1 );
	/***************************************/
	/***************************************/
	print_out( "<li>\n", 1 );
	print_out( "<h1>" . gethtml(getPhrase('diagnostics', '05STEP')) . "</h1>\n", 0 );

	require_once(DIR . '/includes/mediawiki_functions_search.php');
	ini_set('display_errors', 0);

	$wikidb = connect_wiki_db();

	print_error( !($wikidb['db'] === false), '05ERROR'  ); 

	print_ok('05OK');
	
	print_out( "</li>\n", -1 );
	/***************************************/
	/***************************************/
	print_out( "<li>\n", 1 );
	print_out( "<h1>" . gethtml(getPhrase('diagnostics', '06STEP')) . "</h1>\n", 0 );

	print_error( !(mysql_query("SELECT * FROM {$wikidb['prefix']}text", $wikidb['db']) === false), '06ERROR'  ); 

	print_ok('06OK');
	
	print_out( "</li>\n", -1 );
	/***************************************/
	/***************************************/
	print_out( "<li>\n", 1 );
	print_out( "<h1>" . gethtml(getPhrase('diagnostics', '07STEP')) . "</h1>\n", 0 );

	print_error( !get_magic_quotes_gpc(), '07ERROR'  ); 

	print_ok('07OK');
	
	print_out( "</li>\n", -1 );
	/***************************************/
	
	print_out( "</ul>\n", -1 );
	print_out( "</div>\n", -1 );
}
