<?php
# vbMediaWiki Vector - Copyright  2010 bepe - http://www.vbulletin.org/forum/showthread.php?t=247279

if( $wgCommandLineMode ) return;
require_once("$IP/includes/vbMediaWikiVersion.php");

// ####################### PRE-BACK-END ACTIONS ##########################
$current_dir = getcwd();
chdir( VB_INSTALL_PATH );

function exec_postvar_call_back()
{
	global $vbulletin;
	$vbulletin->noheader = false;
}

// ######################### REQUIRE BACK-END ############################
define('THIS_SCRIPT', 'mediawiki');
define('VBMEDIAWIKI_SCRIPT', true);

//global $vbulletin; // else strange bug ????
require_once('./global.php');
require_once(DIR . '/includes/functions.php');
require_once(DIR . '/vb/search/indexcontroller/queue.php');
require_once(DIR . '/includes/class_block.php');
chdir( $current_dir );

// get permissions to view forumhome
if ( !defined( 'VBMW_DIAG' ) && !($permissions['wikipermissions'] & $vbulletin->bf_ugp_wikipermissions['wiki_read']))
{
	print_no_permission();
}

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################
$wgExtensionCredits['other'][] = array(
	'path' => __FILE__,
	'name' => "vbMediaWiki",
	'description' => "<b>vbMediaWiki</b> integrates this MediaWiki into vBulletin.",
	'version' => VBMW_VERSION,
	'author' => "bepe",
	'url' => "http://www.vbulletin.org/forum/misc.php?do=producthelp&pid=vbmediawiki_vector"
);

require_once( "$IP/includes/AuthPlugin.php" );

/**
 * Users can't change their passwords here
 */
class AuthPlugin_vbMediaWiki extends AuthPlugin {
	public function allowPasswordChange() {
		return false;
	}
}
$wgAuth = new AuthPlugin_vbMediaWiki();

/**
 * Set the 'vbmediawikiskin' skin as default
 * - it must be the default skin, because the others will have no way to login
 */
// remove other skins
$wgSkipSkins = array("chick", "modern", "monobook", "cologneblue", "myskin", "nostalgia", "simple", "standard");
// Names for the skins
$wgExtensionMessagesFiles['vbMediaWiki'] = "$IP/includes/vbMediaWikiMessages.php";

/**
 * Disable email and real name
 * - Not sure yet how to solve conflicts between vBulletin and MediWiki user data changes
 */
$wgEnableEmail   = false;
$wgAllowRealName = false;

/**
 * Disabling new user registrations and anonymous edits
 * - must stay this way
 */
$wgGroupPermissions['*']['createaccount'] = false;
$wgGroupPermissions['*']['edit'] = false;
$wgGroupPermissions['Bureaucrats']['userrights'] = false;

$wgHooks['SpecialPage_initList'][] = 'SpecialPage_initListHook';
function SpecialPage_initListHook( &$aSpecialPages )
{
	unset( $aSpecialPages['Userlogout'] );
	unset( $aSpecialPages['Userlogin'] );
	unset( $aSpecialPages['Resetpass'] );
	return true;
}

$wgHooks['PersonalUrls'][] = 'PersonalUrlsHook';
function PersonalUrlsHook( &$personal_urls, &$title ) {
	global $vbulletin;
	
	unset( $personal_urls["login"] );
	unset( $personal_urls['anonlogin'] );

	$personal_urls['logout']['href'] = $vbulletin->options['bburl'] . '/login.php?do=logout&logouthash=' . $vbulletin->userinfo['logouthash'];

	$personal_urls['forum'] = array(
		'text' => 'Back to the Forum',
		'href' => $vbulletin->options['bburl'],
		'active' => false
		);
	return true;
}

$wgHooks['UserLoadFromSession'][] = 'UserLoadFromSessionHook';
function UserLoadFromSessionHook( $user, &$result ) {

	global $vbulletin, $wgContLang;

	if ( !$vbulletin->userinfo['userid'] || !($vbulletin->userinfo['permissions']['wikipermissions'] & $vbulletin->bf_ugp_wikipermissions['wiki_login']) ) {
		$user->loadDefaults();
		$result = false;
		return true;
	}
	
	$minposts = $vbulletin->userinfo['permissions']['wikiminposts'];
	if ( $vbulletin->userinfo['posts'] < $minposts ) {
		$vbulletin->noticecache = array( 'mediawiki_posts' => array( 'has_x_postcount' => array(0,$minposts + 1) ) );
		$user->loadDefaults();
		$result = false;
		return true;
	}
	
	$user = User::newFromName( $vbulletin->userinfo['username'] );

	if ( is_null($user) ) {
		// Invalid username or some other error...
		$user->loadDefaults();
		$result = false;
		return true;
	}

	if ( !$user->getID() ) {
		$user->addToDatabase();
		$user->setToken();
	}
	else $user->loadFromDatabase();

	// use $_SESSION for the case that we change the user in vb
	if ( isset( $_COOKIE["{$wgCookiePrefix}UserID"] ) ) {
		$user->doLogout();
	}
	$_SESSION['wsUserID']   = $user->getId();
	$_SESSION['wsToken']    = $user->getToken();
	$_SESSION['wsUserName'] = $user->getName();

	// Check sysop permissions.
	$user->removeGroup( 'sysop' );
	if ( $vbulletin->userinfo['permissions']['wikipermissions'] & $vbulletin->bf_ugp_wikipermissions['wiki_sysop'] ) {
		$user->addGroup( 'sysop' );
	}

	// Check bureaucrat permissions.
	$user->removeGroup( 'bureaucrat' );
	if ( $vbulletin->userinfo['permissions']['wikipermissions'] & $vbulletin->bf_ugp_wikipermissions['wiki_bureaucrat'] ) {
		$user->addGroup( 'bureaucrat' );
	}

	return true;
}

$wgHooks['userCan'][] = 'userCanHook';
function userCanHook(  &$title, &$user, $action, &$result  )
{
	global $vbulletin;
	if (!($vbulletin->userinfo['permissions']['wikipermissions'] & $vbulletin->bf_ugp_wikipermissions['wiki_read'])) {
		$result = false;
	}

	return true;
}

$wgHooks['ArticleSaveComplete'][] = 'ArticleSaveCompleteHook';
function ArticleSaveCompleteHook( &$article, &$user, $text, $summary, $minoredit, $watchthis, $sectionanchor, &$flags, $revision, &$status, $baseRevId ) {
	global $vbulletin;

	$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "user AS user
			SET user.wikiedits = user.wikiedits + 1
			WHERE userid = " . $vbulletin->userinfo['userid']);

	vb_Search_Indexcontroller_Queue::indexQueue('vBMediaWiki', 'Wiki', 'index', intval($article->getID()));

	return true;
}
 
$wgHooks['ArticleInsertComplete'][] = 'ArticleInsertCompleteHook';
function ArticleInsertCompleteHook( &$article, &$user, $text, $summary, $minoredit, $watchthis, $sectionanchor, &$flags, $revision ) {
	global $vbulletin;

	$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "user AS user
			SET user.wikicreations = user.wikicreations + 1
			WHERE userid = " . $vbulletin->userinfo['userid']);

	$dbr = wfGetDb( DB_SLAVE );
    $wikistats['total_pages']      = $dbr->selectField( 'page', 'COUNT(*)' );
    $wikistats['total_edits']      = $dbr->selectField( 'revision', 'COUNT(*)' );
    $wikistats['total_categories'] = $dbr->selectField( 'category', 'COUNT(*)' );

	build_datastore('wikistats', serialize($wikistats), 1);
	return true;
}
 
$wgHooks['ArticleDeleteComplete'][] = 'ArticleDeleteCompleteHook';
function ArticleDeleteCompleteHook( &$article, &$user, $reason, $id ) {
	vb_Search_Indexcontroller_Queue::indexQueue('vBMediaWiki', 'Wiki', 'delete', intval($id));
	return true;
}

$wgHooks['TitleMoveComplete'][] = 'TitleMoveCompleteHook';
function TitleMoveCompleteHook( &$title, &$newtitle, &$user, $oldid, $newid ) {
	vb_Search_Indexcontroller_Queue::indexQueue('vBMediaWiki', 'Wiki', 'index', intval($oldid));
	return true;
}

$wgHtml5 = false;

$wgAllowUserSkin      = $vbulletin->options['vbmediawiki_wgAllowUserSkin'] != 0;
$wgDefaultSkin        = $vbulletin->options['vbmediawiki_wgDefaultSkin'];
$wgVectorUseIconWatch = $vbulletin->options['vbmediawiki_wgVectorUseIconWatch'] != 0;
