<?php

require_once (DIR . '/vb/search/type.php');
require_once (DIR . '/packages/vbmediawiki/search/result/wiki.php');

class vBMediaWiki_Search_Type_Wiki extends vB_Search_Type
{
	public function __construct() {}
	
	/**
	 * vB_Search_Type::create_item()
	 *Returns an item of this type based on the id.
	 *
	 * @param integer $id
	 * @return the type
	 */
	public function create_item($id)
	{
		return vBMediaWiki_Search_Result_Wiki::create($id);
	}
	
	/**
	 * vB_Search_Type::get_display_name()
	 *Returns the type name suitable for display to the user.
	 *
	 * @return string
	 */
	public function get_display_name()
	{
		return new vB_Phrase('search', 'searchtype_wiki');
	}

	// ###################### Start listUi ######################
	/**
	 * vB_Search_Type::makeSearch()
	 * If we have a new search type this will create a search interface for it.
	 * This assumes we have written search and index controllers
	 *
	 * @param mixed $prefs : the array of user preferences
	 * @param mixed $contenttypeid : the content type for which we are going to
	 *    search
	 * @param array registers : any additional elements to be registered. These are
	 * 	just passed to the template
	 * @param string $template_name : name of the template to use for display. We have
	 *		a default template.
	 * @param boolean $groupable : a flag to tell whether the interface should display
	 * 	grouping option(s).
	 * @return the html for the user interfacae
	 */
	public function listUi($prefs = null, $contenttypeid = null, $registers = null, $template_name = null)
	{
		global $vbulletin, $vbphrase;

		if (! isset($template_name))
		{
			$template_name = 'mediawiki_search_input';
		}
		
		if (! isset($contenttypeid))
		{
			$contenttypeid = vB_Search_Core::get_instance()->get_contenttypeid('vBMediaWiki', 'Wiki');
		}
		
		$template = vB_Template::create($template_name);
		$template->register('securitytoken', $vbulletin->userinfo['securitytoken']);
		$template->register('class', $this->get_display_name());
		$template->register('contenttypeid',$contenttypeid);

		$prefsettings = array(
			'select'=> array('searchdate', 'beforeafter', 'starteronly'),
			'cb' => array('nocache', 'exactname'),
		 	'value' => array('query', 'searchuser'));
		$this->setPrefs($template, $prefs, $prefsettings);
		vB_Search_Searchtools::searchIntroRegisterHumanVerify($template);

		if (isset($registers) and is_array($registers) )
		{
			foreach($registers as $key => $value)
			{
				$template->register($key, htmlspecialchars_uni($value));
			}
		}
		return $template->render();
	}
	
	/**
	 * vB_Search_Type::add_advanced_search_filters()
	 * This registers any form variables that this type will handle.
	 * It's always the same as the $search_global array, so we
	 * can just register ourselves with those variables.
	 *
	 * @param mixed $criteria
	 * @param mixed $registry
	 * @return no return
	 */
	public function add_advanced_search_filters($criteria, $registry)
	{
	}

	/**
	*	Get the database information for a given field.
	*
	* This function is specific to the vbdbsearch implementation.  Should not be
	* called from outside of that package (and may not work if that package is not
	* the active search implementation).
	*
	* @return array -- map with the following fields:
	* 	'join'  array of 'joinid' => join clause.  Joins from searchcore table to the
	*			field.  These will be added to the search query to join in the field to search.
	*			Multiple clauses with the same joinid will only be added once (the last one added
	*			wins, however they should be identical).
	*		'table' string -- table alias for the field
	*		'field' string -- the field name
	*/
	public function get_db_query_info($fieldname)
	{
		return "???????????????????";
	}

	/**
	 * vB_Search_Type::additional_pref_defaults()
	 *	Return any type specific savable preferences and their defaults
	 *
	 * @return array $key => $default_value
	 * The keys need to match the form field names.
	 */
	public function additional_pref_defaults()
	{
		return array();
	}

	protected $package = "vBMediaWiki";
	protected $class = "Wiki";
}
