<?php

class FirstPostOnAllPages_Model_Post extends XFCP_FirstPostOnAllPages_Model_Post
{
      static $is_joinded = false;

	public function getPostsInThread($threadId, array $fetchOptions = array())
	{
		$limitOptions = $this->prepareLimitFetchOptions($fetchOptions);
		$stateLimit = $this->prepareStateLimitFromConditions($fetchOptions, 'post');
		$joinOptions = $this->preparePostJoinOptions($fetchOptions);

		return $this->fetchAllKeyed('
			SELECT post.*
				' . $joinOptions['selectFields'] . '
			FROM xf_post AS post
                        LEFT JOIN xf_thread AS thread ON(thread.thread_id = post.thread_id AND thread.firstpoststicked = 1)
			' . $joinOptions['joinTables'] . '
			WHERE post.thread_id = ?
			AND (((' . $stateLimit . ') ' . $this->addPositionLimit('post', $limitOptions['limit'], $limitOptions['offset']) . ') OR (post.post_id = thread.first_post_id AND thread.firstpoststicked)) 
			ORDER BY post.position ASC, post.post_date ASC
		', 'post_id', $threadId);
	}
}