<?php
/**
 *  
 *
 * @name        Esthetic_QuoteSelected_Listener
 * @package     XenForo_Esthetic
 * @version     v.1.1.0
 * @copyright   Esthetic Labs(c), 2011
 * @author      Alex Prychepa <viodele@gmail.com>
 */
class Esthetic_QuoteSelected_Listener {
    
    /**
     * @var array
     */
    protected static $phrases = array (
        'eqs_dialog_title',
        'eqs_add_sign',
        'eqs_no_sign'
    );
    
    /**
     *  <b>checkPosts</b><br />
     *    .
     * @param   string                          $hookName
     * @param   string                          $contents
     * @param   array                           $hookParams
     * @param   XenForo_Template_Abstract       $template
     * @return  bool
     */
    public static function checkPosts ($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template) {

        if (
            !XenForo_Visitor::getInstance()->hasPermission('forum', 'postThread') && 
            !XenForo_Visitor::getInstance()->hasPermission('forum', 'postReply')
        ) return false;
        
        switch ($hookName) {
            case 'page_container_head':
                $contents .= 
                    '<script type="text/javascript" src="js/esthetic/QuoteSelectedClasses.js"></script>' . "\r\n" . 
                    '<script type="text/javascript" src="js/esthetic/QuoteSelectedDriver.js"></script>' . "\r\n" . 
                    '<link rel="stylesheet" type="text/css" href="styles/esthetic/quote-selected.css" />' . "\r\n";
                break;
            case 'body':
                if (!preg_match_all ('/\<\!\-\-\[eqs\:([0-9]+)\&([0-9]+)\&([0-9]+)\&([^\&]+)\&\]\-\-\>/', $contents, $matches))
                    return false;
                $embed = array ();
                foreach ($matches[4] as $key => $user_name) {
                    $embed[(int)$matches[1][$key]] = htmlspecialchars_decode($user_name);
                }
                
                $embed = json_encode($embed);
                $embed = sprintf (
                    "<script type=\"text/javascript\">\r\n    var eqsForumData = %s;\r\n    var eqsForumPhrases = %s;\r\n</script>\r\n", 
                    $embed,
                    self::addJSPhraseArray ()
                );
                $contents = $embed . $contents;
                break;
            case 'message_content':
                global $_SESSION;
                $msg = '';
                try {
                    $msg = $hookParams['message'];
                    $_SESSION['post_id'] = isset($msg['post_id']) ? (int)$msg['post_id'] : 0;
                    $contents = preg_replace_callback (
                        '/(\<blockquote)(\s+[^\>]+)(\>)/', 
                        'Esthetic_QuoteSelected_Helpers::compileInsertion', 
                        $contents
                    );
                    if ($msg['message_state'] == 'visible') {
                        $data = sprintf (
                            '<!--[eqs:%s&%s&%s&%s&]-->',
                            $msg['post_id'], 
                            $msg['thread_id'], 
                            $msg['user_id'], 
                            htmlspecialchars($msg['username'])
                        );

                    }
                    $contents = $data . $contents;
                } catch (Exception $e) { }
                break;
        }
        
        return true;
    }
    
    /**
     *   <b>addJSPhraseArray</b><br />
     *   JSON  .
     * @return  string
     */
    protected static function addJSPhraseArray () {
        $embed = array ();
        foreach (self::$phrases as $phrase_title) {
            $st = new XenForo_Phrase ($phrase_title);
            $embed[$phrase_title] = $st->render();
        }
        $embed = json_encode($embed);
        return $embed;
    }
}